/******************************************************
 * File: HarvestDiff.java
 * created 04.03.2002 12:15:16 by moelrue
 */
package harvestgui.scripts;
import de.netcomputing.anyj.scripting.*;
import de.netcomputing.anyj.scripting.*;
import java.io.*;

public class HarvestDiff extends AJExternalService
{ 
    
    /*  
        IMPORTANT: 
        declare in AnyJ User Environtment:
        ccch_temp = [Path for Temporary Files]
        ccch_diff_tool = [Fully qualified filename.exe]
    */
    
    String outName = "HarvestDiff";
    
    public HarvestDiff() {
    }
    
    static String[] FindAJHarvestSigFile( File f )
    {
        if ( f.getAbsolutePath().length() < 4 ) // volume e.g. c:\
            return null;
        if ( f.isDirectory() )
        {
            File sig = new File( f.getParentFile(), "ajharvest.txt" );
            if ( sig.exists() )
            {
                try {
                    FileInputStream in = new FileInputStream( sig );
                    DataInputStream din = new DataInputStream( in );
                    String pack = din.readLine();
                    String repos = din.readLine();
                    in.close();
                    return new String[] { repos, pack };
                } catch ( Exception ex ) {
                    ex.printStackTrace();
                }
            } else
                return FindAJHarvestSigFile( f.getParentFile() );
        } else
            return FindAJHarvestSigFile( f.getParentFile() );
        return null;
    }
    
    
    
    public boolean canProcessSelection( Object selection )
    {
        return  (( selection instanceof File) && ((File)selection).isFile() );
    }
    
    
    
    public void doProcess( Object selection )
    {
            final Object sel = selection; 
            Thread t = new Thread()
            {
                public void run()
                {
                    try{
                    String diffTool = (String)AnyJAPI.This().getEnvironment().get("ccch_diff_tool");
                    if ( diffTool == null )
                        diffTool = "K:\\Framework\\tools\\ExamDiff.exe";
                    
                    String projj = (String)AnyJAPI.This().getEnvironment().get("ccch_project");
                    File dir = ((File)sel).getParentFile();
                    String[] projPack = FindAJHarvestSigFile( dir );
                    String proj = "";
                    if ( projPack != null )
                    {
                        proj = projPack[0];
                    }
                    
                    
                    String tmpDir =(String) AnyJAPI.This().getEnvironment().get("ccch_temp");
                    if ( tmpDir == null )
                    {
                        try {
                            tmpDir = "c:\\temp";
                            if ( ! new File( tmpDir ).exists() )
                                new File( tmpDir ).mkdirs();
                        } catch ( Exception ex ) {
                            ex.printStackTrace();
                        }
                    }
                    String reposRoot = dir.getAbsolutePath().substring((""+AnyJAPI.This().getEnvironment().get("ccch_localroot")).length());
                    
                    
                    String cline = "hco -vp " + reposRoot + " -r -cp " + tmpDir +
                    " -b " + (String) AnyJAPI.This().getEnvironment().get("ccch_repository") +
                    " -usr " + (String) AnyJAPI.This().getEnvironment().get("ccch_user") +
                    " -pw " + (String) AnyJAPI.This().getEnvironment().get("ccch_pwd") +
                    " -br " + " -en " + proj + " -st \"Implementation Phase\" -pn \"Check Out for Browse (Get)\""+" -s "+ ((File)sel).getName();
                        
                    //" -st \"Implementation Phase\" -pn \"Check Out for Browse (Get)\""
            
                    AnyJAPI.This().getOrCreateOutputPanel( "HarvestDiff" ).printLine( cline );                            
                    AnyJAPI.This().executeExternalProcess( outName, File.separator, cline );
                    
                    AnyJAPI.This().openFileDiff( "DIFF",  
                        ((File)sel).getPath(), tmpDir + java.io.File.separator + ((File)sel).getName(),
                        (File)sel, new File( tmpDir + java.io.File.separator + ((File)sel).getName() ) );
                    
                    /**
                    String cmd = diffTool + " " + ((File)sel).getPath() + " "+ tmpDir + java.io.File.separator + ((File)sel).getName();
                    
                    AnyJAPI.This().getOrCreateOutputPanel( "HarvestDiff" ).printLine( cmd );
                    AnyJAPI.This().executeExternalProcess( outName, File.separator, cmd );*/
                    }catch( Exception e)
                    {
                        AnyJAPI.This().getOrCreateOutputPanel( "HarvestDiff" ).printLine( e.getMessage() ); 
                    }
                }
            };
            
            t.start();
            
    }

}
