/******************************************************
* File: BasicApplication.java
* @autor
*
* Copyright 1999 by NetComputing GmbH, Inc.,
* Erzbergerstr. 131 76133 Karlsruhe, Germany
* www.netcomputing.de
* All rights reserved.
* 
* This software is the confidential and proprietary information
* of NetComputing, Inc. ("Confidential Information").  You
* shall not disclose such Confidential Information and shall use
* it only in accordance with the terms of the license agreement
* you entered into with NetComputing.
*/

package de.netcomputing.runtime;
import java.lang.reflect.*;
import java.awt.event.*;
import javax.swing.*;

import java.util.*;                                                 
import java.io.*;
import java.net.*;
import java.awt.*;
import java.applet.*;

/**
* This class contains some useful utility functions used by some application
* templates.
* <b>Note:</b> This class implements the Singleton pattern
*/
public class ApplicationHelper
{
	/**
	* The one and only
	*/
	static protected ApplicationHelper Singleton = null; 
	
	/**
	* The one and only instance, If you want to change the behaviour of the Application-
	* Helper class, put your subclass into the 'Singleton' instancevariable
	*/
	public static ApplicationHelper Singleton()
	{
		if ( Singleton == null )
			Singleton = new ApplicationHelper();
		return Singleton;
	}
	
	protected Vector classPath;
	protected Hashtable imageCache = new Hashtable( 31 );
	
	/*********************************************************************
	* splits a string into a vector of strings
	* i.e.: SplitSeparatedString( "myString;must;be;splitted" , ";" );
	* returns a vector containing "myString","must","be","splitted"
	*/
	public Vector splitSeparatedString( String toParse, String separator )
	{
		if ( toParse == null )
			return new Vector( 0 );
		Vector res = new Vector( 20 );
		String s = toParse;
		if ( ! s.endsWith( separator ) )
			s += separator;
		while( s.indexOf( separator ) >= 0 )
		{
			String p = s.substring( 0, s.indexOf( separator ) );
			s = s.substring( p.length() + 1 );
			p = p.trim();
			if ( p.length() > 0 )
				res.addElement( p );
		}
		return res;
	}
	
	/**
	* Replace all occurences of 'key' in the string 's' by 'value'
	*/
	public String replace( String s, String key, String value )
	{
		int i = s.indexOf( key );
		if ( i < 0 )
			return s;
		StringBuffer res = new StringBuffer( s.length() );
		res.append( s.substring( 0, i ) );
		res.append( value );
		res.append( s.substring( i+key.length() ) );
		return replace( res.toString(), key, value );
	}
	
	/**
	* Copy the given file
	*/
	public void copy( File from, File to )
	throws Exception
	{
		FileInputStream in = new FileInputStream( from );
		byte buf[] = new byte[ (int)from.length() ];
		in.read( buf, 0, buf.length );
		in.close();
		FileOutputStream out = new FileOutputStream( to );
		out.write( buf );
		out.close();
	}
	
	/**
	* Create a valid URL 
	*/
	protected String getURL( String urlOrFile ) throws MalformedURLException
	{
		try {
			if ( urlOrFile.indexOf( ":" ) >= 0 || urlOrFile.startsWith( "/" ) )
			{
				if ( urlOrFile.startsWith( "/" ) )
					return "file://"+urlOrFile;
				else
					return "file:///"+urlOrFile;
			}
			else
			{
				URL baseURL;
				String currentDirectory = System.getProperty("user.dir");
				String file = currentDirectory.replace( File.separatorChar, '/') + '/';
				if (file.charAt(0) != '/') 
					file = "/" + file;
				baseURL = new URL("file", null, file);
				return new URL(baseURL,urlOrFile).toString();
			}
		} catch ( SecurityException ex ) {
			return urlOrFile.replace( File.separatorChar, '/' );
		}
	}
	
	public String getDirectory( String file )
	{
		while ( ! new File( file ).isDirectory() )
		{
			if ( file.indexOf( File.separator ) >= 0 )
				file = file.substring( 0,
			file.lastIndexOf( File.separator )
			);
			else
				return "";
		}
		return file;
	}
	
	public String getFileName( String file )
	{
		if ( file.indexOf( File.separator ) >= 0 )
			return file.substring( 
		file.lastIndexOf( File.separator ) + 1, file.length() );    
		return file;
	}	
	
	public javax.swing.JFrame createFrameOn( Component comp )
	{
		javax.swing.JFrame frame = new javax.swing.JFrame();
		frame.getContentPane().add( "Center", comp );
		frame.pack();
		return frame;
	}
	
	/**
	* Create a Dialog wrapping the component 'comp'.
	*/
	public javax.swing.JDialog createDialogOn( Frame owner, Component comp, boolean modal )
	{
		javax.swing.JDialog frame = new javax.swing.JDialog( owner, modal );
		frame.getContentPane().add( "Center", comp );
		frame.pack();
		return frame;
	}
	
	public JMenuItem createMenuItem( final Object target, String title, int mnemonic, final String method )
	{
		JMenuItem result = new JMenuItem( title, mnemonic );
		result.setName( method );
		result.addActionListener( 
		new ActionListener() {
			public void actionPerformed( final ActionEvent e ) {
				try {
				Method m = target.getClass().getMethod( method, new Class[] { ActionEvent.class } );
				if ( m != null )
					m.invoke( target, new Object[] { e } );
				} catch ( NoSuchMethodException nse ) {
					System.out.println( "please implement the eventhandler method:"+method+"( ActionEvent e )" );
				} catch ( InvocationTargetException iex ) {
					iex.getTargetException().printStackTrace();
				} catch ( Exception ex ) {
					ex.printStackTrace();
				}
			}
	    }); 
		return result;
	}
	
	public JMenu createMenu( String title, int mnemonic )
	{
		JMenu result = new JMenu( title );
		result.setMnemonic( mnemonic );
		return result;
	}
	
	public void centerWindow( Window win )
	{
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		int w = win.getSize().width;
		int h = win.getSize().height;
		win.setLocation( d.width/2 - w / 2, d.height/2 - h / 2 );
	}
	
	public AbstractButton createToolbarAction( final Object target, String ttip, final String method, String image )
	{
		JButton b = new JButton();
		b.setToolTipText( ttip );
		b.addActionListener( 
		new ActionListener() {
			public void actionPerformed( final ActionEvent e ) {
				try {
				Method m = target.getClass().getMethod( method, new Class[] { ActionEvent.class } );
				if ( m != null )
					m.invoke( target, new Object[] { e } );
				} catch ( NoSuchMethodException nse ) {
					System.out.println( "please implement the eventhandler method:"+method+"( ActionEvent e )" );
				} catch ( InvocationTargetException iex ) {
					iex.getTargetException().printStackTrace();
				} catch ( Exception ex ) {
					ex.printStackTrace();
				}
			}
	    }); 
		Image im = getImage( target.getClass(), "images/"+image );
		b.setMargin( new Insets( 2, 2, 2, 2 ) );
		if ( im != null )
			b.setIcon( new ImageIcon( im ) ); 
		else
			b.setText( ":(" );
		return b;
	}
	
	/**
	* Return the Classpath as a Vector
	* This is useful to search for ressources (some VM's do not implement 'Class.getRessource()' 
	*/
	public Vector classPath()
	{
		if ( classPath == null )
		{
			String s = System.getProperty( "java.class.path" );
			classPath = splitSeparatedString( File.pathSeparator , s );
		}
		return classPath;
	}
	
	/**
	* Return the top container of the given component (a Frame, Window, Dialog or Applet)
	*/
	public Container getTopComponent( Component comp )
	{
		Container c = comp.getParent();
		while ( ! (c instanceof Window)  && ! (c instanceof Applet) && c != null )
		{
			c = c.getParent();
		}
		return c;
	}
	
	/**
	* Images are cached in the imageCache<br>
	* The imageCache is a Hashtable containing String=>Image Associations
	*/
	public Hashtable getImageCache()
	{
		return imageCache;
	}
	
	/**
	* tries to locate a ressource via the classpath.<br>
	* first a lookup is made relative to the package of the clazz.<br>
	* After that a lookup is made from the default package.<br>
	* special efforts are made to let this work with  .exe files
	* generated using jexegen.exe from the MS-SDK.
	*/
	public URL ressolveRessource( String name, Class clazz )
	{
		/*System.out.println( "ressolveRessource("+name+" "+clazz.getName()+" "+clazz.getClassLoader() );*/
		// retrieve the package
		String pack = "";
		try {
			pack = clazz.getName();
			int i = pack.lastIndexOf( '.' );
			pack = ( i >= 0 ) ? pack.substring( 0, i ) : "";
			pack = pack.replace( '.', '/' );
			// first look in the package
			URL url = clazz.getResource( "/"+pack+"/"+name );
			if ( url == null )
				url = clazz.getResource( "/"+name ); // global lookup
			// workaround for bug in msvm / jexegen
			if ( url != null )
			{
				String urlString = url.toString();
				if ( urlString.indexOf( "/DLL" ) >= 0 // workaround for bug with msvm-exe's 
					&& urlString.toLowerCase().indexOf( ".exe" ) >= 0 )
				{
					i = urlString.indexOf( "/DLL" );
					urlString = urlString.substring( 0, i ) + "/ZIP" + urlString.substring( i+4 );
					url = new URL( urlString );
				}
			}
			if ( url == null && name.endsWith( ".gml" ) && ! name.startsWith( "forms/" ) )
				return ressolveRessource( "forms/"+name, clazz );
			return url;
		} catch ( Exception ex ) {
			ex.printStackTrace();
			return null; 
		}
	}
	
	/**
	* return the Image with the given path <br>
	* the image is fetched using 'ressourceLoader'.getRessource()<br>
	* First a lookup is made in [package of ressourceLoader]/[relativeName]<br>
	* After that, a lookup is made using 'relativeName' as a global ressourcePath.<br> 
	* E,g, <br>
	* ressourceLoader = 'mypackage.subpackage.MyClass' <br>
	* relativeName = 'images/hello.gif' <br>
	* lookup 1: getResource( "/mypackage/subpackage/images/hello.gif" ) <br>
	* lookup 2: getResource( "/images/hello.gif" )
	*/
	public Image getImage( Class ressourceLoader, String relativeName )
	{
		return getImage( ressourceLoader, relativeName, true );
	}
	
	/**
	* same as <pre>public Image getImage( Class ressourceLoader, String relativeName )</pre>, except
	* that it is possible to enforce reloading of the image by setting <pre>cache</pre> to false.
	*/
	public Image getImage( Class ressourceLoader, String relativeName, boolean cache )
	{
		Image img = null;
		if ( cache )
			img = (Image)getImageCache().get( relativeName );
		if ( img == null )
		{
			/*try {*/
			/*System.out.println( "GETIMAGE:"+ "/"+relativeName.replace( File.separatorChar, '/' ) );*/
			URL url = ressolveRessource( 
			relativeName.replace( File.separatorChar, '/' ), ressourceLoader );
			if ( url != null )
				img = Toolkit.getDefaultToolkit().getImage( url );
		}
		if ( img != null )
			getImageCache().put( relativeName, img );
		return img;	
	}

}
