/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.serial;

import com.pi4j.io.serial.Serial;
import java.util.concurrent.LinkedTransferQueue;

public class SerialCommandQueueProcessingThread
extends Thread {
    public static final int DEAFULT_DELAY = 100;
    private boolean exiting = false;
    private final Serial serial;
    private final int delay;
    private final LinkedTransferQueue<String> queue = new LinkedTransferQueue();

    public SerialCommandQueueProcessingThread(Serial serial, int delay) {
        this.serial = serial;
        this.delay = delay;
    }

    public SerialCommandQueueProcessingThread(Serial serial) {
        this(serial, 100);
    }

    public synchronized void shutdown() {
        this.exiting = true;
    }

    public void put(String data) {
        this.queue.add(data);
    }

    @Override
    public void run() {
        while (!this.exiting) {
            if (this.queue.isEmpty()) continue;
            try {
                String data = this.queue.take();
                if (this.serial.isOpen()) {
                    this.serial.write(data);
                    this.serial.flush();
                }
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

