/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.classmgr.ClassMgrCellRenderer;
import bluej.classmgr.ClassPath;
import bluej.classmgr.ClassPathEntry;
import bluej.classmgr.ClassPathTableModel;
import bluej.classmgr.LibraryFileFilter;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class ClassMgrPrefPanel
extends JPanel
implements PrefPanelListener {
    private static final String userlibPrefix = "bluej.userlibrary";
    private JTable userLibrariesTable = null;
    private ClassPathTableModel userLibrariesModel = null;
    private ClassPath userLibraries = new ClassPath();
    private boolean classPathModified = false;

    public ClassMgrPrefPanel() {
        this.addConfigEntries(this.userLibraries, userlibPrefix);
        ArrayList<URL> userlibList = Project.getUserlibContent();
        ClassPath cp = new ClassPath(userlibList.toArray(new URL[userlibList.size()]));
        List<ClassPathEntry> userlibExtLibrariesList = cp.getEntries();
        JLabel userLibrariesTag = new JLabel(Config.getString("classmgr.userlibraries"));
        userLibrariesTag.setAlignmentX(0.0f);
        JPanel userLibPane = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.userLibrariesModel = new ClassPathTableModel(this.userLibraries);
        this.userLibrariesTable = new JTable(this.userLibrariesModel);
        this.userLibrariesTable.setSelectionMode(0);
        this.userLibrariesTable.setPreferredScrollableViewportSize(new Dimension(400, 80));
        TableColumn notfoundColumn = this.userLibrariesTable.getColumn(this.userLibrariesTable.getColumnName(0));
        notfoundColumn.setPreferredWidth(20);
        TableColumn locationColumn = this.userLibrariesTable.getColumn(this.userLibrariesTable.getColumnName(1));
        locationColumn.setPreferredWidth(280);
        scrollPane.setAlignmentY(0.0f);
        scrollPane.setViewportView(this.userLibrariesTable);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.setAlignmentY(0.0f);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JButton addButton = new JButton(Config.getString("classmgr.add"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassMgrPrefPanel.this.addUserLibrary();
            }
        });
        JButton deleteButton = new JButton(Config.getString("classmgr.delete"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassMgrPrefPanel.this.deleteUserLibrary();
            }
        });
        addButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, addButton.getPreferredSize().height));
        deleteButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, deleteButton.getPreferredSize().height));
        buttonPane.add(addButton);
        buttonPane.add(Box.createVerticalStrut(5));
        buttonPane.add(deleteButton);
        userLibPane.setAlignmentX(0.0f);
        userLibPane.add((Component)scrollPane, "Center");
        userLibPane.add((Component)buttonPane, "East");
        JScrollPane userlibExtLibrariesScrollPane = new JScrollPane();
        JList<Object> list = new JList<Object>();
        list.setListData(userlibExtLibrariesList.toArray());
        list.setCellRenderer(new ClassMgrCellRenderer());
        list.setEnabled(false);
        list.setVisibleRowCount(6);
        userlibExtLibrariesScrollPane.setViewportView(list);
        userlibExtLibrariesScrollPane.setAlignmentX(0.0f);
        String userlibLocation = Config.getString("classmgr.userliblibraries") + " (" + Config.getBlueJLibDir() + File.separator + "userlib)";
        JLabel userlibExtLibrariesTag = new JLabel(userlibLocation);
        userlibExtLibrariesTag.setAlignmentX(0.0f);
        userlibExtLibrariesTag.setLabelFor(userlibExtLibrariesScrollPane);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.generalBorder);
        this.add(userLibrariesTag);
        this.add(userLibPane);
        this.add(Box.createVerticalStrut(5));
        this.add(userlibExtLibrariesTag);
        this.add(userlibExtLibrariesScrollPane);
    }

    public ArrayList<URL> getUserConfigContent() {
        return this.userLibraries.getURLs();
    }

    private void addConfigEntries(ClassPath cp, String prefix) {
        int resourceID = 1;
        try {
            String location;
            while ((location = Config.getPropString(prefix + resourceID + ".location", null)) != null) {
                cp.addClassPath(location, "");
                ++resourceID;
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
    }

    @Override
    public void beginEditing() {
    }

    @Override
    public void revertEditing() {
        this.userLibrariesModel.revertEntries();
    }

    @Override
    public void commitEditing() {
        if (this.classPathModified) {
            DialogManager.showMessage(null, "classmgr-changes-no-effect");
            this.classPathModified = false;
        }
        this.userLibrariesModel.commitEntries();
        this.saveUserLibraries();
    }

    private void saveUserLibraries() {
        String r1;
        int resourceID = 1;
        while ((r1 = Config.removeProperty(userlibPrefix + resourceID + ".location")) != null) {
            ++resourceID;
        }
        Iterator<ClassPathEntry> it = this.userLibraries.getEntries().iterator();
        resourceID = 1;
        while (it.hasNext()) {
            ClassPathEntry nextEntry = it.next();
            Config.putPropString(userlibPrefix + resourceID + ".location", nextEntry.getPath());
            ++resourceID;
        }
    }

    private void addUserLibrary() {
        File file = FileUtility.getFile(this.getParent(), Config.getString("prefmgr.misc.addLibTitle"), null, new LibraryFileFilter(), false);
        if (file != null) {
            String librarylocation = file.getAbsolutePath();
            this.userLibrariesModel.addEntry(new ClassPathEntry(librarylocation, "", true));
            this.classPathModified = true;
        }
    }

    private void deleteUserLibrary() {
        int which = this.userLibrariesTable.getSelectedRow();
        if (which != -1) {
            this.classPathModified = true;
            this.userLibrariesModel.deleteEntry(which);
        }
    }
}

