/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.objectbench;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.objectbench.ArrayWrapper;
import bluej.debugmgr.objectbench.InvokeAction;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.extensions.BObject;
import bluej.extensions.ExtensionBridge;
import bluej.extmgr.MenuManager;
import bluej.extmgr.ObjectExtensionMenu;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.Utility;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ObjectWrapper
extends JComponent
implements Accessible,
FocusListener,
InvokeListener,
KeyListener,
NamedValue {
    static String methodException = Config.getString("debugger.objectwrapper.methodException");
    static String invocationException = Config.getString("debugger.objectwrapper.invocationException");
    static String inspect = Config.getString("debugger.objectwrapper.inspect");
    static String remove = Config.getString("debugger.objectwrapper.remove");
    static String redefinedIn = Config.getString("debugger.objectwrapper.redefined");
    static String inheritedFrom = Config.getString("debugger.objectwrapper.inherited");
    static final Color envOpColour = Config.ENV_COLOUR;
    static final Color textColour = Color.white;
    private static final Image objectImage = Config.getImageAsIcon("image.bench.object").getImage();
    private static final Image selectedObjectImage = Config.getImageAsIcon("image.bench.object-selected").getImage();
    static final Stroke selectedStroke = new BasicStroke(2.0f);
    static final Stroke normalStroke = new BasicStroke(1.0f);
    public static final int WORD_GAP = 20;
    public static final int SHADOW_SIZE = 5;
    protected static final int HGAP = 5;
    protected static final int VGAP = 6;
    public static final int WIDTH = objectImage.getWidth(null);
    public static final int HEIGHT = objectImage.getHeight(null);
    private static int itemHeight = 19;
    private static boolean itemHeightKnown = false;
    private static int itemsOnScreen;
    protected DebuggerObject obj;
    protected GenTypeClass iType;
    private String className;
    private String instanceName;
    protected String displayClassName;
    protected JPopupMenu menu;
    private Package pkg;
    private PkgMgrFrame pmf;
    private ObjectBench ob;
    private boolean isSelected = false;
    private BObject singleBObject;

    public static ObjectWrapper getWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, GenTypeClass iType, String instanceName) {
        if (obj.isArray()) {
            return new ArrayWrapper(pmf, ob, obj, instanceName);
        }
        return new ObjectWrapper(pmf, ob, obj, iType, instanceName);
    }

    protected ObjectWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, GenTypeClass iType, String instanceName) {
        if (!itemHeightKnown) {
            itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.ob = ob;
        this.obj = obj;
        this.iType = iType;
        this.setName(instanceName);
        if (obj.isNullObject()) {
            this.className = "";
            this.displayClassName = "";
        } else {
            GenTypeClass objType = obj.getGenType();
            this.className = objType.toString();
            this.displayClassName = objType.toString(true);
        }
        this.createMenu(this.findIType());
        this.enableEvents(16L);
        this.setMinimumSize(new Dimension(WIDTH, HEIGHT));
        this.setSize(WIDTH, HEIGHT);
        this.setFocusable(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public Package getPackage() {
        return this.pkg;
    }

    public PkgMgrFrame getFrame() {
        return this.pmf;
    }

    public String getClassName() {
        return this.obj.getClassName();
    }

    public String getTypeName() {
        return this.className;
    }

    @Override
    public JavaType getGenType() {
        return this.iType;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    public final synchronized BObject getBObject() {
        if (this.singleBObject == null) {
            this.singleBObject = ExtensionBridge.newBObject((ObjectWrapper)this);
        }
        return this.singleBObject;
    }

    public void prepareRemove() {
        this.pkg.getProject().removeInspectorInstance(this.obj);
    }

    private boolean classIsAccessible(Class<?> cl) {
        int clMods = cl.getModifiers();
        String classPackage = JavaNames.getPrefix(cl.getName());
        return (!Modifier.isProtected(clMods) || this.pkg.getQualifiedName().equals(classPackage)) && !Modifier.isPrivate(clMods);
    }

    private Class<?> findIType() {
        String className = this.obj.getClassName();
        Class<?> cl = this.pkg.loadClass(className);
        if (cl != null) {
            if (!this.classIsAccessible(cl)) {
                cl = this.pkg.loadClass(this.iType.classloaderName());
                while (cl != null && !this.classIsAccessible(cl)) {
                    if ((cl = cl.getSuperclass()) != null) {
                        this.iType = this.iType.mapToSuper(cl.getName());
                        continue;
                    }
                    JavaReflective objectReflective = new JavaReflective(Object.class);
                    this.iType = new GenTypeClass(objectReflective);
                }
            } else {
                this.iType = this.obj.getGenType();
            }
        }
        return cl;
    }

    protected void createMenu(Class<?> cl) {
        this.menu = new JPopupMenu(this.getName() + " operations");
        ObjectWrapper.createMethodMenuItems(this.menu, cl, this.iType, this, this.obj, this.pkg.getQualifiedName(), true);
        JMenuItem item = new JMenuItem(inspect);
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectWrapper.this.inspectObject();
            }
        });
        item.setFont(PrefMgr.getStandoutMenuFont());
        item.setForeground(envOpColour);
        item = new JMenuItem(remove);
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectWrapper.this.removeObject();
            }
        });
        item.setFont(PrefMgr.getStandoutMenuFont());
        item.setForeground(envOpColour);
        MenuManager menuManager = new MenuManager(this.menu);
        menuManager.setMenuGenerator(new ObjectExtensionMenu(this));
        menuManager.addExtensionMenu(this.pkg.getProject());
        this.add(this.menu);
    }

    public static void createMethodMenuItems(JPopupMenu menu, Class<?> cl, InvokeListener il, DebuggerObject obj, String currentPackageName, boolean showObjectMethods) {
        GenTypeClass gt = new GenTypeClass(new JavaReflective(cl));
        ObjectWrapper.createMethodMenuItems(menu, cl, gt, il, obj, currentPackageName, showObjectMethods);
    }

    public static void createMethodMenuItems(JPopupMenu menu, Class<?> cl, GenTypeClass gtype, InvokeListener il, DebuggerObject obj, String currentPackageName, boolean showObjectMethods) {
        if (cl != null) {
            View view = View.getView(cl);
            Hashtable<JMenuItem, MethodView> actions = new Hashtable<JMenuItem, MethodView>();
            Hashtable<String, String> methodsUsed = new Hashtable<String, String>();
            List<Class<?>> classes = ObjectWrapper.getClassHierarchy(cl);
            ViewFilter samePackageFilter = new ViewFilter(196613);
            ViewFilter otherPackageFilter = new ViewFilter(131073);
            ViewFilter filter = currentPackageName != null && currentPackageName.equals(view.getPackageName()) ? samePackageFilter : otherPackageFilter;
            menu.addSeparator();
            MethodView[] declaredMethods = view.getDeclaredMethods();
            GenTypeClass curType = gtype;
            if (curType == null) {
                curType = new GenTypeClass(new JavaReflective(cl));
            }
            if (itemsOnScreen <= 0) {
                itemsOnScreen = 30;
            }
            int itemLimit = itemsOnScreen - 8 - classes.size();
            ObjectWrapper.createMenuItems(menu, declaredMethods, il, filter, itemLimit, curType.getMap(), actions, methodsUsed);
            for (int i = 1; i < classes.size(); ++i) {
                Class<?> currentClass = classes.get(i);
                view = View.getView(currentClass);
                filter = currentPackageName != null && currentPackageName.equals(view.getPackageName()) ? samePackageFilter : otherPackageFilter;
                curType = curType.mapToSuper(currentClass.getName());
                if ("java.lang.Object".equals(currentClass.getName()) && !showObjectMethods) continue;
                declaredMethods = view.getDeclaredMethods();
                JMenu subMenu = new JMenu(inheritedFrom + " " + JavaNames.stripPrefix(currentClass.getName()));
                subMenu.setFont(PrefMgr.getStandoutMenuFont());
                ObjectWrapper.createMenuItems(subMenu, declaredMethods, il, filter, itemsOnScreen / 2, curType.getMap(), actions, methodsUsed);
                menu.insert(subMenu, 0);
            }
            menu.addSeparator();
        }
    }

    private static void createMenuItems(JComponent menu, MethodView[] methods, InvokeListener il, ViewFilter filter, int sizeLimit, Map<String, GenTypeParameter> genericParams, Hashtable<JMenuItem, MethodView> actions, Hashtable<String, String> methodsUsed) {
        boolean menuEmpty = true;
        Arrays.sort(methods);
        for (int i = 0; i < methods.length; ++i) {
            try {
                MethodView m = methods[i];
                if (!filter.accept(m)) continue;
                menuEmpty = false;
                String methodSignature = m.getCallSignature();
                String methodDescription = m.getLongDesc(genericParams);
                if (methodsUsed.containsKey(methodSignature)) {
                    methodDescription = methodDescription + "   [ " + redefinedIn + " " + JavaNames.stripPrefix(methodsUsed.get(methodSignature)) + " ]";
                } else {
                    methodsUsed.put(methodSignature, m.getClassName());
                }
                InvokeAction a = new InvokeAction(m, il, methodDescription);
                JMenuItem item = new JMenuItem(a);
                item.setFont(PrefMgr.getPopupMenuFont());
                actions.put(item, m);
                int itemCount = menu instanceof JMenu ? ((JMenu)menu).getMenuComponentCount() : menu.getComponentCount();
                if (itemCount >= sizeLimit) {
                    JMenu subMenu = new JMenu(Config.getString("debugger.objectwrapper.moreMethods"));
                    subMenu.setFont(PrefMgr.getStandoutMenuFont());
                    subMenu.setForeground(envOpColour);
                    menu.add(subMenu);
                    menu = subMenu;
                    sizeLimit = itemsOnScreen / 2;
                }
                menu.add(item);
                continue;
            }
            catch (Exception e) {
                Debug.reportError(methodException + e);
                e.printStackTrace();
            }
        }
        if (menuEmpty) {
            JMenuItem mi = new JMenuItem(Config.getString("debugger.objectwrapper.noMethods"));
            mi.setFont(PrefMgr.getStandoutMenuFont());
            mi.setForeground(envOpColour);
            mi.setEnabled(false);
            menu.add(mi);
        }
    }

    public static List<Class<?>> getClassHierarchy(Class<?> derivedClass) {
        ArrayList classVector = new ArrayList();
        for (Class<?> currentClass = derivedClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            classVector.add(currentClass);
        }
        return classVector;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(WIDTH, HEIGHT);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(WIDTH, HEIGHT);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(WIDTH, HEIGHT);
    }

    @Override
    public String getName() {
        return this.instanceName;
    }

    @Override
    public void setName(String newName) {
        this.instanceName = newName;
    }

    public DebuggerObject getObject() {
        return this.obj;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawUMLStyle(g2);
    }

    protected void drawUMLObjectShape(Graphics2D g, int x, int y, int w, int h, int shad, int corner) {
        g.drawImage(this.isSelected ? selectedObjectImage : objectImage, x, y, null);
    }

    protected void drawUMLObjectText(Graphics2D g, int x, int y, int w, int shad, String objName, String className) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(textColour);
        g.setFont(PrefMgr.getTargetFont());
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getAscent() + 5;
        int maxWidth = w - shad - 4;
        int totalGap = 54 - (fontHeight + fm.getAscent());
        int start = totalGap / 2;
        int aWidth = fm.stringWidth(objName);
        if (aWidth > maxWidth) {
            aWidth = maxWidth;
        }
        Utility.drawCentredText(g, objName, x + 2, y + start, maxWidth, fontHeight);
        int bWidth = fm.stringWidth(className);
        if (bWidth > maxWidth) {
            bWidth = maxWidth;
        }
        Utility.drawCentredText(g, className, x + 2, y + start + fontHeight, maxWidth, fontHeight);
    }

    protected void drawUMLStyle(Graphics2D g) {
        this.drawUMLObjectShape(g, 5, 3, WIDTH - 5, HEIGHT - 6, 5, 8);
        this.drawUMLObjectText(g, 5, 3, WIDTH - 5, 5, this.getName() + ":", this.displayClassName);
    }

    @Override
    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.isPopupTrigger()) {
            this.showMenu(evt.getX(), evt.getY());
        } else if (evt.getID() == 500) {
            if (evt.getClickCount() > 1) {
                this.inspectObject();
            } else {
                this.ob.fireObjectEvent(this);
            }
        }
        if (evt.getID() == 500 || evt.isPopupTrigger()) {
            this.requestFocusInWindow();
        }
    }

    private int calcOffset() {
        int height;
        if (!itemHeightKnown && (height = ((JComponent)this.menu.getComponent(0)).getHeight()) > 1) {
            itemHeight = height;
            itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
            itemHeightKnown = true;
        }
        int offsetFactor = 4;
        int menuCount = this.menu.getComponentCount();
        if (menuCount < 4) {
            offsetFactor = menuCount;
        }
        int menuOffset = (this.menu.getComponentCount() - offsetFactor) * itemHeight;
        return menuOffset;
    }

    public void showMenu(int x, int y) {
        if (this.menu == null) {
            return;
        }
        int menuOffset = this.calcOffset();
        this.menu.show(this, x + 1, y - menuOffset);
    }

    public void showMenu() {
        this.showMenu(WIDTH / 2, HEIGHT / 2);
    }

    protected void inspectObject() {
        ObjectInspectInvokerRecord ir = new ObjectInspectInvokerRecord(this.getName());
        this.pkg.getProject().getInspectorInstance(this.obj, this.getName(), this.pkg, ir, this.pmf);
    }

    protected void removeObject() {
        this.ob.removeObject(this, this.pkg.getId());
    }

    @Override
    public void executeMethod(final MethodView method) {
        ResultWatcher watcher = null;
        this.pkg.forgetLastSource();
        watcher = new ResultWatcher(){
            private ExpressionInformation expressionInformation;
            {
                this.expressionInformation = new ExpressionInformation(method, ObjectWrapper.this.getName(), ObjectWrapper.this.obj.getGenType());
            }

            @Override
            public void beginCompile() {
                ObjectWrapper.this.pmf.setWaitCursor(true);
            }

            @Override
            public void beginExecution(InvokerRecord ir) {
                BlueJEvent.raiseEvent(3, ir);
                ObjectWrapper.this.pmf.setWaitCursor(false);
            }

            @Override
            public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                ExecutionEvent executionEvent = new ExecutionEvent(ObjectWrapper.this.pkg, ObjectWrapper.this.obj.getClassName(), ObjectWrapper.this.instanceName);
                executionEvent.setMethodName(method.getName());
                executionEvent.setParameters(method.getParamTypes(false), ir.getArgumentValues());
                executionEvent.setResult("Normal exit");
                executionEvent.setResultObject(result);
                BlueJEvent.raiseEvent(5, executionEvent);
                ObjectWrapper.this.pkg.getProject().updateInspectors();
                this.expressionInformation.setArgumentValues(ir.getArgumentValues());
                ObjectWrapper.this.ob.addInteraction(ir);
                if (result != null && !result.isNullObject()) {
                    ObjectWrapper.this.pkg.getProject().getResultInspectorInstance(result, name, ObjectWrapper.this.pkg, ir, this.expressionInformation, ObjectWrapper.this.pmf);
                }
            }

            @Override
            public void putError(String msg, InvokerRecord ir) {
                ObjectWrapper.this.pmf.setWaitCursor(false);
            }

            @Override
            public void putException(ExceptionDescription exception, InvokerRecord ir) {
                ExecutionEvent executionEvent = new ExecutionEvent(ObjectWrapper.this.pkg, ObjectWrapper.this.obj.getClassName(), ObjectWrapper.this.instanceName);
                executionEvent.setParameters(method.getParamTypes(false), ir.getArgumentValues());
                executionEvent.setResult("An exception occurred");
                executionEvent.setException(exception);
                BlueJEvent.raiseEvent(5, executionEvent);
                ObjectWrapper.this.pkg.getProject().updateInspectors();
                ObjectWrapper.this.pkg.exceptionMessage(exception);
            }

            @Override
            public void putVMTerminated(InvokerRecord ir) {
                ExecutionEvent executionEvent = new ExecutionEvent(ObjectWrapper.this.pkg, ObjectWrapper.this.obj.getClassName(), ObjectWrapper.this.instanceName);
                executionEvent.setParameters(method.getParamTypes(false), ir.getArgumentValues());
                executionEvent.setResult("User terminated");
                BlueJEvent.raiseEvent(5, executionEvent);
            }
        };
        if (this.pmf.checkDebuggerState()) {
            Invoker invoker = new Invoker(this.pmf, method, this, watcher);
            invoker.invokeInteractive();
        }
    }

    @Override
    public void callConstructor(ConstructorView cv) {
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (isSelected) {
            this.pmf.setStatus(this.getName() + " : " + this.displayClassName);
            this.scrollRectToVisible(new Rectangle(0, 0, WIDTH, HEIGHT));
        }
        this.repaint();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public String getAccessibleName() {
                    return ObjectWrapper.this.getName() + ": " + ObjectWrapper.this.displayClassName;
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.LIST_ITEM;
                }
            };
        }
        return this.accessibleContext;
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        this.ob.keyPressed(arg0);
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        this.ob.keyReleased(arg0);
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        this.ob.keyTyped(arg0);
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.ob.objectGotFocus(this);
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.ob.getSelectedObject() == this) {
            this.ob.setSelectedObject(null);
        }
    }
}

