/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import java.io.IOException;
import java.io.Reader;

public final class EscapedUnicodeReader
extends Reader {
    Reader sourceReader;
    private boolean charIsBuffered;
    private int bufferedChar;
    private int position;
    private int line = 1;
    private int column = 1;

    public EscapedUnicodeReader(Reader source) {
        this.sourceReader = source;
    }

    public void setLineColPos(int line, int column, int position) {
        this.line = line;
        this.column = column;
        this.position = position;
    }

    @Override
    public int read(char[] buffer, int off, int len) throws IOException {
        int numRead = 0;
        while (len > 0) {
            try {
                int r = this.getChar();
                if (r == -1) break;
                buffer[off++] = (char)r;
                --len;
                ++numRead;
            }
            catch (IOException ioe) {
                if (numRead != 0) break;
                throw ioe;
            }
        }
        if (numRead == 0 && len != 0) {
            numRead = -1;
        }
        return numRead;
    }

    @Override
    public void close() throws IOException {
        this.sourceReader.close();
    }

    private int getChar() throws IOException {
        if (this.charIsBuffered) {
            this.charIsBuffered = false;
            if (this.bufferedChar != -1) {
                this.processChar((char)this.bufferedChar);
            }
            return this.bufferedChar;
        }
        int rchar = this.readSourceChar();
        if (rchar == 92) {
            int nchar = this.sourceReader.read();
            if (nchar == 117) {
                ++this.column;
                ++this.position;
                return this.readEscapedUnicodeSequence();
            }
            this.putBuffer(nchar);
            return 92;
        }
        return rchar;
    }

    private void putBuffer(int nchar) {
        this.bufferedChar = nchar;
        this.charIsBuffered = true;
    }

    private int readEscapedUnicodeSequence() throws IOException {
        int uc = this.sourceReader.read();
        while (uc == 117) {
            this.processChar((char)uc);
            uc = this.sourceReader.read();
        }
        int val = Character.digit((char)uc, 16);
        if (val == -1) {
            this.putBuffer(uc);
            return 65535;
        }
        this.processChar((char)uc);
        int i = 0;
        do {
            val *= 16;
            uc = this.sourceReader.read();
            int digitVal = Character.digit((char)uc, 16);
            if (digitVal == -1) {
                this.putBuffer(uc);
                return 65535;
            }
            this.processChar((char)uc);
            val += digitVal;
        } while (++i < 3);
        return val;
    }

    private int readSourceChar() throws IOException {
        int rchar = this.sourceReader.read();
        if (rchar != -1) {
            this.processChar((char)rchar);
        }
        return rchar;
    }

    private void processChar(char ch) {
        ++this.position;
        if (ch == '\n') {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

