/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.relay.impl;

import com.pi4j.component.relay.RelayBase;
import com.pi4j.component.relay.RelayState;
import com.pi4j.component.relay.RelayStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import java.util.Timer;

public class GpioRelayComponent
extends RelayBase {
    GpioPinDigitalOutput pin = null;
    PinState openState = PinState.LOW;
    PinState closedState = PinState.HIGH;
    Timer pulseTimer = new Timer();
    private GpioPinListenerDigital listener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioRelayComponent.this.openState) {
                GpioRelayComponent.this.notifyListeners(new RelayStateChangeEvent(GpioRelayComponent.this, RelayState.CLOSED, RelayState.OPEN));
            }
            if (event.getState() == GpioRelayComponent.this.closedState) {
                GpioRelayComponent.this.notifyListeners(new RelayStateChangeEvent(GpioRelayComponent.this, RelayState.OPEN, RelayState.CLOSED));
            }
        }
    };

    public GpioRelayComponent(GpioPinDigitalOutput pin, PinState openState, PinState closedState) {
        this(pin);
        this.openState = openState;
        this.closedState = closedState;
    }

    public GpioRelayComponent(GpioPinDigitalOutput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.listener});
    }

    @Override
    public RelayState getState() {
        if (this.pin.isState(this.openState)) {
            return RelayState.OPEN;
        }
        return RelayState.CLOSED;
    }

    @Override
    public void setState(RelayState state) {
        switch (state) {
            case OPEN: {
                if (this.isOpen()) break;
                this.pin.setState(this.openState);
                break;
            }
            case CLOSED: {
                if (this.isClosed()) break;
                this.pin.setState(this.closedState);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot set power state: " + state.toString());
            }
        }
    }

    @Override
    public void pulse(int milliseconds) {
        this.pin.pulse((long)milliseconds, this.closedState);
    }
}

