/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device.sprinkler;

import com.pi4j.device.DeviceBase;
import com.pi4j.device.sprinkler.SprinklerController;
import com.pi4j.device.sprinkler.SprinklerZone;
import java.util.ArrayList;
import java.util.List;

public abstract class SprinklerControllerBase
extends DeviceBase
implements SprinklerController {
    protected List<SprinklerZone> zones = new ArrayList<SprinklerZone>();

    @Override
    public int getZoneCount() {
        return this.zones.size();
    }

    @Override
    public List<SprinklerZone> getZones() {
        return this.zones;
    }

    @Override
    public boolean isOn() {
        for (SprinklerZone zone : this.zones) {
            if (!zone.isOn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOff() {
        return !this.isOn();
    }

    @Override
    public boolean isOn(int zone) {
        return this.zones.get(zone).isOn();
    }

    @Override
    public boolean isOff(int zone) {
        return this.zones.get(zone).isOff();
    }

    @Override
    public void on(int zone) {
        this.zones.get(zone).on();
    }

    @Override
    public void onAllZones() {
        for (SprinklerZone zone : this.zones) {
            zone.on();
        }
    }

    @Override
    public void off(int zone) {
        this.zones.get(zone).off();
    }

    @Override
    public void offAllZones() {
        for (SprinklerZone zone : this.zones) {
            zone.off();
        }
    }

    @Override
    public void setState(int zone, boolean on) {
        this.zones.get(zone).setState(on);
    }

    @Override
    public abstract boolean isRaining();
}

