/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c.impl;

import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.impl.I2CBusImpl;
import com.pi4j.jni.I2C;
import java.io.IOException;

public class I2CDeviceImpl
implements I2CDevice {
    private I2CBusImpl bus;
    private int deviceAddress;

    public I2CDeviceImpl(I2CBusImpl bus, int address) {
        this.bus = bus;
        this.deviceAddress = address;
    }

    @Override
    public void write(byte data) throws IOException {
        int ret = I2C.i2cWriteByteDirect(this.bus.fd, this.deviceAddress, data);
        if (ret < 0) {
            throw new IOException("Error writing to " + this.makeDescription() + ". Got " + ret + ".");
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int size) throws IOException {
        int ret = I2C.i2cWriteBytesDirect(this.bus.fd, this.deviceAddress, size, offset, buffer);
        if (ret < 0) {
            throw new IOException("Error writing to " + this.makeDescription() + ". Got " + ret + ".");
        }
    }

    @Override
    public void write(int address, byte data) throws IOException {
        int ret = I2C.i2cWriteByte(this.bus.fd, this.deviceAddress, address, data);
        if (ret < 0) {
            throw new IOException("Error writing to " + this.makeDescription(address) + ". Got " + ret + ".");
        }
    }

    @Override
    public void write(int address, byte[] buffer, int offset, int size) throws IOException {
        int ret = I2C.i2cWriteBytes(this.bus.fd, this.deviceAddress, address, size, offset, buffer);
        if (ret < 0) {
            throw new IOException("Error writing to " + this.makeDescription(address) + ". Got " + ret + ".");
        }
    }

    @Override
    public int read() throws IOException {
        int ret = I2C.i2cReadByteDirect(this.bus.fd, this.deviceAddress);
        if (ret < 0) {
            throw new IOException("Error reading from " + this.makeDescription() + ". Got " + ret + ".");
        }
        return ret;
    }

    @Override
    public int read(byte[] buffer, int offset, int size) throws IOException {
        int ret = I2C.i2cReadBytesDirect(this.bus.fd, this.deviceAddress, size, offset, buffer);
        if (ret < 0) {
            throw new IOException("Error reading from " + this.makeDescription() + ". Got " + ret + ".");
        }
        return ret;
    }

    @Override
    public int read(int address) throws IOException {
        int ret = I2C.i2cReadByte(this.bus.fd, this.deviceAddress, address);
        if (ret < 0) {
            throw new IOException("Error reading from " + this.makeDescription(address) + ". Got " + ret + ".");
        }
        return ret;
    }

    @Override
    public int read(int address, byte[] buffer, int offset, int size) throws IOException {
        int ret = I2C.i2cReadBytes(this.bus.fd, this.deviceAddress, address, size, offset, buffer);
        if (ret < 0) {
            throw new IOException("Error reading from " + this.makeDescription(address) + ". Got " + ret + ".");
        }
        return ret;
    }

    protected String makeDescription() {
        return this.bus.filename + " at address 0x" + Integer.toHexString(this.deviceAddress);
    }

    protected String makeDescription(int address) {
        return this.bus.filename + " at address 0x" + Integer.toHexString(this.deviceAddress) + " to address 0x" + Integer.toHexString(address);
    }
}

