/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class NimRODPopupMenuUI
extends BasicPopupMenuUI {
    private static Robot robot = null;
    private BufferedImage fondo = null;
    private MiPL mipl;

    public static ComponentUI createUI(JComponent jComponent) {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NimRODPopupMenuUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.popupMenu.setBorder(NimRODBorders.getPopupMenuBorder());
        this.popupMenu.setOpaque(false);
    }

    public void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    public void installListeners() {
        super.installListeners();
        this.mipl = new MiPL(this.popupMenu);
        this.popupMenu.addPopupMenuListener(this.mipl);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePopupMenuListener(this.mipl);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        int n2 = 220;
        try {
            n2 = NimRODLookAndFeel.getOpacity();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Color color = new Color(jComponent.getBackground().getRed(), jComponent.getBackground().getGreen(), jComponent.getBackground().getBlue(), n2);
        if (this.fondo != null) {
            graphics.drawImage(this.fondo, 0, 0, null);
        }
        graphics.setColor(color);
        graphics.fillRect(0, 0, jComponent.getWidth() - 4, jComponent.getHeight() - 4);
    }

    public Popup getPopup(JPopupMenu jPopupMenu, int n2, int n3) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = new Rectangle(n2, n3, dimension.width, dimension.height);
        this.fondo = robot.createScreenCapture(rectangle);
        return super.getPopup(jPopupMenu, n2, n3);
    }

    private class MiPL
    implements PopupMenuListener {
        JPopupMenu papi;

        public MiPL(JPopupMenu jPopupMenu) {
            this.papi = jPopupMenu;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (NimRODPopupMenuUI.this.fondo == null) {
                return;
            }
            Graphics graphics = this.papi.getRootPane().getGraphics();
            Point point = this.papi.getLocationOnScreen();
            Point point2 = this.papi.getRootPane().getLocationOnScreen();
            graphics.drawImage(NimRODPopupMenuUI.this.fondo, point.x - point2.x, point.y - point2.y, null);
            NimRODPopupMenuUI.this.fondo = null;
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

