/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.InputStream;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.swing.CGC;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.widgets.Display;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public BufferedImage handle;

    Image() {
    }

    public Image(Device device, int n2, int n3) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n2, n3);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image image, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n2) {
            case 0: {
                this.handle = new BufferedImage(image.handle.getWidth(), image.handle.getHeight(), 2);
                Graphics graphics = this.handle.getGraphics();
                graphics.drawImage(image.handle, 0, 0, null);
                graphics.dispose();
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 1: 
            case 2: {
                java.awt.Image image2 = new ImageIcon(GrayFilter.createDisabledImage(image.handle)).getImage();
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                this.handle = graphicsConfiguration.createCompatibleImage(image2.getWidth(null), image2.getHeight(null), image.handle.getColorModel().getTransparency());
                Graphics2D graphics2D = this.handle.createGraphics();
                graphics2D.drawImage(image2, 0, 0, null);
                graphics2D.dispose();
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
        }
        SWT.error(40);
    }

    public Image(Device device, Rectangle rectangle) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(device, rectangle.width, rectangle.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, imageData);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        Image.init(device, this, imageData, imageData2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream inputStream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(inputStream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String string) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(string));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.handle = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new Rectangle(0, 0, this.handle.getWidth(), this.handle.getHeight());
    }

    public ImageData getImageData() {
        ColorModel colorModel = this.handle.getColorModel();
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        int n2 = this.handle.getWidth();
        ImageData imageData = new ImageData(n2, this.handle.getHeight(), colorModel.getPixelSize(), paletteData);
        int n3 = this.handle.getHeight();
        byte[] byArray = new byte[(n2 + 7) / 8 * n3];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                int n4 = this.handle.getRGB(i2, i3);
                int n5 = paletteData.getPixel(new RGB(n4 >> 16 & 0xFF, n4 >> 8 & 0xFF, n4 & 0xFF));
                imageData.setPixel(i2, i3, n5);
                int n6 = n4 >> 24 & 0xFF;
                imageData.setAlpha(i2, i3, n6);
                if (n6 == 0) continue;
                int n7 = i2 + i3 * ((n2 + 7) / 8) * 8;
                int n8 = n7 / 8;
                byArray[n8] = (byte)(byArray[n8] | (byte)(1 << 7 - n7 % 8));
            }
        }
        imageData.maskPad = 1;
        imageData.maskData = byArray;
        return imageData;
    }

    public int hashCode() {
        return this.handle == null ? 0 : this.handle.hashCode();
    }

    void init(Device device, int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        this.handle = new BufferedImage(n2, n3, 2);
        if (!(device instanceof Display)) {
            Graphics graphics = this.handle.getGraphics();
            graphics.setColor(java.awt.Color.WHITE);
            ((Graphics2D)graphics).setBackground(java.awt.Color.WHITE);
            graphics.fillRect(0, 0, n2, n3);
        }
    }

    static void init(Device device, Image image, ImageData imageData) {
        Object object;
        image.device = device;
        if (image.handle == null) {
            image.handle = object = new BufferedImage(imageData.width, imageData.height, 2);
            if (!(device instanceof Display)) {
                Graphics graphics = ((BufferedImage)object).getGraphics();
                graphics.setColor(java.awt.Color.WHITE);
                ((Graphics2D)graphics).setBackground(java.awt.Color.WHITE);
                graphics.fillRect(0, 0, imageData.width, imageData.height);
            }
        }
        object = imageData.getTransparencyMask();
        for (int i2 = image.handle.getWidth() - 1; i2 >= 0; --i2) {
            for (int i3 = image.handle.getHeight() - 1; i3 >= 0; --i3) {
                int n2;
                RGB rGB = imageData.palette.getRGB(imageData.getPixel(i2, i3));
                int n3 = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                rGB = ((ImageData)object).palette.getRGB(((ImageData)object).getPixel(i2, i3));
                int n4 = rGB.red << 16 | rGB.green << 8 | rGB.blue;
                if (n4 == 0 || (n2 = imageData.getAlpha(i2, i3)) <= 0) continue;
                n3 = n3 & 0xFFFFFF | n2 << 24;
                image.handle.setRGB(i2, i3, n3);
            }
        }
    }

    static void init(Device device, Image image, ImageData imageData, ImageData imageData2) {
        int n2;
        int n3;
        RGB[] rGBArray;
        Object object;
        ImageData imageData3;
        if (imageData.palette.isDirect) {
            imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette);
        } else {
            RGB[] rGBArray2;
            object = new RGB(0, 0, 0);
            rGBArray = imageData.getRGBs();
            if (imageData.transparentPixel != -1) {
                rGBArray2 = new RGB[rGBArray.length];
                System.arraycopy(rGBArray, 0, rGBArray2, 0, rGBArray.length);
                if (imageData.transparentPixel >= rGBArray2.length) {
                    rGBArray = new RGB[imageData.transparentPixel + 1];
                    System.arraycopy(rGBArray2, 0, rGBArray, 0, rGBArray2.length);
                    for (n3 = rGBArray2.length; n3 <= imageData.transparentPixel; ++n3) {
                        rGBArray[n3] = new RGB(0, 0, 0);
                    }
                } else {
                    rGBArray2[imageData.transparentPixel] = object;
                    rGBArray = rGBArray2;
                }
                n2 = imageData.transparentPixel;
                imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, new PaletteData(rGBArray));
            } else {
                for (n2 = 0; n2 < rGBArray.length && !rGBArray[n2].equals(object); ++n2) {
                }
                if (n2 == rGBArray.length) {
                    if (1 << imageData.depth > rGBArray.length) {
                        rGBArray2 = new RGB[rGBArray.length + 1];
                        System.arraycopy(rGBArray, 0, rGBArray2, 0, rGBArray.length);
                        rGBArray2[rGBArray.length] = object;
                        rGBArray = rGBArray2;
                    } else {
                        n2 = -1;
                    }
                }
                imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, new PaletteData(rGBArray));
            }
        }
        if (n2 == -1) {
            System.arraycopy(imageData.data, 0, imageData3.data, 0, imageData3.data.length);
        } else {
            object = new int[imageData3.width];
            rGBArray = (RGB[])new int[imageData2.width];
            for (int i2 = 0; i2 < imageData3.height; ++i2) {
                imageData.getPixels(0, i2, imageData3.width, (int[])object, 0);
                imageData2.getPixels(0, i2, imageData2.width, (int[])rGBArray, 0);
                for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                    if (rGBArray[n3] != false) continue;
                    object[n3] = n2;
                }
                imageData3.setPixels(0, i2, imageData.width, (int[])object, 0);
            }
        }
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        Image.init(device, image, imageData3);
    }

    void init(Device device, ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        Image.init(device, this, imageData);
    }

    public CGC internal_new_GC(GCData gCData) {
        Graphics2D graphics2D;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (gCData != null) {
            int n2 = 0x6000000;
            if ((gCData.style & n2) != 0) {
                gCData.layout = (gCData.style & 0x4000000) == 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.image = this;
            gCData.hFont = LookAndFeelUtils.getSystemFont();
        }
        if ((graphics2D = (Graphics2D)this.handle.getGraphics()) == null) {
            return null;
        }
        return new CGC.CGCGraphics2D(){

            public Graphics2D getGraphics() {
                return g2;
            }

            public Dimension getDeviceSize() {
                return new Dimension(Image.this.handle.getWidth(), Image.this.handle.getHeight());
            }
        };
    }

    public void internal_dispose_GC(CGC cGC, GCData gCData) {
        cGC.dispose();
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public void setBackground(Color color) {
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image swing_new(Device device, int n2, java.awt.Image image) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image2 = new Image();
        image2.type = n2;
        image2.handle = Image.duplicateImage(image);
        image2.device = device;
        return image2;
    }

    static BufferedImage duplicateImage(java.awt.Image image) {
        Object object;
        int n2;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        if (image instanceof BufferedImage) {
            n2 = ((BufferedImage)image).getColorModel().getTransparency();
        } else {
            object = new PixelGrabber(image, 0, 0, 1, 1, false);
            try {
                ((PixelGrabber)object).grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n2 = ((PixelGrabber)object).getColorModel().getTransparency();
        }
        object = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return object;
    }
}

