/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Style;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.swing.BrowserLocationChangedEvent;
import org.eclipse.swt.internal.swing.BrowserLocationChangingEvent;
import org.eclipse.swt.internal.swing.CBrowser;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;

class CBrowserImplementation
extends JScrollPane
implements CBrowser {
    protected Browser handle;
    protected JEditorPane editorPane;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ArrayList backActionList = new ArrayList();
    protected ArrayList forwardActionList = new ArrayList();

    public Container getSwingComponent() {
        return this.editorPane;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CBrowserImplementation(Browser browser, int n2) {
        this.handle = browser;
        this.editorPane = new JEditorPane(){

            public Color getBackground() {
                return CBrowserImplementation.this != null && CBrowserImplementation.this.userAttributeHandler != null && CBrowserImplementation.this.userAttributeHandler.background != null ? CBrowserImplementation.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CBrowserImplementation.this != null && CBrowserImplementation.this.userAttributeHandler != null && CBrowserImplementation.this.userAttributeHandler.foreground != null ? CBrowserImplementation.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CBrowserImplementation.this != null && CBrowserImplementation.this.userAttributeHandler != null && CBrowserImplementation.this.userAttributeHandler.font != null ? CBrowserImplementation.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                return CBrowserImplementation.this != null && CBrowserImplementation.this.userAttributeHandler != null && CBrowserImplementation.this.userAttributeHandler.cursor != null ? CBrowserImplementation.this.userAttributeHandler.cursor : super.getCursor();
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(this.editorPane);
        this.editorPane.setContentType("text/html");
        JViewport jViewport = this.getViewport();
        jViewport.setView(this.editorPane);
        this.init(n2);
    }

    protected void init(int n2) {
        this.editorPane.setEditable(false);
        this.editorPane.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e2) {
                if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e2.getURL();
                    String urlString = url.toExternalForm();
                    BrowserLocationChangingEvent browserLocationChangingEvent = new BrowserLocationChangingEvent(CBrowserImplementation.this, urlString);
                    CBrowserImplementation.this.handle.processEvent(browserLocationChangingEvent);
                    if (!browserLocationChangingEvent.isConsumed()) {
                        try {
                            CBrowserImplementation.this.forwardActionList.clear();
                            CBrowserImplementation.this.backActionList.add(CBrowserImplementation.this.getCurrentCommand());
                            CBrowserImplementation.this.editorPane.setPage(url);
                            CBrowserImplementation.this.handle.processEvent(new BrowserLocationChangedEvent(CBrowserImplementation.this, urlString));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        if ((n2 & 0x800) == 0) {
            this.setBorder(null);
            this.editorPane.setBorder(null);
        }
    }

    public Container getClientArea() {
        return this;
    }

    public void setBackgroundImage(Image image) {
    }

    public void setBackgroundInheritance(int n2) {
    }

    public void stop() {
    }

    protected Runnable getCurrentCommand() {
        String string = this.editorPane.getText();
        return new Runnable(){

            public void run() {
                CBrowserImplementation.this.editorPane.setText(text);
            }
        };
    }

    public boolean back() {
        if (!this.isBackEnabled()) {
            return false;
        }
        this.forwardActionList.add(this.getCurrentCommand());
        ((Runnable)this.backActionList.remove(this.backActionList.size() - 1)).run();
        return true;
    }

    public boolean forward() {
        if (!this.isForwardEnabled()) {
            return false;
        }
        this.backActionList.add(this.getCurrentCommand());
        ((Runnable)this.forwardActionList.remove(this.forwardActionList.size() - 1)).run();
        return true;
    }

    public String getURL() {
        URL uRL = this.editorPane.getPage();
        return uRL == null ? "" : uRL.toString();
    }

    public boolean setURL(String string) {
        if (string != null && string.startsWith("file://")) {
            string = "file:/" + string.substring("file://".length());
        }
        BrowserLocationChangingEvent browserLocationChangingEvent = new BrowserLocationChangingEvent(this, string);
        this.handle.processEvent(browserLocationChangingEvent);
        if (!browserLocationChangingEvent.isConsumed()) {
            try {
                this.forwardActionList.clear();
                this.backActionList.add(this.getCurrentCommand());
                this.editorPane.setPage(string);
                this.handle.processEvent(new BrowserLocationChangedEvent(this, string));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void refresh() {
        Runnable runnable = this.getCurrentCommand();
        this.editorPane.setText("");
        runnable.run();
    }

    public boolean isBackEnabled() {
        return !this.backActionList.isEmpty();
    }

    public boolean isForwardEnabled() {
        return !this.forwardActionList.isEmpty();
    }

    public boolean setText(String string) {
        try {
            this.forwardActionList.clear();
            this.backActionList.add(this.getCurrentCommand());
            this.editorPane.setText(string);
            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                this.adjustStyles();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CBrowserImplementation.this.editorPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                }
            });
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void adjustStyles() {
        StyleSheet styleSheet = ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet();
        int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
        Enumeration<?> enumeration = styleSheet.getStyleNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            CBrowserImplementation.adjustStyle(styleSheet, styleSheet.getStyle(string), n2);
        }
    }

    protected static void adjustStyle(StyleSheet styleSheet, Style style, int n2) {
        Enumeration<?> enumeration = style.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string;
            Object obj = enumeration.nextElement();
            Object object = style.getAttribute(obj);
            if (object instanceof Style) {
                CBrowserImplementation.adjustStyle(styleSheet, (Style)object, n2);
                continue;
            }
            if (!(obj instanceof CSS.Attribute) || !(string = object.toString()).endsWith("pt") && !string.endsWith("px") && !string.endsWith("mm") && !string.endsWith("cm") && !string.endsWith("pc") && !string.endsWith("in")) continue;
            try {
                double d2 = new Double(string.substring(0, string.length() - 2)) * (double)n2 / 72.0;
                styleSheet.addCSSAttribute(style, (CSS.Attribute)obj, d2 + string.substring(string.length() - 2));
            }
            catch (Exception exception) {}
        }
    }
}

