/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CTabFolder;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;

class CTabFolderImplementation
extends JTabbedPane
implements CTabFolder {
    protected TabFolder handle;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CTabFolderImplementation(TabFolder tabFolder, int n2) {
        this.handle = tabFolder;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.init(n2);
    }

    protected void init(int n2) {
        if ((n2 & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        } else {
            this.setBorder(null);
        }
        this.setTabPlacement((n2 & 0x400) != 0 ? 3 : 1);
        this.setTabLayoutPolicy(1);
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                CTabFolderImplementation.this.handle.processEvent(e2);
            }
        });
    }

    public Container getClientArea() {
        return this;
    }

    public JScrollBar getHorizontalScrollBar() {
        return null;
    }

    public JScrollBar getVerticalScrollBar() {
        return null;
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                Object object = UIManager.get("TabbedPane.contentOpaque");
                UIManager.put("TabbedPane.contentOpaque", Boolean.FALSE);
                this.updateUI();
                UIManager.put("TabbedPane.contentOpaque", object);
                this.setOpaque(true);
                break;
            }
            case 2: {
                Object object = UIManager.get("TabbedPane.contentOpaque");
                UIManager.put("TabbedPane.contentOpaque", Boolean.FALSE);
                this.updateUI();
                UIManager.put("TabbedPane.contentOpaque", object);
                this.setOpaque(false);
                break;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n2 = this.getTabCount();
        if (n2 > 0) {
            Rectangle rectangle = this.getUI().getTabBounds(this, n2 - 1);
            dimension.width = Math.max(dimension.width, rectangle.x + rectangle.width + 10);
        }
        return dimension;
    }
}

