/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;

public class JFontChooser
extends JDialog {
    private JColorChooser colorChooser;
    private JComboBox fontNameComboBox;
    private JCheckBox isFontBoldCheckBox;
    private JCheckBox isFontItalicCheckBox;
    private JCheckBox isFontStrikeThroughCheckBox;
    private JCheckBox isFontUnderlineCheckBox;
    private JTextField fontSizeTextField;
    private JLabel previewLabel;
    private SimpleAttributeSet attributes;
    private Font newFont;
    private Color newColor;
    protected ActionListener updateActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            JFontChooser.this.closeAndCancel();
        }
    };

    public JFontChooser(Dialog dialog) {
        super(dialog, "Font Chooser", true);
        this.init();
    }

    public JFontChooser(Frame frame) {
        super(frame, "Font Chooser", true);
        this.init();
    }

    protected void init() {
        Serializable serializable;
        this.setSize(484, 494);
        this.setLocation(270, 137);
        this.attributes = new SimpleAttributeSet();
        this.addWindowListener((WindowListener)((Object)new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFontChooser.this.adjustPreview();
            }
        }));
        Container container = this.getContentPane();
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 < fontArray.length; ++i2) {
            serializable = fontArray[i2];
            if (vector.contains(((Font)serializable).getFamily())) continue;
            vector.add(((Font)serializable).getFamily());
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        serializable = new JPanel();
        this.fontNameComboBox = new JComboBox(vector);
        Font font = this.fontNameComboBox.getFont();
        Map<TextAttribute, ?> map = font.getAttributes();
        this.fontNameComboBox.setSelectedItem(font.getFamily());
        this.fontNameComboBox.addActionListener(this.updateActionListener);
        this.fontSizeTextField = new JTextField("" + font.getSize(), 4);
        this.fontSizeTextField.setHorizontalAlignment(4);
        this.fontSizeTextField.addActionListener(this.updateActionListener);
        this.fontSizeTextField.addFocusListener((FocusListener)((Object)new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                JFontChooser.this.closeAndCancel();
            }
        }));
        ((Container)serializable).add(this.fontNameComboBox);
        ((Container)serializable).add(new JLabel(" Size: "));
        ((Container)serializable).add(this.fontSizeTextField);
        jPanel.add((Component)serializable, "North");
        JPanel jPanel2 = new JPanel();
        this.isFontBoldCheckBox = new JCheckBox("Bold");
        this.isFontBoldCheckBox.setSelected(font.isBold());
        this.isFontBoldCheckBox.addActionListener(this.updateActionListener);
        this.isFontItalicCheckBox = new JCheckBox("Italic");
        this.isFontItalicCheckBox.addActionListener(this.updateActionListener);
        this.isFontItalicCheckBox.setSelected(font.isItalic());
        this.isFontStrikeThroughCheckBox = new JCheckBox("Strike Through");
        if (!Compatibility.IS_JAVA_6_OR_GREATER) {
            this.isFontStrikeThroughCheckBox.setVisible(false);
        }
        this.isFontStrikeThroughCheckBox.setSelected(map.get(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON);
        this.isFontStrikeThroughCheckBox.addActionListener(this.updateActionListener);
        this.isFontUnderlineCheckBox = new JCheckBox("Underline");
        if (!Compatibility.IS_JAVA_6_OR_GREATER) {
            this.isFontUnderlineCheckBox.setVisible(false);
        }
        this.isFontUnderlineCheckBox.setSelected(map.get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON);
        this.isFontUnderlineCheckBox.addActionListener(this.updateActionListener);
        jPanel2.add(this.isFontBoldCheckBox);
        jPanel2.add(this.isFontItalicCheckBox);
        jPanel2.add(this.isFontStrikeThroughCheckBox);
        jPanel2.add(this.isFontUnderlineCheckBox);
        jPanel.add((Component)jPanel2, "South");
        container.add((Component)jPanel, "North");
        this.colorChooser = new JColorChooser(this.fontNameComboBox.getForeground());
        this.colorChooser.getSelectionModel().addChangeListener((ChangeListener)((Object)new FocusAdapter(){

            public void focusLost(FocusEvent e2) {
                JFontChooser.this.adjustPreview();
            }
        }));
        container.add((Component)this.colorChooser, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.previewLabel = new JLabel("The quick brown fox jumps over the lazy red dog.");
        this.previewLabel.setForeground(this.colorChooser.getColor());
        jPanel3.add((Component)this.previewLabel, "Center");
        JButton jButton = new JButton(LookAndFeelUtils.getOKButtonText());
        jButton.setToolTipText("Select the current font and color and clsoe the dialog");
        jButton.addActionListener((ActionListener)((Object)new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                JFontChooser.this.updatePreviewColor();
            }
        }));
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(LookAndFeelUtils.getCancelButtonText());
        jButton2.setToolTipText("Cancel the changes and close the dialog");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFontChooser.this.closeAndSave();
            }
        });
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 5));
        JPanel jPanel5 = new JPanel(new GridLayout(1, 0, 5, 5));
        jPanel5.add(jButton);
        jPanel5.add(jButton2);
        jPanel4.add(jPanel5);
        jPanel3.add((Component)jPanel4, "South");
        jPanel3.setMinimumSize(new Dimension(100, 100));
        jPanel3.setPreferredSize(new Dimension(100, 100));
        container.add((Component)jPanel3, "South");
    }

    protected void adjustPreview() {
        int n2;
        if (!StyleConstants.getFontFamily(this.attributes).equals(this.fontNameComboBox.getSelectedItem())) {
            StyleConstants.setFontFamily(this.attributes, (String)this.fontNameComboBox.getSelectedItem());
        }
        try {
            n2 = Integer.parseInt(this.fontSizeTextField.getText());
            if (StyleConstants.getFontSize(this.attributes) != n2) {
                StyleConstants.setFontSize(this.attributes, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n2 = this.isFontBoldCheckBox.isSelected() ? 1 : 0;
        if (StyleConstants.isBold(this.attributes) != n2) {
            StyleConstants.setBold(this.attributes, n2 != 0);
        }
        boolean bl = this.isFontItalicCheckBox.isSelected();
        if (StyleConstants.isItalic(this.attributes) != bl) {
            StyleConstants.setItalic(this.attributes, bl);
        }
        boolean bl2 = this.isFontStrikeThroughCheckBox.isSelected();
        if (StyleConstants.isStrikeThrough(this.attributes) != bl2) {
            StyleConstants.setStrikeThrough(this.attributes, bl2);
        }
        boolean bl3 = this.isFontUnderlineCheckBox.isSelected();
        if (StyleConstants.isUnderline(this.attributes) != bl3) {
            StyleConstants.setUnderline(this.attributes, bl3);
        }
        this.updatePreviewFont();
    }

    protected void updatePreviewFont() {
        String string = StyleConstants.getFontFamily(this.attributes);
        boolean bl = StyleConstants.isBold(this.attributes);
        boolean bl2 = StyleConstants.isItalic(this.attributes);
        boolean bl3 = StyleConstants.isStrikeThrough(this.attributes);
        boolean bl4 = StyleConstants.isUnderline(this.attributes);
        int n2 = StyleConstants.getFontSize(this.attributes);
        Font font = new Font(string, (bl ? 1 : 0) + (bl2 ? 2 : 0), n2);
        Map<TextAttribute, ?> map = font.getAttributes();
        if (bl3) {
            map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (bl4) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        this.previewLabel.setFont(new Font(map));
    }

    protected void updatePreviewColor() {
        this.previewLabel.setForeground(this.colorChooser.getColor());
        this.previewLabel.repaint();
    }

    public Font getNewFont() {
        return this.newFont;
    }

    public Color getNewColor() {
        return this.newColor;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public void closeAndSave() {
        this.newFont = this.previewLabel.getFont();
        this.newColor = this.previewLabel.getForeground();
        this.setVisible(false);
    }

    public void closeAndCancel() {
        this.newFont = null;
        this.newColor = null;
        this.setVisible(false);
    }

    public void setDefaultFont(Font font) {
        if (font == null) {
            return;
        }
        this.newFont = font;
        this.fontNameComboBox.setSelectedItem(font.getFamily());
        this.fontSizeTextField.setText(String.valueOf(font.getSize()));
        this.isFontBoldCheckBox.setSelected(font.isBold());
        this.isFontItalicCheckBox.setSelected(font.isItalic());
        Map<TextAttribute, ?> map = font.getAttributes();
        this.isFontStrikeThroughCheckBox.setSelected(map.get(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON);
        this.isFontUnderlineCheckBox.setSelected(map.get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON);
        this.adjustPreview();
    }

    public void setDefaultColor(Color color) {
        if (color == null) {
            return;
        }
        this.newColor = color;
        this.colorChooser.setColor(color);
        this.adjustPreview();
    }
}

