/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LookAndFeelUtils {
    protected LookAndFeelUtils() {
    }

    public static LookAndFeel getLookAndFeel() {
        return UIManager.getLookAndFeel();
    }

    public static Font getSystemFont() {
        if (LookAndFeelUtils.getLookAndFeel() instanceof MetalLookAndFeel) {
            return MetalLookAndFeel.getSystemTextFont();
        }
        return UIManager.getFont("Label.font");
    }

    public static Color getFocusColor() {
        try {
            if (LookAndFeelUtils.getLookAndFeel() instanceof MetalLookAndFeel) {
                return MetalLookAndFeel.getFocusColor();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getCaretBlinkRate() {
        return UIManager.getInt("TextArea.caretBlinkRate");
    }

    public static Icon getSystemIcon(int n2) {
        String string;
        switch (n2) {
            case 1: {
                string = "OptionPane.errorIcon";
                break;
            }
            case 4: {
                string = "OptionPane.questionIcon";
                break;
            }
            case 8: {
                string = "OptionPane.warningIcon";
                break;
            }
            default: {
                string = "OptionPane.informationIcon";
            }
        }
        Icon icon = UIManager.getIcon(string);
        if (icon == null) {
            icon = new MetalLookAndFeel().getDefaults().getIcon(string);
        }
        return icon;
    }

    public static Border getButtonBorder() {
        return UIManager.getBorder("Button.border");
    }

    public static Border getStandardBorder() {
        return UIManager.getBorder("TextField.border");
    }

    public static void applyLabelStyle(JComponent jComponent) {
        jComponent.setForeground(UIManager.getColor("Label.foreground"));
        jComponent.setBackground(UIManager.getColor("Label.background"));
        jComponent.setFont(UIManager.getFont("Label.font"));
        jComponent.setBorder(UIManager.getBorder("Label.border"));
    }

    public static void applyTextFieldStyle(JComponent jComponent) {
        jComponent.setForeground(UIManager.getColor("TextField.foreground"));
        jComponent.setBackground(UIManager.getColor("TextField.background"));
        jComponent.setFont(UIManager.getFont("TextField.font"));
        jComponent.setBorder(UIManager.getBorder("TextField.border"));
    }

    public static void applyPasswordFieldStyle(JComponent jComponent) {
        jComponent.setForeground(UIManager.getColor("PasswordField.foreground"));
        jComponent.setBackground(UIManager.getColor("PasswordField.background"));
        jComponent.setFont(UIManager.getFont("PasswordField.font"));
        jComponent.setBorder(UIManager.getBorder("PasswordField.border"));
    }

    public static Border getDefaultWindowBorder() {
        return BorderFactory.createLineBorder(UIManager.getColor("controlDkShadow"));
    }

    public static String getOKButtonText() {
        return UIManager.getString("OptionPane.okButtonText");
    }

    public static String getCancelButtonText() {
        return UIManager.getString("OptionPane.cancelButtonText");
    }

    public static Color getSystemColor(int n2) {
        switch (n2) {
            case 17: {
                return UIManager.getColor("controlDkShadow");
            }
            case 18: {
                return UIManager.getColor("controlShadow");
            }
            case 19: {
                return UIManager.getColor("controlLtHighlight");
            }
            case 20: {
                return UIManager.getColor("controlHighlight");
            }
            case 22: {
                return UIManager.getColor("control");
            }
            case 23: {
                return UIManager.getColor("windowBorder");
            }
            case 21: {
                return UIManager.getColor("controlText");
            }
            case 24: {
                return UIManager.getColor("textText");
            }
            case 25: {
                return UIManager.getColor("text");
            }
            case 26: {
                return UIManager.getColor("textHighlight");
            }
            case 27: {
                return UIManager.getColor("textHighlightText");
            }
            case 28: {
                return UIManager.getColor("infoText");
            }
            case 29: {
                return UIManager.getColor("info");
            }
            case 30: {
                Color color = UIManager.getColor("activeCaptionText");
                if (color == null) {
                    color = UIManager.getColor("Menu.selectionForeground");
                }
                return color;
            }
            case 31: {
                Color color = UIManager.getColor("InternalFrame.activeTitleBackground");
                if (color == null && (color = UIManager.getColor("activeCaption")) == null) {
                    color = UIManager.getColor("Menu.selectionBackground");
                }
                return color;
            }
            case 32: {
                Color color = UIManager.getColor("InternalFrame.activeTitleGradient");
                if (color == null) {
                    color = LookAndFeelUtils.getSystemColor(31);
                    color = new Color(Math.min(color.getRed() + 20, 255), Math.min(color.getGreen() + 20, 255), Math.min(color.getBlue() + 20, 255), color.getAlpha());
                }
                return color;
            }
            case 33: {
                Color color = UIManager.getColor("inactiveCaptionText");
                if (color == null) {
                    color = UIManager.getColor("Menu.foreground");
                }
                return color;
            }
            case 34: {
                Color color = UIManager.getColor("InternalFrame.inactiveTitleBackground");
                if (color == null && (color = UIManager.getColor("inactiveCaption")) == null) {
                    color = UIManager.getColor("Menu.background");
                }
                return color;
            }
            case 35: {
                Color color = UIManager.getColor("InternalFrame.inactiveTitleGradient");
                if (color == null) {
                    color = LookAndFeelUtils.getSystemColor(34);
                    color = new Color(Math.min(color.getRed() + 20, 255), Math.min(color.getGreen() + 20, 255), Math.min(color.getBlue() + 20, 255), color.getAlpha());
                }
                return color;
            }
        }
        return null;
    }
}

