/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import org.jvnet.substance.utils.FadeTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FadeStateListener {
    protected FadeTracker.FadeTrackerCallback callback;
    protected Component comp;
    protected ButtonModel buttonModel;
    protected Map<FadeTracker.FadeKind, Boolean> prevStateMap;
    protected ChangeListener modelListener;
    protected FocusListener focusListener;
    private static Set<Class> ignoreAnimationsOn = FadeStateListener.getIgnoreAnimationsOn();

    private static Set<Class> getIgnoreAnimationsOn() {
        HashSet<Class> ignoreAnimationsOn = new HashSet<Class>();
        ignoreAnimationsOn.add(ListCellRenderer.class);
        ignoreAnimationsOn.add(TreeCellRenderer.class);
        ignoreAnimationsOn.add(TableCellRenderer.class);
        ignoreAnimationsOn.add(TreeCellEditor.class);
        ignoreAnimationsOn.add(TableCellEditor.class);
        return ignoreAnimationsOn;
    }

    public FadeStateListener(Component comp, ButtonModel buttonModel, FadeTracker.FadeTrackerCallback callback) {
        this.comp = comp;
        this.buttonModel = buttonModel;
        this.callback = callback;
        this.prevStateMap = new HashMap<FadeTracker.FadeKind, Boolean>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackModelChange(FadeTracker.FadeKind fadeKind, boolean newValue) {
        for (Component currComp = this.comp; currComp != null; currComp = currComp.getParent()) {
            for (Class ignoreAnimationClazz : ignoreAnimationsOn) {
                if (!ignoreAnimationClazz.isAssignableFrom(currComp.getClass())) continue;
                return;
            }
        }
        try {
            if (this.prevStateMap.containsKey((Object)fadeKind)) {
                boolean prevValue = this.prevStateMap.get((Object)fadeKind);
                if (prevValue == newValue) {
                    return;
                }
            } else {
                if (!newValue) {
                    return;
                }
                if (fadeKind == FadeTracker.FadeKind.SELECTION) {
                    return;
                }
            }
            FadeTracker.getInstance().trackFade(this.comp, fadeKind, newValue, false, this.callback);
        }
        finally {
            this.prevStateMap.put(fadeKind, newValue);
        }
    }

    public void registerListeners() {
        this.modelListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.SELECTION, FadeStateListener.this.buttonModel.isSelected());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ARM, FadeStateListener.this.buttonModel.isArmed());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ROLLOVER, FadeStateListener.this.buttonModel.isRollover());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.ENABLE, FadeStateListener.this.buttonModel.isEnabled());
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.PRESS, FadeStateListener.this.buttonModel.isPressed());
            }
        };
        this.buttonModel.addChangeListener(this.modelListener);
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.FOCUS, true);
            }

            public void focusLost(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeTracker.FadeKind.FOCUS, false);
            }
        };
        this.comp.addFocusListener(this.focusListener);
    }

    public void unregisterListeners() {
        this.buttonModel.removeChangeListener(this.modelListener);
        this.comp.removeFocusListener(this.focusListener);
    }
}

