/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceLockBorder
extends SubstanceBorder {
    public Insets getBorderInsets(Component c) {
        Insets superRes = super.getBorderInsets(c);
        if (SubstanceCoreUtilities.hasLockIcon(c)) {
            if (c.getComponentOrientation().isLeftToRight()) {
                return new Insets(superRes.top, superRes.left + 6, superRes.bottom, superRes.right);
            }
            return new Insets(superRes.top, superRes.left, superRes.bottom, superRes.right + 6);
        }
        return superRes;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        if (SubstanceCoreUtilities.hasLockIcon(c)) {
            ColorScheme scheme = c.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getMetallicColorScheme();
            Icon lockIcon = SubstanceImageCreator.getSmallLockIcon(scheme);
            if (c.getComponentOrientation().isLeftToRight()) {
                lockIcon.paintIcon(c, g, x, y + height - lockIcon.getIconHeight());
            } else {
                lockIcon.paintIcon(c, g, x + width - lockIcon.getIconWidth(), y + height - lockIcon.getIconHeight());
            }
        }
    }
}

