/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceBubblesWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
        this.drawWatermarkImage((Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        Color stampColor = null;
        stampColor = isPreview ? (SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.white : Color.black) : SubstanceColorUtilities.getWatermarkStampColor();
        int minBubbleRadius = 10;
        int maxBubbleRadius = 20;
        int cellSize = minBubbleRadius + maxBubbleRadius;
        int rowCount = height / cellSize;
        int columnCount = width / cellSize;
        graphics.setColor(stampColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int col = 0; col <= columnCount; ++col) {
            for (int row = 0; row <= rowCount; ++row) {
                double xval = isPreview ? Math.abs(Math.sin(2.8 + (double)col + (double)(columnCount * row))) : Math.random();
                int xc = x + (int)((double)(col * cellSize) + (double)cellSize * xval);
                double yval = isPreview ? Math.abs(Math.sin(3.5 + (double)col + (double)(columnCount * row))) : Math.random();
                int yc = y + (int)((double)(row * cellSize) + (double)cellSize * yval);
                double val = isPreview ? 0.1 * Math.abs(Math.sin(1 + col + columnCount * row)) : Math.random();
                int r = minBubbleRadius + (int)(val * (double)(maxBubbleRadius - minBubbleRadius));
                graphics.drawOval(xc - r, yc - r, 2 * r, 2 * r);
                GeneralPath shine = new GeneralPath();
                shine.moveTo((float)xc - 0.2f * (float)r, (float)yc - 0.8f * (float)r);
                shine.quadTo((float)xc - 0.7f * (float)r, (float)yc - 0.6f * (float)r, (float)xc - 0.8f * (float)r, (float)yc - 0.1f * (float)r);
                shine.lineTo((float)xc - 0.3f * (float)r, (float)yc + 0.2f * (float)r);
                shine.quadTo((float)xc - 0.3f * (float)r, (float)yc - 0.4f * (float)r, xc, (float)yc - 0.6f * (float)r);
                shine.lineTo((float)xc - 0.2f * (float)r, (float)yc - 0.8f * (float)r);
                graphics.draw(shine);
            }
        }
        return true;
    }

    public String getDisplayName() {
        return SubstanceBubblesWatermark.getName();
    }

    public static String getName() {
        return "Bubbles";
    }

    public boolean isDependingOnTheme() {
        return true;
    }

    public void dispose() {
        watermarkImage = null;
    }
}

