/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreeCellRenderer;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;

public class SubstanceDefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    private boolean drawDashedFocusIndicator;
    private Color treeBGColor;
    private Color focusBGColor;

    public SubstanceDefaultTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        Object value = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
        value = UIManager.get("Tree.drawDashedFocusIndicator");
        this.drawDashedFocusIndicator = value != null && (Boolean)value != false;
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        if (sel) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.setForeground(UIManager.getColor("Tree.textForeground"));
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (leaf) {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(this.getDefaultLeafIcon(), 0.5)));
            } else if (expanded) {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(this.getDefaultOpenIcon(), 0.5)));
            } else {
                this.setDisabledIcon(SubstanceImageCreator.toGreyscale(SubstanceImageCreator.makeTransparent(this.getDefaultClosedIcon(), 0.5)));
            }
        } else {
            this.setEnabled(true);
            if (leaf) {
                this.setIcon(this.getDefaultLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getDefaultOpenIcon());
            } else {
                this.setIcon(this.getDefaultClosedIcon());
            }
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.setOpaque(false);
        this.selected = sel;
        return this;
    }

    public void paint(Graphics g) {
        Color bColor;
        if (this.selected) {
            bColor = UIManager.getColor("Tree.selectionBackground");
        } else {
            bColor = UIManager.getColor("Tree.textBackground");
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        int imageOffset = -1;
        if (!SubstanceLookAndFeel.toBleedWatermark() && bColor != null) {
            imageOffset = this.getLabelStart();
            g.setColor(bColor);
            if (this.isOpaque()) {
                if (this.getComponentOrientation().isLeftToRight()) {
                    g.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
                } else {
                    g.fillRect(0, 0, this.getWidth() - imageOffset, this.getHeight());
                }
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.paintFocus(g, imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
            } else {
                this.paintFocus(g, 0, 0, this.getWidth() - imageOffset, this.getHeight());
            }
        }
        super.paint(g);
    }

    private void paintFocus(Graphics g, int x, int y, int w, int h) {
        Color bsColor = UIManager.getColor("Tree.selectionBorderColor");
        if (bsColor != null && (this.selected || !this.drawDashedFocusIndicator)) {
            g.setColor(bsColor);
            g.drawRect(x, y, w - 1, h - 1);
        }
        if (this.drawDashedFocusIndicator) {
            Color color;
            if (this.selected) {
                color = UIManager.getColor("Tree.selectionBackground");
            } else {
                color = UIManager.getColor("Tree.textBackground");
                if (color == null) {
                    color = this.getBackground();
                }
            }
            if (this.treeBGColor != color) {
                this.treeBGColor = color;
                this.focusBGColor = new Color(~color.getRGB());
            }
            g.setColor(this.focusBGColor);
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    private int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

