/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.FocusBorderListener;
import org.jvnet.substance.utils.PasswordStrengthChecker;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstancePasswordFieldUI
extends BasicPasswordFieldUI {
    public static final int PASSWORD_DOT_DIAMETER = 7;
    public static final int PASSWORD_DOT_GAP = 2;
    public static final int PASSWORD_DOT_WIDTH = 9;
    protected FocusListener focusListener;
    protected PropertyChangeListener strengthCheckerListener;
    protected JPasswordField passwordField;
    private static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate(0.6f);

    public static ComponentUI createUI(JComponent c) {
        return new SubstancePasswordFieldUI(c);
    }

    public SubstancePasswordFieldUI(JComponent c) {
        this.passwordField = (JPasswordField)c;
    }

    public View create(Element elem) {
        return new SubstancePasswordView(elem);
    }

    public void installUI(final JComponent c) {
        super.installUI(c);
        this.focusListener = new FocusBorderListener(c);
        c.addFocusListener(this.focusListener);
        this.strengthCheckerListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("substancelaf.passwordStrengthChecker".equals(evt.getPropertyName())) {
                    Object newValue = evt.getNewValue();
                    if (newValue != null && newValue instanceof PasswordStrengthChecker) {
                        c.setBorder(new StrengthCheckedBorder());
                    } else {
                        Border coreBorder = UIManager.getBorder("PasswordField.border");
                        c.setBorder(coreBorder);
                    }
                }
            }
        };
        c.addPropertyChangeListener(this.strengthCheckerListener);
        Object checker = c.getClientProperty("substancelaf.passwordStrengthChecker");
        if (checker != null && checker instanceof PasswordStrengthChecker) {
            c.setBorder(new StrengthCheckedBorder());
        }
    }

    public void uninstallUI(JComponent c) {
        c.removeFocusListener(this.focusListener);
        this.focusListener = null;
        c.removePropertyChangeListener(this.strengthCheckerListener);
        this.strengthCheckerListener = null;
        super.uninstallUI(c);
    }

    protected void paintBackground(Graphics g) {
        super.paintBackground(g);
        if (SubstanceLookAndFeel.toBleedWatermark()) {
            bgDelegate.update(g, this.passwordField);
        }
    }

    public static PasswordStrengthChecker getPasswordStrengthChecker(JPasswordField jpf) {
        Object obj = jpf.getClientProperty("substancelaf.passwordStrengthChecker");
        if (obj != null && obj instanceof PasswordStrengthChecker) {
            return (PasswordStrengthChecker)obj;
        }
        return null;
    }

    public static int getEchoPerChar(JPasswordField jpf) {
        int result;
        Object obj = jpf.getClientProperty("substancelaf.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        obj = UIManager.get("substancelaf.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        return 1;
    }

    private static class StrengthCheckedBorder
    extends SubstanceBorder
    implements UIResource {
        public static final int GUTTER_WIDTH = 5;

        private StrengthCheckedBorder() {
        }

        public Insets getBorderInsets(Component c) {
            Insets fromSuper = super.getBorderInsets(c);
            JPasswordField jpf = (JPasswordField)c;
            if (SubstancePasswordFieldUI.getPasswordStrengthChecker(jpf) == null) {
                return fromSuper;
            }
            Insets result = new Insets(fromSuper.top, fromSuper.left, fromSuper.bottom, fromSuper.right + 5);
            return result;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x, y, width, height);
            JPasswordField jpf = (JPasswordField)c;
            PasswordStrengthChecker passwordStrengthChecker = SubstancePasswordFieldUI.getPasswordStrengthChecker(jpf);
            if (passwordStrengthChecker == null) {
                return;
            }
            ColorScheme colorScheme = null;
            PasswordStrengthChecker.PasswordStrength strength = passwordStrengthChecker.getStrength(jpf.getPassword());
            switch (strength) {
                case WEAK: {
                    colorScheme = SubstanceTheme.ORANGE;
                    break;
                }
                case MEDIUM: {
                    colorScheme = SubstanceTheme.YELLOW;
                    break;
                }
                case STRONG: {
                    colorScheme = SubstanceTheme.GREEN;
                }
            }
            if (colorScheme != null) {
                SubstanceImageCreator.paintRectangularBackground(g, x + width - 1 - 5, y + 1, 5, height - 2, colorScheme, true, false);
            }
            String tooltip = passwordStrengthChecker.getDescription(strength);
            jpf.setToolTipText(tooltip);
        }
    }

    private static class SubstancePasswordView
    extends PasswordView {
        public SubstancePasswordView(Element element) {
            super(element);
        }

        protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
            Container container = this.getContainer();
            if (!(container instanceof JPasswordField)) {
                return super.drawEchoCharacter(g, x, y, c);
            }
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JPasswordField field = (JPasswordField)container;
            boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
            ColorScheme colorScheme = field.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : SubstanceLookAndFeel.getMetallicColorScheme();
            Color topColor = isDark ? colorScheme.getExtraLightColor().brighter() : colorScheme.getUltraDarkColor();
            Color bottomColor = isDark ? colorScheme.getUltraLightColor().brighter() : colorScheme.getDarkColor();
            graphics.setPaint(new GradientPaint(x, y - 7, topColor, x, y, bottomColor));
            int echoPerChar = SubstancePasswordFieldUI.getEchoPerChar(field);
            for (int i = 0; i < echoPerChar; ++i) {
                graphics.fillOval(x, y - 7, 7, 7);
                x += 9;
            }
            return x;
        }

        protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            return super.drawSelectedText(g, x, y, p0, p1);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.modelToView(pos, a, b);
                }
                Rectangle alloc = this.adjustAllocation(a).getBounds();
                int echoPerChar = SubstancePasswordFieldUI.getEchoPerChar(f);
                int dx = (pos - this.getStartOffset()) * echoPerChar * 9;
                alloc.x += dx;
                alloc.width = 1;
                return alloc;
            }
            return null;
        }

        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            int n = 0;
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.viewToModel(fx, fy, a, bias);
                }
                Rectangle alloc = (a = this.adjustAllocation(a)) instanceof Rectangle ? (Rectangle)a : a.getBounds();
                int echoPerChar = SubstancePasswordFieldUI.getEchoPerChar(f);
                n = ((int)fx - alloc.x) / (echoPerChar * 9);
                if (n < 0) {
                    n = 0;
                } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                    n = this.getDocument().getLength() - this.getStartOffset();
                }
            }
            return this.getStartOffset() + n;
        }

        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    JPasswordField f;
                    Container c = this.getContainer();
                    if (!(c instanceof JPasswordField) || !(f = (JPasswordField)c).echoCharIsSet()) break;
                    int echoPerChar = SubstancePasswordFieldUI.getEchoPerChar(f);
                    return echoPerChar * 9 * this.getDocument().getLength();
                }
            }
            return super.getPreferredSpan(axis);
        }
    }
}

