/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.tabbed;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.tabbed.TabOverviewDialog;

public class TabOverviewButton
extends JButton
implements UIResource {
    private static final String OWN_BOUNDS = "substancelaf.ownBounds";

    public TabOverviewButton(final JTabbedPane tabPane) {
        this.setFocusable(false);
        this.setIcon(SubstanceImageCreator.getSearchIcon(16, SubstanceLookAndFeel.getColorScheme(), tabPane.getComponentOrientation().isLeftToRight()));
        this.setToolTipText(SubstanceLookAndFeel.getLabelBundle().getString("TabbedPane.overviewButtonTooltip"));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabOverviewDialog.getOverviewDialog(tabPane).setVisible(true);
            }
        });
    }

    public void setBounds(int x, int y, int width, int height) {
        if (Boolean.TRUE.equals(this.getClientProperty(OWN_BOUNDS))) {
            super.setBounds(x, y, width, height);
        }
    }

    public void updateLocation(JTabbedPane tabbedPane, Insets tabAreaInsets) {
        if (tabbedPane == null) {
            return;
        }
        this.putClientProperty(OWN_BOUNDS, Boolean.TRUE);
        switch (tabbedPane.getTabPlacement()) {
            case 1: {
                if (tabbedPane.getComponentOrientation().isLeftToRight()) {
                    this.setBounds(2, tabAreaInsets.top, 16, 16);
                    break;
                }
                this.setBounds(tabbedPane.getBounds().width - tabAreaInsets.right - 18, tabAreaInsets.top, 16, 16);
                break;
            }
            case 3: {
                if (tabbedPane.getComponentOrientation().isLeftToRight()) {
                    this.setBounds(2, tabbedPane.getBounds().height - tabAreaInsets.bottom - 20, 16, 16);
                    break;
                }
                this.setBounds(tabbedPane.getBounds().width - tabAreaInsets.right - 18, tabbedPane.getBounds().height - tabAreaInsets.bottom - 20, 16, 16);
                break;
            }
            case 2: {
                this.setBounds(2, tabAreaInsets.top - 1, 16, 16);
                break;
            }
            case 4: {
                this.setBounds(tabbedPane.getBounds().width - tabAreaInsets.right - 18, tabAreaInsets.top - 1, 16, 16);
            }
        }
        this.putClientProperty(OWN_BOUNDS, null);
    }
}

