/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceBinaryWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;
    private static int fontSize = 14;
    private static Font tahoma = new Font("Tahoma", 1, fontSize);
    private static Font tahomaPreview = new Font("Tahoma", 1, fontSize - 2);

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
        this.drawWatermarkImage((Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        Color stampColor = null;
        int fontWidth = 0;
        int fontHeight = 0;
        if (isPreview) {
            stampColor = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? Color.white : Color.black;
            graphics.setFont(tahomaPreview);
            fontWidth = fontSize - 6;
            fontHeight = fontSize - 4;
        } else {
            stampColor = SubstanceColorUtilities.getWatermarkStampColor();
            graphics.setFont(tahoma);
            fontWidth = fontSize - 4;
            fontHeight = fontSize - 2;
        }
        graphics.setColor(stampColor);
        int rows = height / fontHeight;
        int columns = width / fontWidth;
        for (int col = x; col <= x + columns; ++col) {
            for (int row = y; row <= y + rows; ++row) {
                double val = isPreview ? Math.abs(Math.sin(2.8 + (double)col + (double)(columns * row))) : Math.random();
                char c = val >= 0.5 ? (char)'0' : '1';
                graphics.drawString("" + c, col * fontWidth, fontHeight * (row + 1));
            }
        }
        return true;
    }

    public String getDisplayName() {
        return SubstanceBinaryWatermark.getName();
    }

    public static String getName() {
        return "Binary";
    }

    public boolean isDependingOnTheme() {
        return true;
    }

    public void dispose() {
        watermarkImage = null;
    }
}

