/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public class TabularDataSupport
implements TabularData,
Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 5720150593236309827L;
    private Map dataMap;
    private TabularType tabularType;
    private transient String[] m_indexNames;
    private transient int m_hashcode = 0;

    public TabularDataSupport(TabularType tabularType) {
        this(tabularType, 101, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int initialCapacity, float loadFactor) {
        if (tabularType == null) {
            throw new IllegalArgumentException("TabularTypeBackUP instance cannot be null.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("The initialCapacity cannot be a negative number.");
        }
        if (loadFactor < 0.0f) {
            throw new IllegalArgumentException("The load factor cannot be a negative number.");
        }
        this.tabularType = tabularType;
        this.dataMap = new HashMap(initialCapacity, loadFactor);
        this.initialize();
    }

    private void initialize() {
        List tabularIndexList = this.tabularType.getIndexNames();
        this.m_indexNames = tabularIndexList.toArray(new String[tabularIndexList.size()]);
    }

    public TabularType getTabularType() {
        return this.tabularType;
    }

    public Object[] calculateIndex(CompositeData value) {
        if (value == null) {
            throw new NullPointerException("CompositeData object cannot be null");
        }
        if (!value.getCompositeType().equals(this.tabularType.getRowType())) {
            throw new InvalidOpenTypeException("Invalid CompositeData object, its' tabularType is not equal to the row type of this TabularType instance");
        }
        return Collections.unmodifiableList(Arrays.asList(value.getAll(this.m_indexNames))).toArray();
    }

    public boolean containsKey(Object key) {
        if (!(key instanceof Object[])) {
            return false;
        }
        return this.containsKey((Object[])key);
    }

    public boolean containsKey(Object[] key) {
        if (key == null) {
            return false;
        }
        return this.dataMap.containsKey(Arrays.asList(key));
    }

    public boolean containsValue(CompositeData value) {
        return this.dataMap.containsValue(value);
    }

    public boolean containsValue(Object value) {
        return this.dataMap.containsValue(value);
    }

    public Object get(Object key) {
        return this.get((Object[])key);
    }

    public CompositeData get(Object[] key) {
        this.validateKeys(key);
        return (CompositeData)this.dataMap.get(Arrays.asList(key));
    }

    public Object put(Object key, Object value) {
        this.put((CompositeData)value);
        return value;
    }

    public void put(CompositeData value) {
        List<Object> list = Collections.unmodifiableList(Arrays.asList(this.calculateIndex(value)));
        if (this.dataMap.containsKey(list)) {
            throw new KeyAlreadyExistsException("The list of index names already exists in this instance");
        }
        this.dataMap.put(list, value);
    }

    public Object remove(Object key) {
        return this.remove((Object[])key);
    }

    public CompositeData remove(Object[] key) {
        this.validateKeys(key);
        return (CompositeData)this.dataMap.remove(Arrays.asList(key));
    }

    public void putAll(Map t) {
        CompositeData[] compositeData;
        if (t == null || t.size() == 0) {
            return;
        }
        try {
            compositeData = t.values().toArray(new CompositeData[t.size()]);
        }
        catch (ArrayStoreException e) {
            throw new ClassCastException("The values contained in t must all be of type CompositeData");
        }
        this.putAll(compositeData);
    }

    public void putAll(CompositeData[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        List storeList = this.validateNoDuplicates(values);
        int i = 0;
        while (i < values.length) {
            this.dataMap.put(storeList.get(i), values[i]);
            ++i;
        }
    }

    private List validateNoDuplicates(CompositeData[] values) {
        ArrayList<List<Object>> storeList = new ArrayList<List<Object>>();
        int i = 0;
        while (i < values.length) {
            List<Object> list = Collections.unmodifiableList(Arrays.asList(this.calculateIndex(values[i])));
            if (storeList.contains(list)) {
                throw new KeyAlreadyExistsException("value at [" + i + "] has the same index values as: " + storeList.indexOf(list));
            }
            storeList.add(list);
            ++i;
        }
        return storeList;
    }

    public void clear() {
        this.dataMap.clear();
    }

    public int size() {
        return this.dataMap.size();
    }

    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    public Set keySet() {
        return this.dataMap.keySet();
    }

    public Collection values() {
        return this.dataMap.values();
    }

    public Set entrySet() {
        return this.dataMap.entrySet();
    }

    public Object clone() {
        TabularDataSupport dataSupportClone = null;
        try {
            dataSupportClone = (TabularDataSupport)super.clone();
            dataSupportClone.dataMap = (HashMap)((HashMap)this.dataMap).clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return dataSupportClone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TabularData)) {
            return false;
        }
        TabularData tabularData = (TabularData)obj;
        Iterator i = this.values().iterator();
        while (i.hasNext()) {
            CompositeData compositeData = (CompositeData)i.next();
            if (tabularData.containsValue(compositeData)) continue;
            return false;
        }
        return this.getTabularType().equals(tabularData.getTabularType()) && this.size() == tabularData.size();
    }

    public int hashCode() {
        if (this.m_hashcode == 0) {
            int result = 17;
            result = 3 * result + this.tabularType.hashCode();
            Iterator i = this.values().iterator();
            while (i.hasNext()) {
                result = 3 * result + ((CompositeData)i.next()).hashCode();
            }
            this.m_hashcode = result;
        }
        return this.m_hashcode;
    }

    public String toString() {
        return this.getClass().getName() + "(tabularType = " + this.tabularType.toString() + ",contains = " + this.dataMap.toString() + ")";
    }

    private void validateKeys(Object[] key) {
        if (key == null || key.length == 0) {
            throw new NullPointerException("Object[] key cannot be null or of zero length");
        }
        if (key.length != this.m_indexNames.length) {
            throw new InvalidKeyException("Length of Object[] passed in as a parameter is not equal to the number of items: " + this.m_indexNames.length + " as specified for the indexing rows in this instance.");
        }
        int i = 0;
        while (i < key.length) {
            OpenType openType = this.tabularType.getRowType().getType(this.m_indexNames[i]);
            if (key[i] != null && !openType.isValue(key[i])) {
                throw new InvalidKeyException("expected value is: " + openType + " at index: " + i + " but got: " + key[i]);
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.initialize();
    }
}

