/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxUI;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

final class PlasticComboBoxButton
extends JButton {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private JComboBox comboBox;
    private Icon comboIcon;
    private boolean iconOnly = false;
    private boolean borderPaintsFocus;

    PlasticComboBoxButton(JComboBox comboBox, Icon comboIcon, boolean iconOnly, CellRendererPane rendererPane, JList listBox) {
        super("");
        this.setModel(new DefaultButtonModel(){

            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.comboBox = comboBox;
        this.comboIcon = comboIcon;
        this.iconOnly = iconOnly;
        this.rendererPane = rendererPane;
        this.listBox = listBox;
        this.setEnabled(comboBox.isEnabled());
        this.setFocusable(false);
        this.setRequestFocusEnabled(comboBox.isEnabled());
        this.setBorder(UIManager.getBorder("ComboBox.arrowButtonBorder"));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.borderPaintsFocus = UIManager.getBoolean("ComboBox.borderPaintsFocus");
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(JComboBox cb) {
        this.comboBox = cb;
    }

    public Icon getComboIcon() {
        return this.comboIcon;
    }

    public void setComboIcon(Icon i2) {
        this.comboIcon = i2;
    }

    public boolean isIconOnly() {
        return this.iconOnly;
    }

    public void setIconOnly(boolean b2) {
        this.iconOnly = b2;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paintComponent(Graphics g2) {
        int iconLeft;
        super.paintComponent(g2);
        boolean leftToRight = PlasticUtils.isLeftToRight(this.comboBox);
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int right = left + (width - 1);
        int iconWidth = 0;
        int n2 = iconLeft = leftToRight ? right : left;
        if (this.comboIcon != null) {
            int iconTop;
            iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                iconLeft = (this.getWidth() - iconWidth) / 2;
                iconTop = (this.getHeight() - iconHeight) / 2;
            } else {
                iconLeft = leftToRight ? left + (width - 1) - iconWidth : left;
                iconTop = (this.getHeight() - iconHeight) / 2;
            }
            this.comboIcon.paintIcon(this, g2, iconLeft, iconTop);
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c2 = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            int x = leftToRight ? left : left + iconWidth;
            int y = top;
            int w2 = this.getWidth() - left - PlasticComboBoxUI.getEditableButtonWidth();
            int h2 = height;
            Border oldBorder = null;
            if (c2 instanceof JComponent && !this.isTableCellEditor()) {
                JComponent component = (JComponent)c2;
                if (c2 instanceof BasicComboBoxRenderer.UIResource) {
                    oldBorder = component.getBorder();
                    component.setBorder(EMPTY_BORDER);
                }
                Insets rendererInsets = component.getInsets();
                Insets editorInsets = UIManager.getInsets("ComboBox.editorInsets");
                int offsetTop = Math.max(0, editorInsets.top - rendererInsets.top);
                int offsetBottom = Math.max(0, editorInsets.bottom - rendererInsets.bottom);
                y += offsetTop;
                h2 -= offsetTop + offsetBottom;
            }
            c2.setFont(this.rendererPane.getFont());
            this.configureColors(c2);
            boolean shouldValidate = c2 instanceof JPanel;
            if (!(this.is3D() && c2 instanceof JComponent && c2.isOpaque())) {
                this.rendererPane.paintComponent(g2, c2, this, x, y, w2, h2, shouldValidate);
            } else {
                JComponent component = (JComponent)c2;
                boolean oldOpaque = component.isOpaque();
                component.setOpaque(false);
                this.rendererPane.paintComponent(g2, c2, this, x, y, w2, h2, shouldValidate);
                component.setOpaque(oldOpaque);
            }
            if (oldBorder != null) {
                ((JComponent)c2).setBorder(oldBorder);
            }
        }
        if (this.comboIcon != null) {
            boolean hasFocus = this.comboBox.hasFocus();
            if (!this.borderPaintsFocus && hasFocus) {
                g2.setColor(PlasticLookAndFeel.getFocusColor());
                g2.drawRect(2, 2, this.getWidth() - 6, this.getHeight() - 6);
            }
        }
    }

    private void configureColors(Component c2) {
        if (this.model.isArmed() && this.model.isPressed()) {
            if (this.isOpaque()) {
                c2.setBackground(UIManager.getColor("Button.select"));
            }
            c2.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                c2.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            c2.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        } else {
            c2.setForeground(this.comboBox.getForeground());
            c2.setBackground(this.comboBox.getBackground());
        }
    }

    private boolean is3D() {
        if (PlasticUtils.force3D(this.comboBox)) {
            return true;
        }
        if (PlasticUtils.forceFlat(this.comboBox)) {
            return false;
        }
        return PlasticUtils.is3D("ComboBox.");
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty("JComboBox.isTableCellEditor"));
    }
}

