/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;

public class Bullet {
    public int type;
    public StyleRange style;
    public String text;
    int[] linesIndices;
    int count;

    public Bullet(StyleRange styleRange) {
        this(1, styleRange);
    }

    public Bullet(int n2, StyleRange styleRange) {
        if (styleRange == null) {
            SWT.error(4);
        }
        if (styleRange.metrics == null) {
            SWT.error(4);
        }
        this.type = n2;
        this.style = styleRange;
    }

    void addIndices(int n2, int n3) {
        if (this.linesIndices == null) {
            this.linesIndices = new int[n3];
            this.count = n3;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.linesIndices[i2] = n2 + i2;
            }
        } else {
            int n4;
            int n5;
            for (n5 = 0; n5 < this.count && n2 > this.linesIndices[n5]; ++n5) {
            }
            for (n4 = n5; n4 < this.count && n2 + n3 > this.linesIndices[n4]; ++n4) {
            }
            int n6 = n5 + n3 + this.count - n4;
            if (n6 > this.linesIndices.length) {
                int[] nArray = new int[n6];
                System.arraycopy(this.linesIndices, 0, nArray, 0, this.count);
                this.linesIndices = nArray;
            }
            System.arraycopy(this.linesIndices, n4, this.linesIndices, n5 + n3, this.count - n4);
            for (int i3 = 0; i3 < n3; ++i3) {
                this.linesIndices[n5 + i3] = n2 + i3;
            }
            this.count = n6;
        }
    }

    int indexOf(int n2) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.linesIndices[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public int hashCode() {
        return this.style.hashCode() ^ this.type;
    }

    int[] removeIndices(int n2, int n3, int n4, boolean bl) {
        int n5;
        if (this.count == 0) {
            return null;
        }
        if (n2 > this.linesIndices[this.count - 1]) {
            return null;
        }
        int n6 = n2 + n3;
        int n7 = n4 - n3;
        for (n5 = 0; n5 < this.count; ++n5) {
            int n8;
            int n9 = this.linesIndices[n5];
            if (n2 > n9) continue;
            for (n8 = n5; n8 < this.count && this.linesIndices[n8] < n6; ++n8) {
            }
            if (bl) {
                int n10 = n8;
                while (n10 < this.count) {
                    int n11 = n10++;
                    this.linesIndices[n11] = this.linesIndices[n11] + n7;
                }
            }
            int[] nArray = new int[this.count - n8];
            System.arraycopy(this.linesIndices, n8, nArray, 0, this.count - n8);
            System.arraycopy(this.linesIndices, n8, this.linesIndices, n5, this.count - n8);
            this.count -= n8 - n5;
            return nArray;
        }
        n5 = 0;
        while (n5 < this.count) {
            int n12 = n5++;
            this.linesIndices[n12] = this.linesIndices[n12] + n7;
        }
        return null;
    }

    int size() {
        return this.count;
    }
}

