/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.JPEGAppn;
import org.eclipse.swt.internal.image.JPEGArithmeticConditioningTable;
import org.eclipse.swt.internal.image.JPEGComment;
import org.eclipse.swt.internal.image.JPEGEndOfImage;
import org.eclipse.swt.internal.image.JPEGFrameHeader;
import org.eclipse.swt.internal.image.JPEGHuffmanTable;
import org.eclipse.swt.internal.image.JPEGQuantizationTable;
import org.eclipse.swt.internal.image.JPEGRestartInterval;
import org.eclipse.swt.internal.image.JPEGScanHeader;
import org.eclipse.swt.internal.image.JPEGSegment;
import org.eclipse.swt.internal.image.JPEGStartOfImage;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGFileFormat
extends FileFormat {
    int restartInterval;
    JPEGFrameHeader frameHeader;
    int imageWidth;
    int imageHeight;
    int interleavedMcuCols;
    int interleavedMcuRows;
    int maxV;
    int maxH;
    boolean progressive;
    int samplePrecision;
    int nComponents;
    int[][] frameComponents;
    int[] componentIds;
    byte[][] imageComponents;
    int[] dataUnit;
    int[][][] dataUnits;
    int[] precedingDCs;
    JPEGScanHeader scanHeader;
    byte[] dataBuffer;
    int currentBitCount;
    int bufferCurrentPosition;
    int restartsToGo;
    int nextRestartNumber;
    JPEGHuffmanTable[] acHuffmanTables;
    JPEGHuffmanTable[] dcHuffmanTables;
    int[][] quantizationTables;
    int currentByte;
    int encoderQFactor = 75;
    int eobrun = 0;
    public static final int DCTSIZE = 8;
    public static final int DCTSIZESQR = 64;
    public static final int FIX_0_899976223 = 7373;
    public static final int FIX_1_961570560 = 16069;
    public static final int FIX_2_053119869 = 16819;
    public static final int FIX_0_298631336 = 2446;
    public static final int FIX_1_847759065 = 15137;
    public static final int FIX_1_175875602 = 9633;
    public static final int FIX_3_072711026 = 25172;
    public static final int FIX_0_765366865 = 6270;
    public static final int FIX_2_562915447 = 20995;
    public static final int FIX_0_541196100 = 4433;
    public static final int FIX_0_390180644 = 3196;
    public static final int FIX_1_501321110 = 12299;
    public static final int APP0 = 65504;
    public static final int APP15 = 65519;
    public static final int COM = 65534;
    public static final int DAC = 65484;
    public static final int DHP = 65502;
    public static final int DHT = 65476;
    public static final int DNL = 65500;
    public static final int DRI = 65501;
    public static final int DQT = 65499;
    public static final int EOI = 65497;
    public static final int EXP = 65503;
    public static final int JPG = 65480;
    public static final int JPG0 = 65520;
    public static final int JPG13 = 65533;
    public static final int RST0 = 65488;
    public static final int RST1 = 65489;
    public static final int RST2 = 65490;
    public static final int RST3 = 65491;
    public static final int RST4 = 65492;
    public static final int RST5 = 65493;
    public static final int RST6 = 65494;
    public static final int RST7 = 65495;
    public static final int SOF0 = 65472;
    public static final int SOF1 = 65473;
    public static final int SOF2 = 65474;
    public static final int SOF3 = 65475;
    public static final int SOF5 = 65477;
    public static final int SOF6 = 65478;
    public static final int SOF7 = 65479;
    public static final int SOF9 = 65481;
    public static final int SOF10 = 65482;
    public static final int SOF11 = 65483;
    public static final int SOF13 = 65485;
    public static final int SOF14 = 65486;
    public static final int SOF15 = 65487;
    public static final int SOI = 65496;
    public static final int SOS = 65498;
    public static final int TEM = 65281;
    public static final int TQI = 0;
    public static final int HI = 1;
    public static final int VI = 2;
    public static final int CW = 3;
    public static final int CH = 4;
    public static final int DC = 0;
    public static final int AC = 1;
    public static final int ID_Y = 0;
    public static final int ID_CB = 1;
    public static final int ID_CR = 2;
    public static final RGB[] RGB16 = new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(192, 192, 192), new RGB(128, 128, 128), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    public static final int[] ExtendTest = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144};
    public static final int[] ExtendOffset = new int[]{0, -1, -3, -7, -15, -31, -63, -127, -255, -511, -1023, -2047, -4095, -8191, -16383, -32767, -65535, -131071, -262143};
    public static final int[] ZigZag8x8 = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    public static int[] CrRTable;
    public static int[] CbBTable;
    public static int[] CrGTable;
    public static int[] CbGTable;
    public static int[] RYTable;
    public static int[] GYTable;
    public static int[] BYTable;
    public static int[] RCbTable;
    public static int[] GCbTable;
    public static int[] BCbTable;
    public static int[] RCrTable;
    public static int[] GCrTable;
    public static int[] BCrTable;
    public static int[] NBitsTable;

    JPEGFileFormat() {
    }

    void compress(ImageData imageData, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int n8;
        int n9 = imageData.width;
        int n10 = imageData.height;
        int n11 = this.maxV * this.maxH;
        this.imageComponents = new byte[this.nComponents][];
        for (n8 = 0; n8 < this.nComponents; ++n8) {
            nArray = this.frameComponents[this.componentIds[n8]];
            this.imageComponents[n8] = new byte[nArray[3] * nArray[4]];
        }
        nArray = this.frameComponents[this.componentIds[0]];
        for (n8 = 0; n8 < n10; ++n8) {
            n7 = n8 * n9;
            n6 = n8 * nArray[3];
            System.arraycopy(byArray, n7, this.imageComponents[0], n6, n9);
        }
        nArray = this.frameComponents[this.componentIds[1]];
        for (n8 = 0; n8 < n10 / this.maxV; ++n8) {
            n7 = n8 * nArray[3];
            for (n6 = 0; n6 < n9 / this.maxH; ++n6) {
                n5 = 0;
                for (n4 = 0; n4 < this.maxV; ++n4) {
                    n3 = (n8 * this.maxV + n4) * n9 + n6 * this.maxH;
                    for (n2 = 0; n2 < this.maxH; ++n2) {
                        n5 += byArray2[n3 + n2] & 0xFF;
                    }
                }
                this.imageComponents[1][n7 + n6] = (byte)(n5 / n11);
            }
        }
        nArray = this.frameComponents[this.componentIds[2]];
        for (n8 = 0; n8 < n10 / this.maxV; ++n8) {
            n7 = n8 * nArray[3];
            for (n6 = 0; n6 < n9 / this.maxH; ++n6) {
                n5 = 0;
                for (n4 = 0; n4 < this.maxV; ++n4) {
                    n3 = (n8 * this.maxV + n4) * n9 + n6 * this.maxH;
                    for (n2 = 0; n2 < this.maxH; ++n2) {
                        n5 += byArray3[n3 + n2] & 0xFF;
                    }
                }
                this.imageComponents[2][n7 + n6] = (byte)(n5 / n11);
            }
        }
        for (n8 = 0; n8 < this.nComponents; ++n8) {
            int n12;
            int n13;
            int n14;
            byte[] byArray4 = this.imageComponents[n8];
            nArray = this.frameComponents[this.componentIds[n8]];
            n6 = nArray[1];
            n5 = nArray[2];
            n4 = nArray[3];
            n3 = nArray[4];
            n2 = n9 / (this.maxH / n6);
            int n15 = n10 / (this.maxV / n5);
            if (n2 < n4) {
                n14 = n4 - n2;
                for (n13 = 0; n13 < n15; ++n13) {
                    n12 = (n13 + 1) * n4 - n14;
                    int n16 = byArray4[n12 - 1] & 0xFF;
                    for (int i2 = 0; i2 < n14; ++i2) {
                        byArray4[n12 + i2] = (byte)n16;
                    }
                }
            }
            if (n15 >= n3) continue;
            n14 = (n15 - 1) * n4;
            for (n13 = n15; n13 <= n3; ++n13) {
                n12 = (n13 - 1) * n4;
                System.arraycopy(byArray4, n14, byArray4, n12, n4);
            }
        }
    }

    void convert4BitRGBToYCbCr(ImageData imageData) {
        int n2;
        Object object;
        int n3;
        RGB[] rGBArray = imageData.getRGBs();
        int n4 = rGBArray.length;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        int n5 = imageData.width;
        int n6 = imageData.height;
        for (n3 = 0; n3 < n4; ++n3) {
            object = rGBArray[n3];
            int n7 = ((RGB)object).red;
            int n8 = ((RGB)object).green;
            int n9 = ((RGB)object).blue;
            n2 = RYTable[n7] + GYTable[n8] + BYTable[n9];
            byArray[n3] = (byte)(n2 >> 16);
            if (n2 < 0 && (n2 & 0xFFFF) != 0) {
                int n10 = n3;
                byArray[n10] = (byte)(byArray[n10] - 1);
            }
            n2 = RCbTable[n7] + GCbTable[n8] + BCbTable[n9];
            byArray2[n3] = (byte)(n2 >> 16);
            if (n2 < 0 && (n2 & 0xFFFF) != 0) {
                int n11 = n3;
                byArray2[n11] = (byte)(byArray2[n11] - 1);
            }
            n2 = RCrTable[n7] + GCrTable[n8] + BCrTable[n9];
            byArray3[n3] = (byte)(n2 >> 16);
            if (n2 >= 0 || (n2 & 0xFFFF) == 0) continue;
            int n12 = n3;
            byArray3[n12] = (byte)(byArray3[n12] - 1);
        }
        n3 = n5 * n6;
        object = new byte[n3];
        byte[] byArray4 = new byte[n3];
        byte[] byArray5 = new byte[n3];
        byte[] byArray6 = imageData.data;
        n2 = imageData.bytesPerLine;
        int n13 = n5 >> 1;
        for (int i2 = 0; i2 < n6; ++i2) {
            for (int i3 = 0; i3 < n13; ++i3) {
                int n14 = i2 * n2 + i3;
                int n15 = i2 * n5 + i3 * 2;
                int n16 = byArray6[n14] & 0xFF;
                int n17 = n16 >> 4;
                object[n15] = byArray[n17];
                byArray4[n15] = byArray2[n17];
                byArray5[n15] = byArray3[n17];
                object[n15 + 1] = byArray[n16 &= 0xF];
                byArray4[n15 + 1] = byArray2[n16];
                byArray5[n15 + 1] = byArray3[n16];
            }
        }
        this.compress(imageData, (byte[])object, byArray4, byArray5);
    }

    void convert8BitRGBToYCbCr(ImageData imageData) {
        int n2;
        int n3;
        int n4;
        RGB[] rGBArray = imageData.getRGBs();
        int n5 = rGBArray.length;
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        int n6 = imageData.width;
        int n7 = imageData.height;
        for (n4 = 0; n4 < n5; ++n4) {
            RGB rGB = rGBArray[n4];
            n3 = rGB.red;
            n2 = rGB.green;
            int n8 = rGB.blue;
            int n9 = RYTable[n3] + GYTable[n2] + BYTable[n8];
            byArray[n4] = (byte)(n9 >> 16);
            if (n9 < 0 && (n9 & 0xFFFF) != 0) {
                int n10 = n4;
                byArray[n10] = (byte)(byArray[n10] - 1);
            }
            n9 = RCbTable[n3] + GCbTable[n2] + BCbTable[n8];
            byArray2[n4] = (byte)(n9 >> 16);
            if (n9 < 0 && (n9 & 0xFFFF) != 0) {
                int n11 = n4;
                byArray2[n11] = (byte)(byArray2[n11] - 1);
            }
            n9 = RCrTable[n3] + GCrTable[n2] + BCrTable[n8];
            byArray3[n4] = (byte)(n9 >> 16);
            if (n9 >= 0 || (n9 & 0xFFFF) == 0) continue;
            int n12 = n4;
            byArray3[n12] = (byte)(byArray3[n12] - 1);
        }
        n4 = imageData.width;
        int n13 = n7;
        n3 = n6 + 3 >> 2 << 2;
        n2 = n4 * n13;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = imageData.data;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n14 = i2 * n3;
            int n15 = i2 * n4;
            for (int i3 = 0; i3 < n6; ++i3) {
                int n16 = byArray7[n14 + i3] & 0xFF;
                int n17 = n15 + i3;
                byArray4[n17] = byArray[n16];
                byArray5[n17] = byArray2[n16];
                byArray6[n17] = byArray3[n16];
            }
        }
        this.compress(imageData, byArray4, byArray5, byArray6);
    }

    byte[] convertCMYKToRGB() {
        return new byte[0];
    }

    void convertImageToYCbCr(ImageData imageData) {
        switch (imageData.depth) {
            case 4: {
                this.convert4BitRGBToYCbCr(imageData);
                return;
            }
            case 8: {
                this.convert8BitRGBToYCbCr(imageData);
                return;
            }
            case 16: 
            case 24: 
            case 32: {
                this.convertMultiRGBToYCbCr(imageData);
                return;
            }
        }
        SWT.error(38);
    }

    void convertMultiRGBToYCbCr(ImageData imageData) {
        int n2 = imageData.width;
        int n3 = imageData.height;
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        PaletteData paletteData = imageData.palette;
        int[] nArray = new int[n2];
        if (paletteData.isDirect) {
            int n5 = paletteData.redMask;
            int n6 = paletteData.greenMask;
            int n7 = paletteData.blueMask;
            int n8 = paletteData.redShift;
            int n9 = paletteData.greenShift;
            int n10 = paletteData.blueShift;
            for (int i2 = 0; i2 < n3; ++i2) {
                imageData.getPixels(0, i2, n2, nArray, 0);
                int n11 = i2 * n2;
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n12 = nArray[i3];
                    int n13 = n11 + i3;
                    int n14 = n12 & n5;
                    n14 = n8 < 0 ? n14 >>> -n8 : n14 << n8;
                    int n15 = n12 & n6;
                    n15 = n9 < 0 ? n15 >>> -n9 : n15 << n9;
                    int n16 = n12 & n7;
                    n16 = n10 < 0 ? n16 >>> -n10 : n16 << n10;
                    byArray[n13] = (byte)(RYTable[n14] + GYTable[n15] + BYTable[n16] >> 16);
                    byArray2[n13] = (byte)(RCbTable[n14] + GCbTable[n15] + BCbTable[n16] >> 16);
                    byArray3[n13] = (byte)(RCrTable[n14] + GCrTable[n15] + BCrTable[n16] >> 16);
                }
            }
        } else {
            for (int i4 = 0; i4 < n3; ++i4) {
                imageData.getPixels(0, i4, n2, nArray, 0);
                int n17 = i4 * n2;
                for (int i5 = 0; i5 < n2; ++i5) {
                    int n18 = nArray[i5];
                    int n19 = n17 + i5;
                    RGB rGB = paletteData.getRGB(n18);
                    int n20 = rGB.red;
                    int n21 = rGB.green;
                    int n22 = rGB.blue;
                    byArray[n19] = (byte)(RYTable[n20] + GYTable[n21] + BYTable[n22] >> 16);
                    byArray2[n19] = (byte)(RCbTable[n20] + GCbTable[n21] + BCbTable[n22] >> 16);
                    byArray3[n19] = (byte)(RCrTable[n20] + GCrTable[n21] + BCrTable[n22] >> 16);
                }
            }
        }
        this.compress(imageData, byArray, byArray2, byArray3);
    }

    byte[] convertYToRGB() {
        int n2 = this.frameComponents[this.componentIds[0]][3];
        int n3 = ((this.imageWidth * 8 + 7) / 8 + 3) / 4 * 4;
        byte[] byArray = new byte[n3 * this.imageHeight];
        byte[] byArray2 = this.imageComponents[0];
        int n4 = 0;
        for (int i2 = 0; i2 < this.imageHeight; ++i2) {
            int n5 = i2 * n2;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n6 = byArray2[n5] & 0xFF;
                if (n6 < 0) {
                    n6 = 0;
                } else if (n6 > 255) {
                    n6 = 255;
                }
                if (i3 >= this.imageWidth) {
                    n6 = 0;
                }
                byArray[n4] = (byte)n6;
                ++n5;
                ++n4;
            }
        }
        return byArray;
    }

    byte[] convertYCbCrToRGB() {
        int n2 = this.imageWidth * this.imageHeight * this.nComponents;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.expandImageComponents();
        byte[] byArray2 = this.imageComponents[0];
        byte[] byArray3 = this.imageComponents[1];
        byte[] byArray4 = this.imageComponents[2];
        int n4 = this.frameComponents[this.componentIds[0]][3];
        for (int i2 = 0; i2 < this.imageHeight; ++i2) {
            int n5 = i2 * n4;
            for (int i3 = 0; i3 < this.imageWidth; ++i3) {
                int n6 = byArray2[n5] & 0xFF;
                int n7 = byArray3[n5] & 0xFF;
                int n8 = byArray4[n5] & 0xFF;
                int n9 = n6 + CrRTable[n8];
                int n10 = n6 + (CbGTable[n7] + CrGTable[n8] >> 16);
                int n11 = n6 + CbBTable[n7];
                if (n9 < 0) {
                    n9 = 0;
                } else if (n9 > 255) {
                    n9 = 255;
                }
                if (n10 < 0) {
                    n10 = 0;
                } else if (n10 > 255) {
                    n10 = 255;
                }
                if (n11 < 0) {
                    n11 = 0;
                } else if (n11 > 255) {
                    n11 = 255;
                }
                byArray[n3] = (byte)n11;
                byArray[n3 + 1] = (byte)n10;
                byArray[n3 + 2] = (byte)n9;
                n3 += 3;
                ++n5;
            }
        }
        return byArray;
    }

    void decodeACCoefficients(int[] nArray, int n2) {
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.acHuffmanTables[nArray2[1]];
        int n3 = 1;
        while (n3 < 64) {
            int n4 = this.decodeUsingTable(jPEGHuffmanTable);
            int n5 = n4 >> 4;
            int n6 = n4 & 0xF;
            if (n6 == 0) {
                if (n5 != 15) break;
                n3 += 16;
                continue;
            }
            int n7 = this.receive(n6);
            nArray[JPEGFileFormat.ZigZag8x8[n3 += n5]] = this.extendBy(n7, n6);
            ++n3;
        }
    }

    void decodeACFirstCoefficients(int[] nArray, int n2, int n3, int n4, int n5) {
        if (this.eobrun > 0) {
            --this.eobrun;
            return;
        }
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.acHuffmanTables[nArray2[1]];
        int n6 = n3;
        while (n6 <= n4) {
            int n7 = this.decodeUsingTable(jPEGHuffmanTable);
            int n8 = n7 >> 4;
            int n9 = n7 & 0xF;
            if (n9 == 0) {
                if (n8 == 15) {
                    n6 += 16;
                    continue;
                }
                this.eobrun = (1 << n8) + this.receive(n8) - 1;
                break;
            }
            int n10 = this.receive(n9);
            nArray[JPEGFileFormat.ZigZag8x8[n6 += n8]] = this.extendBy(n10, n9) << n5;
            ++n6;
        }
    }

    void decodeACRefineCoefficients(int[] nArray, int n2, int n3, int n4, int n5) {
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.acHuffmanTables[nArray2[1]];
        int n6 = n3;
        while (n6 <= n4) {
            int n7;
            int n8;
            int n9;
            if (this.eobrun > 0) {
                while (n6 <= n4) {
                    n9 = ZigZag8x8[n6];
                    if (nArray[n9] != 0) {
                        nArray[n9] = this.refineAC(nArray[n9], n5);
                    }
                    ++n6;
                }
                --this.eobrun;
                continue;
            }
            n9 = this.decodeUsingTable(jPEGHuffmanTable);
            int n10 = n9 >> 4;
            int n11 = n9 & 0xF;
            if (n11 == 0) {
                if (n10 == 15) {
                    n8 = 0;
                    while (n8 < 16 && n6 <= n4) {
                        n7 = ZigZag8x8[n6];
                        if (nArray[n7] != 0) {
                            nArray[n7] = this.refineAC(nArray[n7], n5);
                        } else {
                            ++n8;
                        }
                        ++n6;
                    }
                    continue;
                }
                this.eobrun = (1 << n10) + this.receive(n10);
                continue;
            }
            n8 = this.receive(n11);
            n7 = 0;
            int n12 = ZigZag8x8[n6];
            while ((n7 < n10 || nArray[n12] != 0) && n6 <= n4) {
                if (nArray[n12] != 0) {
                    nArray[n12] = this.refineAC(nArray[n12], n5);
                } else {
                    ++n7;
                }
                n12 = ZigZag8x8[++n6];
            }
            nArray[n12] = n8 != 0 ? 1 << n5 : -1 << n5;
            ++n6;
        }
    }

    int refineAC(int n2, int n3) {
        int n4;
        if (n2 > 0) {
            int n5 = this.nextBit();
            if (n5 != 0) {
                n2 += 1 << n3;
            }
        } else if (n2 < 0 && (n4 = this.nextBit()) != 0) {
            n2 += -1 << n3;
        }
        return n2;
    }

    void decodeDCCoefficient(int[] nArray, int n2, boolean bl, int n3) {
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.dcHuffmanTables[nArray2[0]];
        int n4 = 0;
        if (this.progressive && !bl) {
            int n5 = this.nextBit();
            n4 = nArray[0] + (n5 << n3);
        } else {
            n4 = this.precedingDCs[n2];
            int n6 = this.decodeUsingTable(jPEGHuffmanTable);
            if (n6 != 0) {
                int n7 = this.receive(n6);
                int n8 = this.extendBy(n7, n6);
                this.precedingDCs[n2] = n4 += n8;
            }
            if (this.progressive) {
                n4 <<= n3;
            }
        }
        nArray[0] = n4;
    }

    void dequantize(int[] nArray, int n2) {
        int[] nArray2 = this.quantizationTables[this.frameComponents[this.componentIds[n2]][0]];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = ZigZag8x8[i2];
            nArray[n3] = nArray[n3] * nArray2[i2];
        }
    }

    byte[] decodeImageComponents() {
        if (this.nComponents == 3) {
            return this.convertYCbCrToRGB();
        }
        if (this.nComponents == 4) {
            return this.convertCMYKToRGB();
        }
        return this.convertYToRGB();
    }

    void decodeMCUAtXAndY(int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n8 = i2;
            while (this.scanHeader.componentParameters[this.componentIds[n8]] == null) {
                ++n8;
            }
            int[] nArray = this.frameComponents[this.componentIds[n8]];
            int n9 = nArray[1];
            int n10 = nArray[2];
            if (n4 == 1) {
                n9 = 1;
                n10 = 1;
            }
            int n11 = nArray[3];
            for (int i3 = 0; i3 < n10; ++i3) {
                for (int i4 = 0; i4 < n9; ++i4) {
                    int n12;
                    if (this.progressive) {
                        n12 = (n3 * n10 + i3) * n11 + n2 * n9 + i4;
                        this.dataUnit = this.dataUnits[n8][n12];
                        if (this.dataUnit == null) {
                            this.dataUnit = new int[64];
                            this.dataUnits[n8][n12] = this.dataUnit;
                        }
                    } else {
                        for (n12 = 0; n12 < this.dataUnit.length; ++n12) {
                            this.dataUnit[n12] = 0;
                        }
                    }
                    if (!this.progressive || this.scanHeader.isDCProgressiveScan()) {
                        this.decodeDCCoefficient(this.dataUnit, n8, bl, n7);
                    }
                    if (!this.progressive) {
                        this.decodeACCoefficients(this.dataUnit, n8);
                    } else {
                        if (this.scanHeader.isACProgressiveScan()) {
                            if (bl) {
                                this.decodeACFirstCoefficients(this.dataUnit, n8, n5, n6, n7);
                            } else {
                                this.decodeACRefineCoefficients(this.dataUnit, n8, n5, n6, n7);
                            }
                        }
                        if (this.loader.hasListeners()) {
                            int[] nArray2 = this.dataUnit;
                            this.dataUnit = new int[64];
                            System.arraycopy(nArray2, 0, this.dataUnit, 0, 64);
                        }
                    }
                    if (this.progressive && (!this.progressive || !this.loader.hasListeners())) continue;
                    this.dequantize(this.dataUnit, n8);
                    this.inverseDCT(this.dataUnit);
                    this.storeData(this.dataUnit, n8, n2, n3, n9, i4, n10, i3);
                }
            }
        }
    }

    void decodeScan() {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        if (this.progressive && !this.scanHeader.verifyProgressiveScan()) {
            SWT.error(40);
        }
        int n6 = this.scanHeader.getNumberOfImageComponents();
        int n7 = this.interleavedMcuRows;
        int n8 = this.interleavedMcuCols;
        if (n6 == 1) {
            bl = false;
            while (this.scanHeader.componentParameters[this.componentIds[bl]] == null) {
                bl += 1;
            }
            int[] nArray = this.frameComponents[this.componentIds[bl]];
            n5 = nArray[1];
            n4 = nArray[2];
            n3 = 8 * this.maxH / n5;
            n2 = 8 * this.maxV / n4;
            n8 = (this.imageWidth + n3 - 1) / n3;
            n7 = (this.imageHeight + n2 - 1) / n2;
        }
        bl = this.scanHeader.isFirstScan();
        int n9 = this.scanHeader.getStartOfSpectralSelection();
        n5 = this.scanHeader.getEndOfSpectralSelection();
        n4 = this.scanHeader.getApproxBitPositionLow();
        this.restartsToGo = this.restartInterval;
        this.nextRestartNumber = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            for (n2 = 0; n2 < n8; ++n2) {
                if (this.restartInterval != 0) {
                    if (this.restartsToGo == 0) {
                        this.processRestartInterval();
                    }
                    --this.restartsToGo;
                }
                this.decodeMCUAtXAndY(n2, n3, n6, bl, n9, n5, n4);
            }
        }
    }

    int decodeUsingTable(JPEGHuffmanTable jPEGHuffmanTable) {
        int n2 = 0;
        int[] nArray = jPEGHuffmanTable.getDhMaxCodes();
        int[] nArray2 = jPEGHuffmanTable.getDhMinCodes();
        int[] nArray3 = jPEGHuffmanTable.getDhValPtrs();
        int[] nArray4 = jPEGHuffmanTable.getDhValues();
        int n3 = this.nextBit();
        while (n3 > nArray[n2]) {
            n3 = n3 * 2 + this.nextBit();
            ++n2;
        }
        int n4 = nArray3[n2] + n3 - nArray2[n2];
        return nArray4[n4];
    }

    void emit(int n2, int n3) {
        if (n3 == 0) {
            SWT.error(40);
        }
        int[] nArray = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131125};
        int n4 = (n2 & nArray[n3 - 1]) << 24 - n3 - this.currentBitCount;
        byte[] byArray = new byte[]{(byte)(n4 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 >> 16 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
        int n5 = n3 - (8 - this.currentBitCount);
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 >> 3 > 0) {
            this.currentByte += byArray[2];
            this.emitByte((byte)this.currentByte);
            this.emitByte(byArray[1]);
            this.currentByte = byArray[0];
            this.currentBitCount += n3 - 16;
        } else {
            this.currentBitCount += n3;
            if (this.currentBitCount >= 8) {
                this.currentByte += byArray[2];
                this.emitByte((byte)this.currentByte);
                this.currentByte = byArray[1];
                this.currentBitCount -= 8;
            } else {
                this.currentByte += byArray[2];
            }
        }
    }

    void emitByte(byte by) {
        if (this.bufferCurrentPosition >= 512) {
            this.resetOutputBuffer();
        }
        this.dataBuffer[this.bufferCurrentPosition] = by;
        ++this.bufferCurrentPosition;
        if (by == -1) {
            this.emitByte((byte)0);
        }
    }

    void encodeACCoefficients(int[] nArray, int n2) {
        int[] nArray2 = this.scanHeader.componentParameters[n2];
        JPEGHuffmanTable jPEGHuffmanTable = this.acHuffmanTables[nArray2[1]];
        int[] nArray3 = jPEGHuffmanTable.ehCodes;
        byte[] byArray = jPEGHuffmanTable.ehCodeLengths;
        int n3 = 0;
        int n4 = 1;
        while (n4 < 64) {
            int n5;
            int n6;
            int n7;
            if ((n7 = nArray[ZigZag8x8[++n4 - 1]]) == 0) {
                if (n4 == 64) {
                    this.emit(nArray3[0], byArray[0] & 0xFF);
                    continue;
                }
                ++n3;
                continue;
            }
            while (n3 > 15) {
                this.emit(nArray3[240], byArray[240] & 0xFF);
                n3 -= 16;
            }
            if (n7 < 0) {
                n6 = n7;
                if (n6 < 0) {
                    n6 = -n6;
                }
                n5 = NBitsTable[n6];
                int n8 = n3 * 16 + n5;
                this.emit(nArray3[n8], byArray[n8] & 0xFF);
                this.emit(0xFFFFFF - n6, n5);
            } else {
                n6 = NBitsTable[n7];
                n5 = n3 * 16 + n6;
                this.emit(nArray3[n5], byArray[n5] & 0xFF);
                this.emit(n7, n6);
            }
            n3 = 0;
        }
    }

    void encodeDCCoefficients(int[] nArray, int n2) {
        int[] nArray2 = this.scanHeader.componentParameters[n2];
        JPEGHuffmanTable jPEGHuffmanTable = this.dcHuffmanTables[nArray2[0]];
        int n3 = this.precedingDCs[n2];
        int n4 = nArray[0];
        int n5 = n4 - n3;
        this.precedingDCs[n2] = n4;
        if (n5 < 0) {
            int n6 = 0 - n5;
            int n7 = NBitsTable[n6];
            this.emit(jPEGHuffmanTable.ehCodes[n7], jPEGHuffmanTable.ehCodeLengths[n7]);
            this.emit(0xFFFFFF - n6, n7);
        } else {
            int n8 = NBitsTable[n5];
            this.emit(jPEGHuffmanTable.ehCodes[n8], jPEGHuffmanTable.ehCodeLengths[n8]);
            if (n8 != 0) {
                this.emit(n5, n8);
            }
        }
    }

    void encodeMCUAtXAndY(int n2, int n3) {
        int n4 = this.scanHeader.getNumberOfImageComponents();
        this.dataUnit = new int[64];
        for (int i2 = 0; i2 < n4; ++i2) {
            int[] nArray = this.frameComponents[this.componentIds[i2]];
            int n5 = nArray[1];
            int n6 = nArray[2];
            for (int i3 = 0; i3 < n6; ++i3) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    this.extractData(this.dataUnit, i2, n2, n3, i4, i3);
                    this.forwardDCT(this.dataUnit);
                    this.quantizeData(this.dataUnit, i2);
                    this.encodeDCCoefficients(this.dataUnit, i2);
                    this.encodeACCoefficients(this.dataUnit, i2);
                }
            }
        }
    }

    void encodeScan() {
        for (int i2 = 0; i2 < this.interleavedMcuRows; ++i2) {
            for (int i3 = 0; i3 < this.interleavedMcuCols; ++i3) {
                this.encodeMCUAtXAndY(i3, i2);
            }
        }
        if (this.currentBitCount != 0) {
            this.emitByte((byte)this.currentByte);
        }
        this.resetOutputBuffer();
    }

    void expandImageComponents() {
        for (int i2 = 0; i2 < this.nComponents; ++i2) {
            int[] nArray = this.frameComponents[this.componentIds[i2]];
            int n2 = nArray[1];
            int n3 = this.maxH / n2;
            int n4 = nArray[2];
            int n5 = this.maxV / n4;
            if (n3 * n5 <= 1) continue;
            byte[] byArray = this.imageComponents[i2];
            int n6 = nArray[3];
            int n7 = nArray[4];
            int n8 = n6 * n3;
            int n9 = n7 * n5;
            ImageData imageData = new ImageData(n6, n7, 8, new PaletteData(RGB16), 4, byArray);
            ImageData imageData2 = imageData.scaledTo(n8, n9);
            this.imageComponents[i2] = imageData2.data;
        }
    }

    int extendBy(int n2, int n3) {
        if (n2 < ExtendTest[n3]) {
            return n2 + ExtendOffset[n3];
        }
        return n2;
    }

    void extractData(int[] nArray, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = this.imageComponents[n2];
        int[] nArray2 = this.frameComponents[this.componentIds[n2]];
        int n7 = nArray2[1];
        int n8 = nArray2[2];
        int n9 = nArray2[3];
        int n10 = (n4 * n8 + n6) * n9 * 8 + (n3 * n7 + n5) * 8;
        int n11 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                nArray[n11] = (byArray[n10 + i3] & 0xFF) - 128;
                ++n11;
            }
            n10 += n9;
        }
    }

    void forwardDCT(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        for (n21 = 0; n21 < 8; ++n21) {
            n20 = n21 * 8;
            n19 = nArray[n20] + nArray[n20 + 7];
            n18 = nArray[n20] - nArray[n20 + 7];
            n17 = nArray[n20 + 1] + nArray[n20 + 6];
            n16 = nArray[n20 + 1] - nArray[n20 + 6];
            n15 = nArray[n20 + 2] + nArray[n20 + 5];
            n14 = nArray[n20 + 2] - nArray[n20 + 5];
            n13 = nArray[n20 + 3] + nArray[n20 + 4];
            n12 = nArray[n20 + 3] - nArray[n20 + 4];
            n11 = n19 + n13;
            n10 = n19 - n13;
            n9 = n17 + n15;
            n8 = n17 - n15;
            nArray[n20] = (n11 + n9) * 4;
            nArray[n20 + 4] = (n11 - n9) * 4;
            n7 = (n8 + n10) * 4433;
            n6 = n7 + n10 * 6270 + 1024;
            nArray[n20 + 2] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n22 = n20 + 2;
                nArray[n22] = nArray[n22] - 1;
            }
            n6 = n7 + n8 * -15137 + 1024;
            nArray[n20 + 6] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n23 = n20 + 6;
                nArray[n23] = nArray[n23] - 1;
            }
            n7 = n12 + n18;
            n5 = n14 + n16;
            n4 = n12 + n16;
            n3 = n14 + n18;
            n2 = (n4 + n3) * 9633;
            n12 *= 2446;
            n14 *= 16819;
            n16 *= 25172;
            n18 *= 12299;
            n5 *= -20995;
            n4 *= -16069;
            n3 *= -3196;
            n3 += n2;
            n6 = n12 + (n7 *= -7373) + (n4 += n2) + 1024;
            nArray[n20 + 7] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n24 = n20 + 7;
                nArray[n24] = nArray[n24] - 1;
            }
            n6 = n14 + n5 + n3 + 1024;
            nArray[n20 + 5] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n25 = n20 + 5;
                nArray[n25] = nArray[n25] - 1;
            }
            n6 = n16 + n5 + n4 + 1024;
            nArray[n20 + 3] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n26 = n20 + 3;
                nArray[n26] = nArray[n26] - 1;
            }
            n6 = n18 + n7 + n3 + 1024;
            nArray[n20 + 1] = n6 >> 11;
            if (n6 >= 0 || (n6 & 0x7FF) == 0) continue;
            int n27 = n20 + 1;
            nArray[n27] = nArray[n27] - 1;
        }
        for (n21 = 0; n21 < 8; ++n21) {
            n20 = n21;
            n19 = n21 + 8;
            n18 = n21 + 16;
            n17 = n21 + 24;
            n16 = n21 + 32;
            n15 = n21 + 40;
            n14 = n21 + 48;
            n13 = n21 + 56;
            n12 = nArray[n20] + nArray[n13];
            n11 = nArray[n20] - nArray[n13];
            n10 = nArray[n19] + nArray[n14];
            n9 = nArray[n19] - nArray[n14];
            n8 = nArray[n18] + nArray[n15];
            n7 = nArray[n18] - nArray[n15];
            n6 = nArray[n17] + nArray[n16];
            n5 = nArray[n17] - nArray[n16];
            n4 = n12 + n6;
            n3 = n12 - n6;
            n2 = n10 + n8;
            int n28 = n10 - n8;
            int n29 = n4 + n2 + 16;
            nArray[n20] = n29 >> 5;
            if (n29 < 0 && (n29 & 0x1F) != 0) {
                int n30 = n20;
                nArray[n30] = nArray[n30] - 1;
            }
            n29 = n4 - n2 + 16;
            nArray[n16] = n29 >> 5;
            if (n29 < 0 && (n29 & 0x1F) != 0) {
                int n31 = n16;
                nArray[n31] = nArray[n31] - 1;
            }
            int n32 = (n28 + n3) * 4433;
            n29 = n32 + n3 * 6270 + 131072;
            nArray[n18] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n33 = n18;
                nArray[n33] = nArray[n33] - 1;
            }
            n29 = n32 + n28 * -15137 + 131072;
            nArray[n14] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n34 = n14;
                nArray[n34] = nArray[n34] - 1;
            }
            n32 = n5 + n11;
            int n35 = n7 + n9;
            int n36 = n5 + n9;
            int n37 = n7 + n11;
            int n38 = (n36 + n37) * 9633;
            n5 *= 2446;
            n7 *= 16819;
            n9 *= 25172;
            n11 *= 12299;
            n35 *= -20995;
            n36 *= -16069;
            n37 *= -3196;
            n37 += n38;
            n29 = n5 + (n32 *= -7373) + (n36 += n38) + 131072;
            nArray[n13] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n39 = n13;
                nArray[n39] = nArray[n39] - 1;
            }
            n29 = n7 + n35 + n37 + 131072;
            nArray[n15] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n40 = n15;
                nArray[n40] = nArray[n40] - 1;
            }
            n29 = n9 + n35 + n36 + 131072;
            nArray[n17] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n41 = n17;
                nArray[n41] = nArray[n41] - 1;
            }
            n29 = n11 + n32 + n37 + 131072;
            nArray[n19] = n29 >> 18;
            if (n29 >= 0 || (n29 & 0x3FFFF) == 0) continue;
            int n42 = n19;
            nArray[n42] = nArray[n42] - 1;
        }
    }

    void getAPP0() {
        JPEGAppn jPEGAppn = new JPEGAppn(this.inputStream);
        if (!jPEGAppn.verify()) {
            SWT.error(40);
        }
    }

    void getCOM() {
        new JPEGComment(this.inputStream);
    }

    void getDAC() {
        new JPEGArithmeticConditioningTable(this.inputStream);
    }

    void getDHT() {
        JPEGHuffmanTable jPEGHuffmanTable = new JPEGHuffmanTable(this.inputStream);
        if (!jPEGHuffmanTable.verify()) {
            SWT.error(40);
        }
        if (this.acHuffmanTables == null) {
            this.acHuffmanTables = new JPEGHuffmanTable[4];
        }
        if (this.dcHuffmanTables == null) {
            this.dcHuffmanTables = new JPEGHuffmanTable[4];
        }
        JPEGHuffmanTable[] jPEGHuffmanTableArray = jPEGHuffmanTable.getAllTables();
        for (int i2 = 0; i2 < jPEGHuffmanTableArray.length; ++i2) {
            JPEGHuffmanTable jPEGHuffmanTable2 = jPEGHuffmanTableArray[i2];
            if (jPEGHuffmanTable2.getTableClass() == 0) {
                this.dcHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
                continue;
            }
            this.acHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
        }
    }

    void getDNL() {
        new JPEGRestartInterval(this.inputStream);
    }

    void getDQT() {
        JPEGQuantizationTable jPEGQuantizationTable = new JPEGQuantizationTable(this.inputStream);
        Object object = this.quantizationTables;
        if (object == null) {
            object = new int[4][];
        }
        int[] nArray = jPEGQuantizationTable.getQuantizationTablesKeys();
        int[][] nArray2 = jPEGQuantizationTable.getQuantizationTablesValues();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            object[n2] = nArray2[i2];
        }
        this.quantizationTables = object;
    }

    void getDRI() {
        JPEGRestartInterval jPEGRestartInterval = new JPEGRestartInterval(this.inputStream);
        if (!jPEGRestartInterval.verify()) {
            SWT.error(40);
        }
        this.restartInterval = jPEGRestartInterval.getRestartInterval();
    }

    static void initialize() {
        JPEGFileFormat.initializeRGBYCbCrTables();
        JPEGFileFormat.initializeYCbCrRGBTables();
        JPEGFileFormat.initializeBitCountTable();
    }

    static void initializeBitCountTable() {
        int n2 = 1;
        int n3 = 2;
        NBitsTable = new int[2048];
        JPEGFileFormat.NBitsTable[0] = 0;
        for (int i2 = 1; i2 < NBitsTable.length; ++i2) {
            if (i2 >= n3) {
                n3 *= 2;
            }
            JPEGFileFormat.NBitsTable[i2] = ++n2;
        }
    }

    static void initializeRGBYCbCrTables() {
        RYTable = new int[256];
        GYTable = new int[256];
        BYTable = new int[256];
        RCbTable = new int[256];
        GCbTable = new int[256];
        BCbTable = new int[256];
        RCrTable = BCbTable;
        GCrTable = new int[256];
        BCrTable = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            JPEGFileFormat.RYTable[i2] = i2 * 19595;
            JPEGFileFormat.GYTable[i2] = i2 * 38470;
            JPEGFileFormat.BYTable[i2] = i2 * 7471 + 32768;
            JPEGFileFormat.RCbTable[i2] = i2 * -11059;
            JPEGFileFormat.GCbTable[i2] = i2 * -21709;
            JPEGFileFormat.BCbTable[i2] = i2 * 32768 + 0x800000;
            JPEGFileFormat.GCrTable[i2] = i2 * -27439;
            JPEGFileFormat.BCrTable[i2] = i2 * -5329;
        }
    }

    static void initializeYCbCrRGBTables() {
        CrRTable = new int[256];
        CbBTable = new int[256];
        CrGTable = new int[256];
        CbGTable = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = 2 * i2 - 255;
            JPEGFileFormat.CrRTable[i2] = 45941 * n2 + 32768 >> 16;
            JPEGFileFormat.CbBTable[i2] = 58065 * n2 + 32768 >> 16;
            JPEGFileFormat.CrGTable[i2] = -23401 * n2;
            JPEGFileFormat.CbGTable[i2] = -11277 * n2 + 32768;
        }
    }

    void inverseDCT(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        for (n16 = 0; n16 < 8; ++n16) {
            n15 = n16 * 8;
            if (this.isZeroInRow(nArray, n15)) {
                n14 = nArray[n15] << 2;
                for (n13 = n15 + 7; n13 >= n15; --n13) {
                    nArray[n13] = n14;
                }
                continue;
            }
            n14 = nArray[n15 + 2];
            n13 = nArray[n15 + 6];
            n12 = (n14 + n13) * 4433;
            n11 = n12 + n13 * -15137;
            n10 = n12 + n14 * 6270;
            n9 = nArray[n15] + nArray[n15 + 4] << 13;
            n8 = nArray[n15] - nArray[n15 + 4] << 13;
            n7 = n9 + n10;
            n6 = n9 - n10;
            n5 = n8 + n11;
            n4 = n8 - n11;
            n9 = nArray[n15 + 7];
            n8 = nArray[n15 + 5];
            n11 = nArray[n15 + 3];
            n10 = nArray[n15 + 1];
            n12 = n9 + n10;
            n14 = n8 + n11;
            n13 = n9 + n11;
            n3 = n8 + n10;
            n2 = (n13 + n3) * 9633;
            n9 *= 2446;
            n8 *= 16819;
            n11 *= 25172;
            n10 *= 12299;
            n13 *= -16069;
            n3 *= -3196;
            n9 += (n12 *= -7373) + (n13 += n2);
            nArray[n15] = n7 + (n10 += n12 + n3) + 1024 >> 11;
            nArray[n15 + 7] = n7 - n10 + 1024 >> 11;
            nArray[n15 + 1] = n5 + (n11 += n14 + n13) + 1024 >> 11;
            nArray[n15 + 6] = n5 - n11 + 1024 >> 11;
            nArray[n15 + 2] = n4 + (n8 += (n14 *= -20995) + (n3 += n2)) + 1024 >> 11;
            nArray[n15 + 5] = n4 - n8 + 1024 >> 11;
            nArray[n15 + 3] = n6 + n9 + 1024 >> 11;
            nArray[n15 + 4] = n6 - n9 + 1024 >> 11;
        }
        for (n16 = 0; n16 < 8; ++n16) {
            n15 = n16;
            n14 = n16 + 8;
            n13 = n16 + 16;
            n12 = n16 + 24;
            n11 = n16 + 32;
            n10 = n16 + 40;
            n9 = n16 + 48;
            n8 = n16 + 56;
            if (this.isZeroInColumn(nArray, n16)) {
                nArray[n15] = n7 = nArray[n15] + 16 >> 5;
                nArray[n14] = n7;
                nArray[n13] = n7;
                nArray[n12] = n7;
                nArray[n11] = n7;
                nArray[n10] = n7;
                nArray[n9] = n7;
                nArray[n8] = n7;
                continue;
            }
            n7 = nArray[n15];
            n6 = nArray[n13];
            n5 = nArray[n9];
            n4 = nArray[n11];
            n3 = (n6 + n5) * 4433;
            n2 = n3 + n5 * -15137;
            int n17 = n3 + n6 * 6270;
            int n18 = n7 + n4 << 13;
            int n19 = n7 - n4 << 13;
            int n20 = n18 + n17;
            int n21 = n18 - n17;
            int n22 = n19 + n2;
            int n23 = n19 - n2;
            n18 = nArray[n8];
            n19 = nArray[n10];
            n2 = nArray[n12];
            n17 = nArray[n14];
            n3 = n18 + n17;
            n6 = n19 + n2;
            n5 = n18 + n2;
            n4 = n19 + n17;
            n7 = (n5 + n4) * 9633;
            n18 *= 2446;
            n19 *= 16819;
            n2 *= 25172;
            n17 *= 12299;
            n5 *= -16069;
            n4 *= -3196;
            n18 += (n3 *= -7373) + (n5 += n7);
            nArray[n15] = n20 + (n17 += n3 + n4) + 131072 >> 18;
            nArray[n8] = n20 - n17 + 131072 >> 18;
            nArray[n14] = n22 + (n2 += n6 + n5) + 131072 >> 18;
            nArray[n9] = n22 - n2 + 131072 >> 18;
            nArray[n13] = n23 + (n19 += (n6 *= -20995) + (n4 += n7)) + 131072 >> 18;
            nArray[n10] = n23 - n19 + 131072 >> 18;
            nArray[n12] = n21 + n18 + 131072 >> 18;
            nArray[n11] = n21 - n18 + 131072 >> 18;
        }
    }

    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            JPEGStartOfImage jPEGStartOfImage = new JPEGStartOfImage(lEDataInputStream);
            lEDataInputStream.unread(jPEGStartOfImage.reference);
            return jPEGStartOfImage.verify();
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isZeroInColumn(int[] nArray, int n2) {
        return nArray[n2 + 8] == 0 && nArray[n2 + 16] == 0 && nArray[n2 + 24] == 0 && nArray[n2 + 32] == 0 && nArray[n2 + 40] == 0 && nArray[n2 + 48] == 0 && nArray[n2 + 56] == 0;
    }

    boolean isZeroInRow(int[] nArray, int n2) {
        return nArray[n2 + 1] == 0 && nArray[n2 + 2] == 0 && nArray[n2 + 3] == 0 && nArray[n2 + 4] == 0 && nArray[n2 + 5] == 0 && nArray[n2 + 6] == 0 && nArray[n2 + 7] == 0;
    }

    ImageData[] loadFromByteStream() {
        int n2;
        int n3;
        JPEGStartOfImage jPEGStartOfImage = new JPEGStartOfImage(this.inputStream);
        if (!jPEGStartOfImage.verify()) {
            SWT.error(40);
        }
        this.restartInterval = 0;
        this.processTables();
        this.frameHeader = new JPEGFrameHeader(this.inputStream);
        if (!this.frameHeader.verify()) {
            SWT.error(40);
        }
        this.imageWidth = this.frameHeader.getSamplesPerLine();
        this.imageHeight = this.frameHeader.getNumberOfLines();
        this.maxH = this.frameHeader.getMaxHFactor();
        this.maxV = this.frameHeader.getMaxVFactor();
        int n4 = this.maxH * 8;
        int n5 = this.maxV * 8;
        this.interleavedMcuCols = (this.imageWidth + n4 - 1) / n4;
        this.interleavedMcuRows = (this.imageHeight + n5 - 1) / n5;
        this.progressive = this.frameHeader.isProgressive();
        this.samplePrecision = this.frameHeader.getSamplePrecision();
        this.nComponents = this.frameHeader.getNumberOfImageComponents();
        this.frameComponents = this.frameHeader.componentParameters;
        this.componentIds = this.frameHeader.componentIdentifiers;
        this.imageComponents = new byte[this.nComponents][];
        if (this.progressive) {
            this.dataUnits = new int[this.nComponents][][];
        } else {
            this.dataUnit = new int[64];
        }
        for (n3 = 0; n3 < this.nComponents; ++n3) {
            int[] nArray = this.frameComponents[this.componentIds[n3]];
            n2 = nArray[3] * nArray[4];
            this.imageComponents[n3] = new byte[n2];
            if (!this.progressive) continue;
            this.dataUnits[n3] = new int[n2][];
        }
        this.processTables();
        this.scanHeader = new JPEGScanHeader(this.inputStream);
        if (!this.scanHeader.verify()) {
            SWT.error(40);
        }
        n3 = 0;
        boolean bl = false;
        while (!bl) {
            Object object;
            this.resetInputBuffer();
            this.precedingDCs = new int[4];
            this.decodeScan();
            if (this.progressive && this.loader.hasListeners()) {
                ImageData imageData = this.createImageData();
                this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n3, false));
                ++n3;
            }
            if ((n2 = 512 - this.bufferCurrentPosition - 1) > 0) {
                object = new byte[n2];
                System.arraycopy(this.dataBuffer, this.bufferCurrentPosition + 1, object, 0, n2);
                try {
                    this.inputStream.unread((byte[])object);
                }
                catch (IOException iOException) {
                    SWT.error(39, iOException);
                }
            }
            if ((object = (Object)this.processTables()) == null || ((JPEGSegment)object).getSegmentMarker() == 65497) {
                bl = true;
                continue;
            }
            this.scanHeader = new JPEGScanHeader(this.inputStream);
            if (this.scanHeader.verify()) continue;
            SWT.error(40);
        }
        if (this.progressive) {
            for (n2 = 0; n2 < this.interleavedMcuRows; ++n2) {
                for (int i2 = 0; i2 < this.interleavedMcuCols; ++i2) {
                    for (int i3 = 0; i3 < this.nComponents; ++i3) {
                        int[] nArray = this.frameComponents[this.componentIds[i3]];
                        int n6 = nArray[1];
                        int n7 = nArray[2];
                        int n8 = nArray[3];
                        for (int i4 = 0; i4 < n7; ++i4) {
                            for (int i5 = 0; i5 < n6; ++i5) {
                                int n9 = (n2 * n7 + i4) * n8 + i2 * n6 + i5;
                                this.dataUnit = this.dataUnits[i3][n9];
                                this.dequantize(this.dataUnit, i3);
                                this.inverseDCT(this.dataUnit);
                                this.storeData(this.dataUnit, i3, i2, n2, n6, i5, n7, i4);
                            }
                        }
                    }
                }
            }
            this.dataUnits = null;
        }
        ImageData imageData = this.createImageData();
        if (this.progressive && this.loader.hasListeners()) {
            this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n3, true));
        }
        return new ImageData[]{imageData};
    }

    ImageData createImageData() {
        return ImageData.internal_new(this.imageWidth, this.imageHeight, this.nComponents * this.samplePrecision, this.setUpPalette(), this.nComponents == 1 ? 4 : 1, this.decodeImageComponents(), 0, null, null, -1, -1, 4, 0, 0, 0, 0);
    }

    int nextBit() {
        byte by;
        if (this.currentBitCount != 0) {
            --this.currentBitCount;
            this.currentByte *= 2;
            if (this.currentByte > 255) {
                this.currentByte -= 256;
                return 1;
            }
            return 0;
        }
        ++this.bufferCurrentPosition;
        if (this.bufferCurrentPosition >= 512) {
            this.resetInputBuffer();
            this.bufferCurrentPosition = 0;
        }
        this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        this.currentBitCount = 8;
        if (this.bufferCurrentPosition == 511) {
            this.resetInputBuffer();
            this.currentBitCount = 8;
            by = this.dataBuffer[0];
        } else {
            by = this.dataBuffer[this.bufferCurrentPosition + 1];
        }
        if (this.currentByte == 255) {
            if (by == 0) {
                ++this.bufferCurrentPosition;
                --this.currentBitCount;
                this.currentByte *= 2;
                if (this.currentByte > 255) {
                    this.currentByte -= 256;
                    return 1;
                }
                return 0;
            }
            if ((by & 0xFF) + 65280 == 65500) {
                this.getDNL();
                return 0;
            }
            SWT.error(40);
            return 0;
        }
        --this.currentBitCount;
        this.currentByte *= 2;
        if (this.currentByte > 255) {
            this.currentByte -= 256;
            return 1;
        }
        return 0;
    }

    void processRestartInterval() {
        do {
            ++this.bufferCurrentPosition;
            if (this.bufferCurrentPosition > 511) {
                this.resetInputBuffer();
                this.bufferCurrentPosition = 0;
            }
            this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        } while (this.currentByte != 255);
        while (this.currentByte == 255) {
            ++this.bufferCurrentPosition;
            if (this.bufferCurrentPosition > 511) {
                this.resetInputBuffer();
                this.bufferCurrentPosition = 0;
            }
            this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        }
        if (this.currentByte != (65488 + this.nextRestartNumber & 0xFF)) {
            SWT.error(40);
        }
        ++this.bufferCurrentPosition;
        if (this.bufferCurrentPosition > 511) {
            this.resetInputBuffer();
            this.bufferCurrentPosition = 0;
        }
        this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        this.currentBitCount = 8;
        this.restartsToGo = this.restartInterval;
        this.nextRestartNumber = this.nextRestartNumber + 1 & 7;
        this.precedingDCs = new int[4];
        this.eobrun = 0;
    }

    JPEGSegment processTables() {
        JPEGSegment jPEGSegment;
        block10: while ((jPEGSegment = JPEGFileFormat.seekUnspecifiedMarker(this.inputStream)) != null) {
            JPEGFrameHeader jPEGFrameHeader = new JPEGFrameHeader(jPEGSegment.reference);
            if (jPEGFrameHeader.verify()) {
                return jPEGSegment;
            }
            int n2 = jPEGSegment.getSegmentMarker();
            switch (n2) {
                case 65496: {
                    SWT.error(40);
                }
                case 65497: 
                case 65498: {
                    return jPEGSegment;
                }
                case 65499: {
                    this.getDQT();
                    continue block10;
                }
                case 65476: {
                    this.getDHT();
                    continue block10;
                }
                case 65484: {
                    this.getDAC();
                    continue block10;
                }
                case 65501: {
                    this.getDRI();
                    continue block10;
                }
                case 65504: {
                    this.getAPP0();
                    continue block10;
                }
                case 65534: {
                    this.getCOM();
                    continue block10;
                }
            }
            JPEGFileFormat.skipSegmentFrom(this.inputStream);
        }
        return null;
    }

    void quantizeData(int[] nArray, int n2) {
        int[] nArray2 = this.quantizationTables[this.frameComponents[this.componentIds[n2]][0]];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = ZigZag8x8[i2];
            int n4 = nArray[n3];
            int n5 = n4 < 0 ? 0 - n4 : n4;
            int n6 = nArray2[i2];
            int n7 = n6 >> 1;
            if ((n5 += n7) < n6) {
                nArray[n3] = 0;
                continue;
            }
            n5 /= n6;
            nArray[n3] = n4 >= 0 ? n5 : 0 - n5;
        }
    }

    int receive(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 2 + this.nextBit();
        }
        return n3;
    }

    void resetInputBuffer() {
        if (this.dataBuffer == null) {
            this.dataBuffer = new byte[512];
        }
        try {
            this.inputStream.read(this.dataBuffer);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.currentBitCount = 0;
        this.bufferCurrentPosition = -1;
    }

    void resetOutputBuffer() {
        if (this.dataBuffer == null) {
            this.dataBuffer = new byte[512];
        } else {
            try {
                this.outputStream.write(this.dataBuffer, 0, this.bufferCurrentPosition);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        this.bufferCurrentPosition = 0;
    }

    static JPEGSegment seekUnspecifiedMarker(LEDataInputStream lEDataInputStream) {
        byte[] byArray = new byte[2];
        try {
            while (true) {
                if (lEDataInputStream.read(byArray, 0, 1) != 1) {
                    return null;
                }
                if (byArray[0] != -1) continue;
                if (lEDataInputStream.read(byArray, 1, 1) != 1) {
                    return null;
                }
                if (byArray[1] != -1 && byArray[1] != 0) break;
            }
            lEDataInputStream.unread(byArray);
            return new JPEGSegment(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
            return null;
        }
    }

    PaletteData setUpPalette() {
        if (this.nComponents == 1) {
            RGB[] rGBArray = new RGB[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                rGBArray[i2] = new RGB(i2, i2, i2);
            }
            return new PaletteData(rGBArray);
        }
        return new PaletteData(255, 65280, 0xFF0000);
    }

    static void skipSegmentFrom(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[4];
            JPEGSegment jPEGSegment = new JPEGSegment(byArray);
            if (lEDataInputStream.read(byArray) != byArray.length) {
                SWT.error(40);
            }
            if (byArray[0] != -1 || byArray[1] == 0 || byArray[1] == -1) {
                SWT.error(40);
            }
            int n2 = jPEGSegment.getSegmentLength() - 2;
            lEDataInputStream.skip(n2);
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
    }

    void storeData(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        byte[] byArray = this.imageComponents[n2];
        int[] nArray2 = this.frameComponents[this.componentIds[n2]];
        int n9 = nArray2[3];
        int n10 = (n4 * n7 + n8) * n9 * 8 + (n3 * n5 + n6) * 8;
        int n11 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                int n12 = nArray[n11] + 128;
                if (n12 < 0) {
                    n12 = 0;
                } else if (n12 > 255) {
                    n12 = 255;
                }
                byArray[n10 + i3] = (byte)n12;
                ++n11;
            }
            n10 += n9;
        }
    }

    void unloadIntoByteStream(ImageLoader imageLoader) {
        int n2;
        int n3;
        int[][] nArrayArray;
        int[][] nArrayArray2;
        int n4;
        JPEGAppn jPEGAppn;
        ImageData imageData = imageLoader.data[0];
        if (!new JPEGStartOfImage().writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        if (!(jPEGAppn = new JPEGAppn(new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0})).writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        this.quantizationTables = new int[4][];
        JPEGQuantizationTable jPEGQuantizationTable = JPEGQuantizationTable.defaultChrominanceTable();
        jPEGQuantizationTable.scaleBy(this.encoderQFactor);
        int[] nArray = jPEGQuantizationTable.getQuantizationTablesKeys();
        int[][] nArray2 = jPEGQuantizationTable.getQuantizationTablesValues();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.quantizationTables[nArray[i2]] = nArray2[i2];
        }
        JPEGQuantizationTable jPEGQuantizationTable2 = JPEGQuantizationTable.defaultLuminanceTable();
        jPEGQuantizationTable2.scaleBy(this.encoderQFactor);
        nArray = jPEGQuantizationTable2.getQuantizationTablesKeys();
        nArray2 = jPEGQuantizationTable2.getQuantizationTablesValues();
        for (n4 = 0; n4 < nArray.length; ++n4) {
            this.quantizationTables[nArray[n4]] = nArray2[n4];
        }
        if (!jPEGQuantizationTable2.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        if (!jPEGQuantizationTable.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        if (imageData.depth == 1) {
            n4 = 11;
            nArrayArray2 = new int[][]{{1, 1, 1, 0, 0}};
            nArrayArray = new int[][]{{0, 0}};
            n3 = 8;
            this.nComponents = 1;
            n2 = 1;
        } else {
            n4 = 17;
            nArrayArray2 = new int[][]{{0, 2, 2, 0, 0}, {1, 1, 1, 0, 0}, {1, 1, 1, 0, 0}};
            nArrayArray = new int[][]{{0, 0}, {1, 1}, {1, 1}};
            n3 = 12;
            this.nComponents = 3;
            n2 = 8;
        }
        this.imageWidth = imageData.width;
        this.imageHeight = imageData.height;
        this.frameHeader = new JPEGFrameHeader(new byte[19]);
        this.frameHeader.setSegmentMarker(65472);
        this.frameHeader.setSegmentLength(n4);
        this.frameHeader.setSamplePrecision(n2);
        this.frameHeader.setSamplesPerLine(this.imageWidth);
        this.frameHeader.setNumberOfLines(this.imageHeight);
        this.frameHeader.setNumberOfImageComponents(this.nComponents);
        this.frameHeader.componentParameters = nArrayArray2;
        this.frameHeader.componentIdentifiers = new int[]{0, 1, 2};
        this.frameHeader.initializeContents();
        if (!this.frameHeader.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        this.frameComponents = nArrayArray2;
        this.componentIds = this.frameHeader.componentIdentifiers;
        this.maxH = this.frameHeader.getMaxHFactor();
        this.maxV = this.frameHeader.getMaxVFactor();
        int n5 = this.maxH * 8;
        int n6 = this.maxV * 8;
        this.interleavedMcuCols = (this.imageWidth + n5 - 1) / n5;
        this.interleavedMcuRows = (this.imageHeight + n6 - 1) / n6;
        this.acHuffmanTables = new JPEGHuffmanTable[4];
        this.dcHuffmanTables = new JPEGHuffmanTable[4];
        JPEGHuffmanTable[] jPEGHuffmanTableArray = new JPEGHuffmanTable[]{JPEGHuffmanTable.getDefaultDCLuminanceTable(), JPEGHuffmanTable.getDefaultDCChrominanceTable(), JPEGHuffmanTable.getDefaultACLuminanceTable(), JPEGHuffmanTable.getDefaultACChrominanceTable()};
        for (int i3 = 0; i3 < jPEGHuffmanTableArray.length; ++i3) {
            JPEGHuffmanTable jPEGHuffmanTable = jPEGHuffmanTableArray[i3];
            if (!jPEGHuffmanTable.writeToStream(this.outputStream)) {
                SWT.error(39);
            }
            JPEGHuffmanTable[] jPEGHuffmanTableArray2 = jPEGHuffmanTable.getAllTables();
            for (int i4 = 0; i4 < jPEGHuffmanTableArray2.length; ++i4) {
                JPEGHuffmanTable jPEGHuffmanTable2 = jPEGHuffmanTableArray2[i4];
                if (jPEGHuffmanTable2.getTableClass() == 0) {
                    this.dcHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
                    continue;
                }
                this.acHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
            }
        }
        this.precedingDCs = new int[4];
        this.scanHeader = new JPEGScanHeader(new byte[14]);
        this.scanHeader.setSegmentMarker(65498);
        this.scanHeader.setSegmentLength(n3);
        this.scanHeader.setNumberOfImageComponents(this.nComponents);
        this.scanHeader.setStartOfSpectralSelection(0);
        this.scanHeader.setEndOfSpectralSelection(63);
        this.scanHeader.componentParameters = nArrayArray;
        this.scanHeader.initializeContents();
        if (!this.scanHeader.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        this.convertImageToYCbCr(imageData);
        this.resetOutputBuffer();
        this.currentByte = 0;
        this.currentBitCount = 0;
        this.encodeScan();
        if (!new JPEGEndOfImage().writeToStream(this.outputStream)) {
            SWT.error(39);
        }
    }

    static {
        JPEGFileFormat.initialize();
    }
}

