/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.PngFileReadState;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngIendChunk;
import org.eclipse.swt.internal.image.PngIhdrChunk;
import org.eclipse.swt.internal.image.PngPlteChunk;
import org.eclipse.swt.internal.image.PngTrnsChunk;

class PngChunk {
    byte[] reference;
    static final int LENGTH_OFFSET = 0;
    static final int TYPE_OFFSET = 4;
    static final int DATA_OFFSET = 8;
    static final int TYPE_FIELD_LENGTH = 4;
    static final int LENGTH_FIELD_LENGTH = 4;
    static final int MIN_LENGTH = 12;
    static final int CHUNK_UNKNOWN = -1;
    static final int CHUNK_IHDR = 0;
    static final int CHUNK_PLTE = 1;
    static final int CHUNK_IDAT = 2;
    static final int CHUNK_IEND = 3;
    static final int CHUNK_tRNS = 5;
    static final byte[] TYPE_IHDR = new byte[]{73, 72, 68, 82};
    static final byte[] TYPE_PLTE = new byte[]{80, 76, 84, 69};
    static final byte[] TYPE_IDAT = new byte[]{73, 68, 65, 84};
    static final byte[] TYPE_IEND = new byte[]{73, 69, 78, 68};
    static final byte[] TYPE_tRNS = new byte[]{116, 82, 78, 83};
    static final int[] CRC_TABLE = new int[256];

    PngChunk(byte[] byArray) {
        this.setReference(byArray);
    }

    PngChunk(int n2) {
        this(new byte[12 + n2]);
        this.setLength(n2);
    }

    byte[] getReference() {
        return this.reference;
    }

    void setReference(byte[] byArray) {
        this.reference = byArray;
    }

    int getInt16(int n2) {
        int n3 = 0;
        n3 |= (this.reference[n2] & 0xFF) << 8;
        return n3 |= this.reference[n2 + 1] & 0xFF;
    }

    void setInt16(int n2, int n3) {
        this.reference[n2] = (byte)(n3 >> 8 & 0xFF);
        this.reference[n2 + 1] = (byte)(n3 & 0xFF);
    }

    int getInt32(int n2) {
        int n3 = 0;
        n3 |= (this.reference[n2] & 0xFF) << 24;
        n3 |= (this.reference[n2 + 1] & 0xFF) << 16;
        n3 |= (this.reference[n2 + 2] & 0xFF) << 8;
        return n3 |= this.reference[n2 + 3] & 0xFF;
    }

    void setInt32(int n2, int n3) {
        this.reference[n2] = (byte)(n3 >> 24 & 0xFF);
        this.reference[n2 + 1] = (byte)(n3 >> 16 & 0xFF);
        this.reference[n2 + 2] = (byte)(n3 >> 8 & 0xFF);
        this.reference[n2 + 3] = (byte)(n3 & 0xFF);
    }

    int getLength() {
        return this.getInt32(0);
    }

    void setLength(int n2) {
        this.setInt32(0, n2);
    }

    byte[] getTypeBytes() {
        byte[] byArray = new byte[4];
        System.arraycopy(this.reference, 4, byArray, 0, 4);
        return byArray;
    }

    void setType(byte[] byArray) {
        if (byArray.length != 4) {
            SWT.error(5);
        }
        System.arraycopy(byArray, 0, this.reference, 4, 4);
    }

    byte[] getData() {
        int n2 = this.getLength();
        if (this.reference.length < 12 + n2) {
            SWT.error(6);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.reference, 8, byArray, 0, n2);
        return byArray;
    }

    void setData(byte[] byArray) {
        this.setLength(byArray.length);
        System.arraycopy(byArray, 0, this.reference, 8, byArray.length);
        this.setCRC(this.computeCRC());
    }

    int getCRC() {
        int n2 = 8 + this.getLength();
        return this.getInt32(n2);
    }

    void setCRC(int n2) {
        int n3 = 8 + this.getLength();
        this.setInt32(n3, n2);
    }

    int getSize() {
        return 12 + this.getLength();
    }

    boolean checkCRC() {
        int n2;
        int n3 = this.computeCRC();
        return n3 == (n2 = this.getCRC());
    }

    int computeCRC() {
        int n2 = -1;
        int n3 = 4;
        int n4 = 8 + this.getLength();
        for (int i2 = n3; i2 < n4; ++i2) {
            int n5 = (n2 ^ this.reference[i2]) & 0xFF;
            n2 = CRC_TABLE[n5] ^ n2 >> 8 & 0xFFFFFF;
        }
        return ~n2;
    }

    boolean typeMatchesArray(byte[] byArray) {
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.reference[4 + i2] == byArray[i2]) continue;
            return false;
        }
        return true;
    }

    boolean isCritical() {
        return Character.isUpperCase((char)this.getTypeBytes()[0]);
    }

    int getChunkType() {
        if (this.typeMatchesArray(TYPE_IHDR)) {
            return 0;
        }
        if (this.typeMatchesArray(TYPE_PLTE)) {
            return 1;
        }
        if (this.typeMatchesArray(TYPE_IDAT)) {
            return 2;
        }
        if (this.typeMatchesArray(TYPE_IEND)) {
            return 3;
        }
        if (this.typeMatchesArray(TYPE_tRNS)) {
            return 5;
        }
        return -1;
    }

    static PngChunk readNextFromStream(LEDataInputStream lEDataInputStream) {
        try {
            int n2 = 8;
            byte[] byArray = new byte[n2];
            int n3 = lEDataInputStream.read(byArray, 0, n2);
            lEDataInputStream.unread(byArray);
            if (n3 != n2) {
                return null;
            }
            PngChunk pngChunk = new PngChunk(byArray);
            int n4 = pngChunk.getSize();
            byte[] byArray2 = new byte[n4];
            n3 = lEDataInputStream.read(byArray2, 0, n4);
            if (n3 != n4) {
                return null;
            }
            switch (pngChunk.getChunkType()) {
                case 0: {
                    return new PngIhdrChunk(byArray2);
                }
                case 1: {
                    return new PngPlteChunk(byArray2);
                }
                case 2: {
                    return new PngIdatChunk(byArray2);
                }
                case 3: {
                    return new PngIendChunk(byArray2);
                }
                case 5: {
                    return new PngTrnsChunk(byArray2);
                }
            }
            return new PngChunk(byArray2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        byte[] byArray;
        if (this.reference.length < 12) {
            SWT.error(40);
        }
        if (!Character.isUpperCase((char)(byArray = this.getTypeBytes())[2])) {
            SWT.error(40);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (Compatibility.isLetter((char)byArray[i2])) continue;
            SWT.error(40);
        }
        if (!this.checkCRC()) {
            SWT.error(40);
        }
    }

    void contributeToString(StringBuffer stringBuffer) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("\n\tLength: ");
        stringBuffer.append(this.getLength());
        stringBuffer.append("\n\tType: ");
        byte[] byArray = this.getTypeBytes();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append((char)byArray[i2]);
        }
        this.contributeToString(stringBuffer);
        stringBuffer.append("\n\tCRC: ");
        stringBuffer.append(Integer.toHexString(this.getCRC()));
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            PngChunk.CRC_TABLE[i2] = i2;
            for (int i3 = 0; i3 < 8; ++i3) {
                PngChunk.CRC_TABLE[i2] = (CRC_TABLE[i2] & 1) == 0 ? CRC_TABLE[i2] >> 1 & Integer.MAX_VALUE : 0xEDB88320 ^ CRC_TABLE[i2] >> 1 & Integer.MAX_VALUE;
            }
        }
    }
}

