/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import org.eclipse.swt.internal.swing.CTableItemImplementation;
import org.eclipse.swt.widgets.TableItem;

public interface CTableItem {
    public TableItemObject getTableItemObject(int var1);

    public void setChecked(boolean var1);

    public boolean isChecked();

    public void setGrayed(boolean var1);

    public boolean isGrayed();

    public void insertColumn(int var1);

    public void removeColumn(int var1);

    public void setForeground(Color var1);

    public Color getForeground();

    public void setBackground(Color var1);

    public Color getBackground();

    public void setFont(Font var1);

    public Font getFont();

    public TableItem getTableItem();

    public static class Factory {
        private Factory() {
        }

        public static CTableItem newInstance(TableItem tableItem, int style) {
            return new CTableItemImplementation(tableItem, style);
        }
    }

    public static class TableItemObject {
        protected CTableItem tableItem;
        protected String text;
        protected Icon icon;
        protected Color background;
        protected Color foreground;
        protected Font font;

        public CTableItem getTableItem() {
            return this.tableItem;
        }

        protected TableItemObject(CTableItem tableItem) {
            this.tableItem = tableItem;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text == null ? "" : this.text;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setBackground(Color background) {
            this.background = background;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public String toString() {
            if (!((CTableItemImplementation)this.tableItem).handle.isDisposed()) {
                ((CTableItemImplementation)this.tableItem).handle.getText();
            }
            return this.getText();
        }

        public boolean isChecked() {
            return this.tableItem.isChecked();
        }

        public boolean isGrayed() {
            return this.tableItem.isGrayed();
        }
    }
}

