/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CTree;
import org.eclipse.swt.internal.swing.CTreeColumn;
import org.eclipse.swt.internal.swing.CTreeImplementation;
import org.eclipse.swt.internal.swing.CTreeItem;
import org.eclipse.swt.internal.swing.DefaultMutableTreeTableNode;
import org.eclipse.swt.internal.swing.DefaultTreeTableCellRenderer;
import org.eclipse.swt.internal.swing.JStateCheckBox;
import org.eclipse.swt.internal.swing.JTreeTable;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.TreeTableCellRenderer;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

class CTreeImplementation
extends JScrollPane
implements CTree {
    protected Tree handle;
    protected JTreeTable treeTable;
    protected DefaultMutableTreeTableNode rootNode;
    protected boolean isCheckType;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;
    protected boolean isAdjustingColumnOrder;

    public Container getSwingComponent() {
        return this.treeTable;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CTreeImplementation(Tree tree, int n2) {
        this.handle = tree;
        this.setViewport(new JViewport(){

            public boolean isOpaque() {
                return CTreeImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                Utils.paintTiledImage(this, g2, CTreeImplementation.this.backgroundImageIcon);
                super.paintComponent(g2);
            }

            public Color getBackground() {
                return CTreeImplementation.this != null && CTreeImplementation.this.userAttributeHandler != null && CTreeImplementation.this.userAttributeHandler.background != null ? CTreeImplementation.this.userAttributeHandler.background : super.getBackground();
            }
        });
        this.rootNode = new DefaultMutableTreeTableNode(){

            public void insert(MutableTreeNode newChild, int childIndex) {
                super.insert(newChild, childIndex);
                CTreeImplementation.this.getModel().nodesWereInserted(this, new int[]{childIndex});
                CTreeImplementation.this.treeTable.expandPath(new TreePath(CTreeImplementation.this.rootNode.getPath()));
            }
        };
        this.treeTable = new JTreeTable(new DefaultTreeModel(this.rootNode)){
            protected Graphics graphics;

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this, this.getColumnModel()){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String getToolTipText(MouseEvent e2) {
                        int index = this.columnModel.getColumnIndexAtX(e2.getX());
                        if (index < 0) {
                            return null;
                        }
                        return ((CTreeColumn)((Object)this.columnModel.getColumn(index))).getToolTipText();
                    }

                    public void paint(Graphics g2) {
                        TreeColumn sortColumn;
                        super.paint(g2);
                        if ((this.this$1).CTreeImplementation.this.handle.getSortDirection() != 0 && (sortColumn = (this.this$1).CTreeImplementation.this.handle.getSortColumn()) != null) {
                            Rectangle bounds = this.this$1.getCellRect(-1, (this.this$1).CTreeImplementation.this.treeTable.convertColumnIndexToView((this.this$1).CTreeImplementation.this.handle.indexOf(sortColumn)), false);
                            TableColumn draggedColumn = this.getDraggedColumn();
                            Shape clip = g2.getClip();
                            if (draggedColumn != null) {
                                int draggedDistance = this.getDraggedDistance();
                                if (((CTreeColumn)((Object)draggedColumn)).getTreeColumn() == sortColumn) {
                                    bounds.x += draggedDistance;
                                } else {
                                    Rectangle dragBounds = this.this$1.getCellRect(-1, (this.this$1).CTreeImplementation.this.treeTable.convertColumnIndexToView((this.this$1).CTreeImplementation.this.handle.indexOf(((CTreeColumn)((Object)draggedColumn)).getTreeColumn())), true);
                                    dragBounds.x += draggedDistance;
                                    bounds.height = this.getHeight();
                                    if (bounds.x < dragBounds.x) {
                                        g2.clipRect(0, 0, dragBounds.x, bounds.height);
                                    } else {
                                        int x = dragBounds.x + dragBounds.width;
                                        g2.clipRect(x, 0, this.getWidth() - x, bounds.height);
                                    }
                                }
                            }
                            this.paintSortArrow(g2, bounds);
                            g2.setClip(clip);
                        }
                    }

                    protected void paintSortArrow(Graphics g2, Rectangle bounds) {
                        Color color = this.getBackground().darker();
                        boolean priority = false;
                        int height = Math.round((float)this.getHeight() / 1.5f);
                        int x = bounds.x + bounds.width;
                        int y = 1;
                        boolean descending = (this.this$1).CTreeImplementation.this.handle.getSortDirection() == 1024;
                        int dx = (int)((double)(height / 2) * Math.pow(0.8, (double)priority));
                        if (bounds.width < dx * 3) {
                            return;
                        }
                        x -= dx * 2;
                        if (dx % 2 != 0) {
                            ++dx;
                        }
                        int dy = descending ? dx / 2 : -dx / 2;
                        y = y + 4 * height / 6 + (descending ? -dy : 0);
                        int shift = descending ? 1 : -1;
                        g2.translate(x, y);
                        g2.setColor(color);
                        int[] nArray = new int[4];
                        nArray[1] = dx / 2;
                        nArray[2] = dx;
                        int[] nArray2 = new int[4];
                        nArray2[1] = dy;
                        g2.fillPolygon(nArray, nArray2, 4);
                        g2.setColor(color.darker());
                        g2.drawLine(dx / 2, dy, 0, 0);
                        g2.drawLine(dx / 2, dy + shift, 0, shift);
                        g2.setColor(color.brighter());
                        g2.drawLine(dx / 2, dy, dx, 0);
                        g2.drawLine(dx / 2, dy + shift, dx, shift);
                        if (descending) {
                            g2.setColor(color.darker().darker());
                        } else {
                            g2.setColor(color.brighter());
                        }
                        g2.drawLine(dx, 0, 0, 0);
                        g2.setColor(color);
                        g2.translate(-x, -y);
                    }
                };
            }

            public boolean getScrollableTracksViewportWidth() {
                return CTreeImplementation.this.handle.isDisposed() ? false : CTreeImplementation.this.handle.getColumnCount() == 0 && this.getPreferredSize().width < this.getParent().getWidth();
            }

            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }

            public Dimension getPreferredScrollableViewportSize() {
                if (CTreeImplementation.this.handle.getColumnCount() != 0) {
                    return this.getPreferredSize();
                }
                int columnCount = CTreeImplementation.this.treeTable.getColumnModel().getColumnCount();
                int width = 0;
                int i2 = 0;
                while (i2 < columnCount) {
                    width += this.getPreferredColumnWidth(i2);
                    ++i2;
                }
                width += columnCount - 1;
                return new Dimension(width += columnCount, this.getPreferredSize().height);
            }

            /*
             * Enabled aggressive block sorting
             */
            protected boolean processMouseOnTreeRenderer(int row, MouseEvent e2, Dimension cellSize) {
                if (CTreeImplementation.this.isCheckType) {
                    TreePath treePath = CTreeImplementation.this.treeTable.getPathForRow(row);
                    DefaultMutableTreeTableNode node = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)CTreeImplementation.this.treeTable.getCellRenderer().getTreeTableCellRendererComponent(CTreeImplementation.this.treeTable, node.getUserObject(), CTreeImplementation.this.treeTable.isRowSelected(row), CTreeImplementation.this.treeTable.isExpanded(treePath), node.isLeaf(), row, 0, false);
                    checkBoxCellRenderer.setSize(cellSize);
                    checkBoxCellRenderer.doLayout();
                    Point point = e2.getPoint();
                    Component component = checkBoxCellRenderer.getComponentAt(point);
                    JStateCheckBox stateCheckBox = checkBoxCellRenderer.getStateCheckBox();
                    if (component == stateCheckBox) {
                        switch (e2.getID()) {
                            case 501: {
                                CTreeItem.TreeItemObject treeItemObject = (CTreeItem.TreeItemObject)node.getUserObject(0);
                                boolean ischecked = !treeItemObject.isChecked();
                                treeItemObject.getTreeItem().setChecked(ischecked);
                                ((DefaultTreeModel)CTreeImplementation.this.treeTable.getModel()).nodeChanged(node);
                                CTreeImplementation.this.handle.processEvent(new ItemEvent(stateCheckBox, 701, node, ischecked ? 1 : 2));
                            }
                            case 500: 
                            case 502: 
                            case 506: {
                                return false;
                            }
                        }
                    }
                }
                switch (e2.getID()) {
                    case 501: {
                        switch (e2.getButton()) {
                            case 1: {
                                TreeSelectionModel selectionModel = this.getSelectionModel();
                                if (selectionModel.getSelectionCount() != 1 || !selectionModel.isRowSelected(row)) return super.processMouseOnTreeRenderer(row, e2, cellSize);
                                selectionModel.clearSelection();
                                break;
                            }
                            case 3: {
                                TreeSelectionModel selectionModel = this.getSelectionModel();
                                if (selectionModel.isRowSelected(row)) return super.processMouseOnTreeRenderer(row, e2, cellSize);
                                selectionModel.setSelectionPath(this.getPathForRow(row));
                            }
                        }
                        return super.processMouseOnTreeRenderer(row, e2, cellSize);
                    }
                }
                return super.processMouseOnTreeRenderer(row, e2, cellSize);
            }

            public Color getBackground() {
                return CTreeImplementation.this != null && CTreeImplementation.this.userAttributeHandler != null && CTreeImplementation.this.userAttributeHandler.background != null ? CTreeImplementation.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CTreeImplementation.this != null && CTreeImplementation.this.userAttributeHandler != null && CTreeImplementation.this.userAttributeHandler.foreground != null ? CTreeImplementation.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CTreeImplementation.this != null && CTreeImplementation.this.userAttributeHandler != null && CTreeImplementation.this.userAttributeHandler.font != null ? CTreeImplementation.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                return CTreeImplementation.this != null && CTreeImplementation.this.userAttributeHandler != null && CTreeImplementation.this.userAttributeHandler.cursor != null ? CTreeImplementation.this.userAttributeHandler.cursor : super.getCursor();
            }

            public Graphics getGraphics() {
                Graphics g2 = this.graphics != null ? this.graphics.create() : super.getGraphics();
                return g2;
            }

            public boolean isOpaque() {
                return CTreeImplementation.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                this.graphics = g2;
                this.putClientProperty("SWTSwingGraphics2DClientProperty", g2);
                super.paintComponent(g2);
                CTreeImplementation.this.handle.processEvent(new PaintEvent(this, 800, null));
                this.putClientProperty("SWTSwingGraphics2DClientProperty", null);
                this.graphics = null;
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(this.treeTable);
        this.treeTable.setAutoResizeMode(0);
        this.treeTable.setCellRenderer((TreeTableCellRenderer)((Object)new /* invalid duplicate definition of identical inner class */));
        JTableHeader jTableHeader = this.treeTable.getTableHeader();
        jTableHeader.getColumnModel().addColumnModelListener((TableColumnModelListener)((Object)new DefaultTreeTableCellRenderer(){
            protected boolean isInitialized;
            protected boolean isDefaultOpaque;
            protected Color defaultForeground;
            protected Color defaultBackground;
            protected Font defaultFont;
            protected boolean isSelectionOpaque;
            protected Color selectionForeground;
            protected Color selectionBackground;
            protected Font selectionFont;
            protected CTreeItem.TreeItemObject treeItemObject;
            protected int row;
            protected int column;
            protected boolean ignoreDrawForeground;
            protected boolean ignoreDrawBackground;
            protected boolean ignoreDrawSelection;
            protected boolean ignoreDrawFocused;

            public Component getTreeTableCellRendererComponent(JTreeTable treeTable, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, int column, boolean hasFocus) {
                Component c2;
                if (value instanceof CTreeItem.TreeItemObject) {
                    this.treeItemObject = (CTreeItem.TreeItemObject)value;
                    CTree.CellPaintEvent event = new CTree.CellPaintEvent(treeTable, 1);
                    event.row = row;
                    event.column = column;
                    event.treeItem = this.treeItemObject.getTreeItem();
                    event.ignoreDrawSelection = !isSelected;
                    event.ignoreDrawFocused = !hasFocus;
                    CTreeImplementation.this.handle.processEvent(event);
                    this.ignoreDrawForeground = event.ignoreDrawForeground;
                    this.ignoreDrawBackground = event.ignoreDrawBackground;
                    this.ignoreDrawSelection = event.ignoreDrawSelection;
                    this.ignoreDrawFocused = event.ignoreDrawFocused;
                    isSelected = !event.ignoreDrawSelection;
                    hasFocus = !event.ignoreDrawFocused;
                    this.row = row;
                    this.column = column;
                } else {
                    this.treeItemObject = null;
                }
                if (!this.isInitialized) {
                    c2 = super.getTreeTableCellRendererComponent(treeTable, "", true, expanded, leaf, row, column, hasFocus);
                    if (c2 instanceof JComponent) {
                        this.isSelectionOpaque = ((JComponent)c2).isOpaque();
                    }
                    this.selectionForeground = c2.getForeground();
                    this.selectionBackground = c2.getBackground();
                    this.selectionFont = c2.getFont();
                }
                if (!this.isInitialized) {
                    c2 = super.getTreeTableCellRendererComponent(treeTable, "", false, expanded, leaf, row, column, hasFocus);
                    if (c2 instanceof JComponent) {
                        this.isDefaultOpaque = ((JComponent)c2).isOpaque();
                    }
                    this.defaultForeground = c2.getForeground();
                    this.defaultBackground = c2.getBackground();
                    this.defaultFont = c2.getFont();
                    this.isInitialized = true;
                }
                c2 = super.getTreeTableCellRendererComponent(treeTable, value, isSelected, expanded, leaf, row, column, hasFocus);
                if (value != null) {
                    CTreeItem.TreeItemObject treeItemObject;
                    Color userForeground = CTreeImplementation.this.userAttributeHandler.foreground;
                    c2.setForeground(isSelected ? this.selectionForeground : (userForeground != null ? userForeground : this.defaultForeground));
                    Color userBackground = CTreeImplementation.this.userAttributeHandler.background;
                    c2.setBackground(isSelected ? this.selectionBackground : (userBackground != null ? userBackground : this.defaultBackground));
                    Font userFont = CTreeImplementation.this.userAttributeHandler.font;
                    c2.setFont(isSelected ? this.selectionFont : (userFont != null ? userFont : this.defaultFont));
                    if (c2 instanceof JComponent) {
                        ((JComponent)c2).setOpaque(isSelected ? this.isSelectionOpaque : this.isDefaultOpaque && treeTable.isOpaque());
                    }
                    if ((treeItemObject = (CTreeItem.TreeItemObject)value) != null) {
                        Font font;
                        if (c2 instanceof JLabel) {
                            TableColumn tableColumn = treeTable.getColumnModel().getColumn(column);
                            JLabel label = (JLabel)c2;
                            if (tableColumn instanceof CTreeColumn) {
                                CTreeColumn treeColumn = (CTreeColumn)((Object)tableColumn);
                                label.setHorizontalAlignment(treeColumn.getAlignment());
                            }
                            label.setIcon(treeItemObject.getIcon());
                        }
                        CTreeItem cTreeItem = treeItemObject.getTreeItem();
                        Color foreground = treeItemObject.getForeground();
                        if (foreground != null) {
                            c2.setForeground(foreground);
                        } else {
                            foreground = cTreeItem.getForeground();
                            if (foreground != null) {
                                c2.setForeground(foreground);
                            }
                        }
                        if (!isSelected) {
                            Color background = treeItemObject.getBackground();
                            if (background != null) {
                                if (c2 instanceof JComponent) {
                                    ((JComponent)c2).setOpaque(true);
                                }
                                c2.setBackground(background);
                            } else {
                                background = cTreeItem.getBackground();
                                if (background != null) {
                                    if (c2 instanceof JComponent) {
                                        ((JComponent)c2).setOpaque(true);
                                    }
                                    c2.setBackground(background);
                                }
                            }
                        }
                        if ((font = treeItemObject.getFont()) != null) {
                            c2.setFont(font);
                        } else {
                            font = cTreeItem.getFont();
                            if (font != null) {
                                c2.setFont(font);
                            }
                        }
                    }
                }
                if (!CTreeImplementation.this.isCheckType || column != 0) {
                    return c2;
                }
                CheckBoxCellRenderer checkBoxCellRenderer = new CheckBoxCellRenderer(c2);
                if (this.treeItemObject != null) {
                    checkBoxCellRenderer.getStateCheckBox().setSelected(this.treeItemObject.isChecked());
                }
                return checkBoxCellRenderer;
            }

            protected void paintComponent(DefaultTreeTableCellRenderer.CellPainter c2, Graphics g2) {
                if (this.ignoreDrawForeground && c2 instanceof JLabel) {
                    ((JLabel)((Object)c2)).setText(null);
                }
                if (this.ignoreDrawBackground) {
                    CTreeImplementation.this.setOpaque(false);
                }
                super.paintComponent(c2, g2);
                if (this.treeItemObject != null) {
                    CTree.CellPaintEvent event = new CTree.CellPaintEvent(CTreeImplementation.this.treeTable, 2);
                    event.row = this.row;
                    event.column = this.column;
                    event.treeItem = this.treeItemObject.getTreeItem();
                    event.ignoreDrawForeground = this.ignoreDrawForeground;
                    event.ignoreDrawBackground = this.ignoreDrawBackground;
                    event.ignoreDrawSelection = this.ignoreDrawSelection;
                    event.ignoreDrawFocused = this.ignoreDrawFocused;
                    CTreeImplementation.this.handle.processEvent(event);
                }
            }

            protected DefaultTreeTableCellRenderer.InnerTreeCellRenderer createInnerTreeCellRenderer() {
                return new DefaultTreeTableCellRenderer.InnerTreeCellRenderer(this, this){
                    protected boolean isCreated = true;
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Color getBackgroundNonSelectionColor() {
                        return this.getBackground();
                    }

                    public Color getBackground() {
                        if (this.isOpaque()) {
                            return super.getBackground();
                        }
                        if (this.isCreated) {
                            if (!(this.this$1).CTreeImplementation.this.treeTable.isOpaque()) {
                                return null;
                            }
                            Color background = (this.this$1).CTreeImplementation.this.userAttributeHandler.background;
                            return background != null ? background : (this.this$1).CTreeImplementation.this.treeTable.getBackground();
                        }
                        return super.getBackground();
                    }
                };
            }
        }));
        HeaderMouseListener headerMouseListener = new HeaderMouseListener(this, jTableHeader);
        jTableHeader.addMouseListener((MouseListener)headerMouseListener);
        jTableHeader.addMouseMotionListener((MouseMotionListener)headerMouseListener);
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer((TableCellRenderer)((Object)new /* invalid duplicate definition of identical inner class */));
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        TableColumn tableColumn = new TableColumn(0);
        tableColumnModel.addColumn(tableColumn);
        this.treeTable.getInnerTree().setRootVisible(false);
        this.treeTable.getInnerTree().setShowsRootHandles(true);
        this.setFocusable(false);
        this.getViewport().setView(this.treeTable);
        this.setGridVisible(false);
        this.setColumnHeader(this.createViewport());
        this.setHeaderVisible(false);
        this.init(n2);
        this.treeTable.configureEnclosingScrollPane();
    }

    protected void init(int n2) {
        boolean bl = this.isCheckType = (n2 & 0x20) != 0;
        if ((n2 & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        if ((n2 & 2) == 0) {
            this.treeTable.setSelectionMode(1);
        }
        if ((n2 & 0x10000) != 0) {
            this.treeTable.setFullLineSelection(true);
        }
        this.treeTable.addTreeExpansionListener((TreeExpansionListener)((Object)new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e2) {
            }

            public void columnMarginChanged(ChangeEvent e2) {
            }

            public void columnMoved(TableColumnModelEvent e2) {
                if (CTreeImplementation.this.isAdjustingColumnOrder) {
                    return;
                }
                int toIndex = e2.getToIndex();
                int fromIndex = e2.getFromIndex();
                if (fromIndex != toIndex) {
                    TableColumnModel columnModel = CTreeImplementation.this.getColumnModel();
                    CTreeColumn cTreeColumn = (CTreeColumn)((Object)columnModel.getColumn(toIndex));
                    cTreeColumn.getTreeColumn().processEvent(e2);
                    cTreeColumn = (CTreeColumn)((Object)columnModel.getColumn(fromIndex));
                    cTreeColumn.getTreeColumn().processEvent(e2);
                }
            }

            public void columnRemoved(TableColumnModelEvent e2) {
            }

            public void columnSelectionChanged(ListSelectionEvent e2) {
            }
        }));
        this.treeTable.addTreeSelectionListener((TreeSelectionListener)((Object)new TableCellRenderer(this){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableColumn tableColumn;
                Component c2 = headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (c2 instanceof JLabel && (tableColumn = CTreeImplementation.this.treeTable.getColumnModel().getColumn(column)) instanceof CTreeColumn) {
                    JLabel label = (JLabel)c2;
                    CTreeColumn treeColumn = (CTreeColumn)((Object)tableColumn);
                    label.setHorizontalAlignment(treeColumn.getAlignment());
                    label.setIcon(treeColumn.getIcon());
                }
                return c2;
            }
        }));
        JTable jTable = this.treeTable.getInnerTable();
        Utils.installMouseListener(jTable, this.handle);
        Utils.installKeyListener(jTable, this.handle);
        Utils.installFocusListener(jTable, this.handle);
        Utils.installComponentListener(this, this.handle);
    }

    public Container getClientArea() {
        return this.treeTable.getInnerTable();
    }

    public void clearSelection() {
        this.treeTable.clearSelection();
    }

    public void selectAll() {
        this.treeTable.selectAll();
    }

    public TreeSelectionModel getSelectionModel() {
        return this.treeTable.getSelectionModel();
    }

    public void setGridVisible(boolean bl) {
        this.treeTable.setGridVisible(bl);
    }

    public boolean isGridVisible() {
        return this.treeTable.isGridVisible();
    }

    public JTableHeader getTableHeader() {
        return this.treeTable.getTableHeader();
    }

    public void expandPath(TreePath treePath) {
        this.treeTable.expandPath(treePath);
    }

    public void collapsePath(TreePath treePath) {
        this.treeTable.collapsePath(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        return this.treeTable.isExpanded(treePath);
    }

    public DefaultMutableTreeTableNode getRoot() {
        return this.rootNode;
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)this.treeTable.getModel();
    }

    public Rectangle getCellRect(int n2, int n3, boolean bl) {
        Rectangle rectangle = this.treeTable.getCellRect(n2, n3, bl);
        if (n3 == 0) {
            int n4 = this.treeTable.getInnerTree().getRowBounds((int)n2).x;
            rectangle.x += n4;
            rectangle.width -= n4;
        }
        if (this.isCheckType && n3 == 0) {
            TreePath treePath = this.treeTable.getPathForRow(n2);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeTableNode.getUserObject();
            Component component = this.treeTable.getCellRenderer().getTreeTableCellRendererComponent(this.treeTable, object, this.treeTable.isRowSelected(n2), this.treeTable.isExpanded(treePath), defaultMutableTreeTableNode.isLeaf(), n2, n3, false);
            component.setBounds(rectangle);
            if (component instanceof CheckBoxCellRenderer) {
                CheckBoxCellRenderer checkBoxCellRenderer = (CheckBoxCellRenderer)component;
                component = checkBoxCellRenderer.getComponent();
                int n5 = component.getBounds().x;
                rectangle.x += n5;
                rectangle.width -= n5;
            }
        }
        return rectangle;
    }

    public int getRowForPath(TreePath treePath) {
        return this.treeTable.getRowForPath(treePath);
    }

    public TableColumnModel getColumnModel() {
        return this.treeTable.getColumnModel();
    }

    public TreePath getPathForLocation(int n2, int n3) {
        Insets insets = this.getInsets();
        return this.treeTable.getPathForLocation(n2 -= insets.left, n3 -= insets.top);
    }

    public int getPreferredColumnWidth(int n2) {
        return this.treeTable.getPreferredColumnWidth(n2);
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                this.getViewport().setOpaque(true);
                this.treeTable.setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                this.getViewport().setOpaque(false);
                this.treeTable.setOpaque(false);
            }
        }
    }

    public int getRowHeight() {
        return this.treeTable.getRowHeight();
    }

    public void setRowHeight(int n2) {
        this.treeTable.setRowHeight(n2);
    }

    public void ensureRowVisible(int n2) {
        if (n2 < 0 || n2 >= this.treeTable.getRowCount()) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n2, 0, true);
        rectangle.width = this.treeTable.getWidth();
        rectangle.height = this.treeTable.getRowHeight(n2);
        this.treeTable.scrollRectToVisible(rectangle);
    }

    public void ensureColumnVisible(int n2) {
        if (n2 < 0 || n2 >= this.treeTable.getColumnCount()) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < n2; ++i2) {
            rectangle.x += tableColumnModel.getColumn(i2).getPreferredWidth();
        }
        rectangle.width = tableColumnModel.getColumn(n2).getPreferredWidth();
        rectangle.height = this.treeTable.getHeight();
        this.treeTable.scrollRectToVisible(rectangle);
    }

    public int rowAtPoint(Point point) {
        point = SwingUtilities.convertPoint(this, point.x, point.y, this.treeTable);
        return this.treeTable.rowAtPoint(point);
    }

    public int getTopIndex() {
        return this.rowAtPoint(new Point(0, 0));
    }

    public void setTopIndex(int n2) {
        this.ensureRowVisible(n2);
        if (n2 != 0) {
            this.ensureRowVisible(n2);
        }
    }

    public TreePath getPathForRow(int n2) {
        return this.treeTable.getPathForRow(n2);
    }

    public void setHeaderVisible(boolean bl) {
        this.getColumnHeader().setVisible(bl);
        this.treeTable.getTableHeader().setVisible(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.treeTable.setEnabled(bl);
    }

    public boolean isFocusable() {
        return this.treeTable.isFocusable();
    }

    public void requestFocus() {
        this.treeTable.requestFocus();
    }

    public void setColumnOrder(int[] nArray) {
        int n2;
        this.isAdjustingColumnOrder = true;
        JTable jTable = this.treeTable.getInnerTable();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            jTable.moveColumn(jTable.convertColumnIndexToView(nArray[n2]), n2);
        }
        this.isAdjustingColumnOrder = false;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            CTreeColumn cTreeColumn = (CTreeColumn)((Object)this.getColumnModel().getColumn(n2));
            cTreeColumn.getTreeColumn().processEvent(new TableColumnModelEvent(jTable.getColumnModel(), n2, nArray[n2]));
        }
    }

    public int[] getColumnOrder() {
        JTable jTable = this.treeTable.getInnerTable();
        int[] nArray = new int[jTable.getColumnCount()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = jTable.convertColumnIndexToModel(i2);
        }
        return nArray;
    }

    public Rectangle getImageBounds(int n2, int n3) {
        Serializable serializable;
        TreePath treePath = this.treeTable.getPathForRow(n2);
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeTableNode.getUserObject();
        Component component = this.treeTable.getCellRenderer().getTreeTableCellRendererComponent(this.treeTable, object, this.treeTable.isRowSelected(n2), this.treeTable.isExpanded(treePath), defaultMutableTreeTableNode.isLeaf(), n2, n3, false);
        Rectangle rectangle = this.treeTable.getCellRect(n2, n3, false);
        if (n3 == 0) {
            int n4 = this.treeTable.getInnerTree().getRowBounds((int)n2).x;
            rectangle.x += n4;
            rectangle.width -= n4;
        }
        component.setBounds(rectangle);
        Rectangle rectangle2 = new Rectangle();
        if (component instanceof CheckBoxCellRenderer) {
            serializable = (CheckBoxCellRenderer)component;
            component = serializable.getComponent();
            rectangle2.x += component.getBounds().x;
        }
        if (component instanceof JLabel) {
            serializable = new Rectangle();
            JLabel jLabel = (JLabel)component;
            SwingUtilities.layoutCompoundLabel(jLabel.getFontMetrics(jLabel.getFont()), jLabel.getText(), jLabel.getIcon(), jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), new Rectangle(), (Rectangle)serializable, new Rectangle(), jLabel.getIconTextGap());
            rectangle2.x += ((Rectangle)serializable).x;
            rectangle2.y += ((Rectangle)serializable).y;
            rectangle2.width = ((Rectangle)serializable).width;
            rectangle2.height = ((Rectangle)serializable).height;
        }
        if (n3 == 0) {
            rectangle2.x += this.treeTable.getInnerTree().getRowBounds((int)n2).x;
        }
        return rectangle2;
    }

    protected class CheckBoxCellRenderer
    extends JPanel {
        protected JStateCheckBox checkBox = new JStateCheckBox();
        protected Component component;

        public CheckBoxCellRenderer(Component component) {
            super(new BorderLayout(0, 0));
            this.component = component;
            this.setOpaque(false);
            this.checkBox.setOpaque(false);
            this.add((Component)this.checkBox, "West");
            this.add(component, "Center");
            this.addNotify();
        }

        public JStateCheckBox getStateCheckBox() {
            return this.checkBox;
        }

        public Component getComponent() {
            return this.component;
        }
    }
}

