/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DisabledStatePanel
extends JPanel {
    protected Control control;
    protected HierarchyListener hierarchyListener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent e2) {
            long changedFlags = e2.getChangeFlags();
            if ((changedFlags & 0x578L) != 0L) {
                Container component = DisabledStatePanel.this.control.handle;
                Container parent = component.getParent();
                boolean isRevalidationNeeded = false;
                if (parent != null) {
                    parent.add(component);
                    DisabledStatePanel.this.checkFocus();
                    isRevalidationNeeded = true;
                } else {
                    parent = DisabledStatePanel.this.getParent();
                    if (parent != null) {
                        parent.remove(DisabledStatePanel.this);
                        isRevalidationNeeded = true;
                    }
                }
                if (isRevalidationNeeded) {
                    if (parent instanceof JComponent) {
                        ((JComponent)parent).revalidate();
                    } else {
                        parent.invalidate();
                        parent.validate();
                        parent.repaint();
                    }
                }
            }
        }
    };
    protected ComponentListener componentListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent e2) {
            DisabledStatePanel.this.adjustBounds();
        }

        public void componentMoved(ComponentEvent e2) {
            DisabledStatePanel.this.adjustBounds();
        }
    };

    public DisabledStatePanel(Control control) {
        super(null);
        this.control = control;
        this.enableEvents(131128L);
        this.setOpaque(false);
        this.adjustBounds();
        Container container = control.handle;
        Container container2 = container.getParent();
        if (container2 != null) {
            if (container2 instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)container2)).getContentPane().add((Component)this, 0);
            } else {
                container2.add((Component)this, 0);
            }
            this.revalidate();
            this.checkFocus();
        }
        container.addHierarchyListener(this.hierarchyListener);
        container.addComponentListener(this.componentListener);
    }

    protected void checkFocus() {
        Component component;
        Window window;
        Container container = this.control.handle;
        Container container2 = container.getParent();
        if (container.isFocusOwner()) {
            container2.transferFocus();
        } else if (container instanceof Container && (window = SwingUtilities.getWindowAncestor(container2)) != null && (component = window.getFocusOwner()) != null && container.isAncestorOf(component)) {
            container2.transferFocus();
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.control.isDisposed()) {
            return;
        }
        Composite composite = this.control.getParent();
        if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Point point = SwingUtilities.convertPoint(this.control.handle, mouseEvent.getPoint(), composite.handle);
            if (aWTEvent instanceof MouseWheelEvent) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
                composite.processEvent(new MouseWheelEvent((Component)composite.handle, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
            } else {
                composite.processEvent(new MouseEvent(composite.handle, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
            }
        } else if (aWTEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            composite.processEvent(new KeyEvent(composite.handle, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
        }
    }

    protected void adjustBounds() {
        if (this.control != null && this.control.handle != null) {
            this.setBounds(this.control.handle.getBounds());
        }
    }

    public void release() {
        Container container = this.control.handle;
        Container container2 = container.getParent();
        if (container2 != null) {
            container2.remove(this);
            this.revalidate();
        }
        container.removeHierarchyListener(this.hierarchyListener);
        container.removeComponentListener(this.componentListener);
    }
}

