/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

class JExpandPaneLayout
implements LayoutManager {
    protected int spacing;

    JExpandPaneLayout() {
    }

    public void setSpacing(int n2) {
        this.spacing = n2;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void layoutContainer(Container container) {
        int n2 = Math.max(0, container.getWidth() - 2 * this.spacing);
        int n3 = container.getComponentCount();
        int n4 = this.spacing;
        for (int i2 = 0; i2 < n3; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            component.setBounds(this.spacing, n4, n2, dimension.height);
            n4 += dimension.height + this.spacing;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n2 = this.spacing;
        int n3 = 0;
        int n4 = container.getComponentCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            n3 = Math.max(n3, dimension.width);
            n2 += dimension.height + this.spacing;
        }
        return new Dimension(2 * this.spacing + n3, n2);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }
}

