/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    boolean visible = true;
    TrayIcon trayIcon;

    public TrayItem(Tray tray, int n2) {
        super(tray, n2);
        this.parent = tray;
        tray.createItem(this, tray.getItemCount());
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget() {
        this.trayIcon = new TrayIcon(new BufferedImage(1, 1, 1));
        this.trayIcon.addMouseListener(new MouseAdapter(){

            protected boolean processMenuEvent(MouseEvent e2) {
                switch (e2.getClickCount()) {
                    case 1: {
                        if (!e2.isPopupTrigger() || !TrayItem.this.hooks(35)) break;
                        UIThreadUtils.startExclusiveSection(TrayItem.this.display);
                        if (TrayItem.this.isDisposed()) {
                            UIThreadUtils.stopExclusiveSection();
                            return true;
                        }
                        TrayItem.this.sendEvent(35);
                        UIThreadUtils.stopExclusiveSection();
                        return true;
                    }
                }
                return false;
            }

            public void mousePressed(MouseEvent e2) {
                if (this.processMenuEvent(e2)) {
                    return;
                }
            }

            public void mouseReleased(MouseEvent e2) {
                if (this.processMenuEvent(e2)) {
                    return;
                }
                switch (e2.getClickCount()) {
                    case 1: {
                        if (!TrayItem.this.hooks(13)) break;
                        UIThreadUtils.startExclusiveSection(TrayItem.this.display);
                        if (TrayItem.this.isDisposed()) {
                            UIThreadUtils.stopExclusiveSection();
                            return;
                        }
                        try {
                            try {
                                TrayItem.this.postEvent(13);
                            }
                            catch (Throwable t2) {
                                UIThreadUtils.storeException(t2);
                            }
                            break;
                        }
                        finally {
                            UIThreadUtils.stopExclusiveSection();
                        }
                    }
                    case 2: {
                        if (!TrayItem.this.hooks(14)) break;
                        UIThreadUtils.startExclusiveSection(TrayItem.this.display);
                        if (TrayItem.this.isDisposed()) {
                            UIThreadUtils.stopExclusiveSection();
                            return;
                        }
                        TrayItem.this.postEvent(14);
                        UIThreadUtils.stopExclusiveSection();
                    }
                }
            }
        });
        try {
            SystemTray.getSystemTray().add(this.trayIcon);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.trayIcon.getToolTip();
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.toolTip != null) {
            this.toolTip.item = null;
        }
        this.toolTip = null;
        if (this.visible) {
            SystemTray.getSystemTray().remove(this.trayIcon);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        this.trayIcon.setImage(image.handle);
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip toolTip2 = this.toolTip;
        ToolTip toolTip3 = toolTip;
        if (toolTip2 != null) {
            toolTip2.item = null;
        }
        this.toolTip = toolTip3;
        if (toolTip3 != null) {
            toolTip3.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.trayIcon.setToolTip(string);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        if (bl) {
            try {
                SystemTray.getSystemTray().add(this.trayIcon);
                this.sendEvent(22);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            SystemTray.getSystemTray().remove(this.trayIcon);
            this.sendEvent(23);
        }
    }
}

