/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CTree;
import org.eclipse.swt.internal.swing.CTreeItem;
import org.eclipse.swt.internal.swing.DefaultMutableTreeTableNode;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    ArrayList itemList;
    ArrayList columnList;
    TreeItem currentItem;
    static final int GRID_WIDTH = 1;
    TreeColumn sortColumn;
    int sortDirection;

    public Tree(Composite composite, int n2) {
        super(composite, Tree.checkStyle(n2));
    }

    static int checkStyle(int n2) {
        return Tree.checkBits(n2 |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    void adjustColumnWidth() {
        if (this.getColumnCount() == 0) {
            CTree cTree = (CTree)((Object)this.handle);
            cTree.getColumnModel().getColumn(0).setPreferredWidth(cTree.getPreferredColumnWidth(0));
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean checkData(TreeItem treeItem, boolean bl) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        return this.checkData(treeItem, treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem), bl);
    }

    boolean checkData(TreeItem treeItem, int n2, boolean bl) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!treeItem.cached) {
            treeItem.cached = true;
            Event event = new Event();
            event.item = treeItem;
            event.index = n2;
            TreeItem treeItem2 = this.currentItem;
            this.currentItem = treeItem;
            this.sendEvent(36, event);
            this.currentItem = treeItem2;
            if (this.isDisposed() || treeItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    public void clear(int n2, boolean bl) {
        this.checkWidget();
        this.getItem(n2).clearAll(bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        for (int i2 = this.getItemCount() - 1; i2 >= 0; --i2) {
            this.getItem(i2).clearAll(bl);
        }
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        CTree cTree = (CTree)((Object)this.handle);
        return super.computeTrim(n2, n3, n4 += cTree.getVerticalScrollBar().getPreferredSize().width, n5 += cTree.getHorizontalScrollBar().getPreferredSize().height);
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFEFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CTree.Factory.newInstance(this, this.style));
    }

    void createItem(TreeColumn treeColumn, int n2) {
        Object object;
        for (int i2 = 0; i2 < this.itemList.size(); ++i2) {
            object = (TreeItem)this.itemList.get(i2);
            ((TreeItem)object).handle.insertColumn(n2);
            if (n2 != 0) continue;
            ((TreeItem)object).text = "";
            ((TreeItem)object).image = null;
        }
        TableColumnModel tableColumnModel = ((CTree)((Object)this.handle)).getColumnModel();
        object = (TableColumn)((Object)treeColumn.handle);
        if (this.columnList.isEmpty()) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        tableColumnModel.addColumn((TableColumn)object);
        ((TableColumn)object).setModelIndex(n2);
        this.columnList.add(n2, treeColumn);
        this.handle.repaint();
    }

    void createItem(TreeItem treeItem, int n2) {
        this.itemList.add(n2, treeItem);
        ((CTree)((Object)this.handle)).getRoot().insert((MutableTreeNode)((Object)treeItem.handle), n2);
    }

    void createItem(TreeItem treeItem, TreeItem treeItem2, int n2) {
        if (treeItem2.itemList == null) {
            treeItem2.itemList = new ArrayList();
        }
        treeItem2.itemList.add(n2, treeItem);
        ((MutableTreeNode)((Object)treeItem2.handle)).insert((MutableTreeNode)((Object)treeItem.handle), n2);
        ((CTree)((Object)this.handle)).getModel().nodesWereInserted((MutableTreeNode)((Object)treeItem2.handle), new int[]{n2});
    }

    void createWidget() {
        super.createWidget();
        this.itemList = new ArrayList();
        this.columnList = new ArrayList();
    }

    public void deselectAll() {
        this.checkWidget();
        ((CTree)((Object)this.handle)).clearSelection();
    }

    void destroyItem(TreeColumn treeColumn) {
        Object object;
        int n2 = this.columnList.indexOf(treeColumn);
        for (int i2 = 0; i2 < this.itemList.size(); ++i2) {
            object = (TreeItem)this.itemList.get(i2);
            ((TreeItem)object).handle.removeColumn(n2);
        }
        this.columnList.remove(n2);
        if (this.columnList.isEmpty()) {
            TableColumnModel tableColumnModel = ((CTree)((Object)this.handle)).getColumnModel();
            object = new TableColumn(0);
            tableColumnModel.addColumn((TableColumn)object);
        }
        if (this.sortColumn == treeColumn) {
            this.sortColumn = null;
            this.sortDirection = 0;
        }
        this.handle.repaint();
    }

    void destroyItem(TreeItem treeItem) {
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        JTableHeader jTableHeader = ((CTree)((Object)this.handle)).getTableHeader();
        return jTableHeader.isVisible() ? jTableHeader.getHeight() : 0;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((CTree)((Object)this.handle)).getTableHeader().isVisible();
    }

    public TreeColumn getColumn(int n2) {
        this.checkWidget();
        if (this.columnList == null) {
            this.error(6);
        }
        int n3 = this.getColumnCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        return (TreeColumn)this.columnList.get(n2);
    }

    public int getColumnCount() {
        this.checkWidget();
        if (this.columnList == null) {
            return 0;
        }
        return this.columnList.size();
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        return ((CTree)((Object)this.handle)).getColumnOrder();
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        if (this.columnList == null) {
            return new TreeColumn[0];
        }
        return this.columnList.toArray(new TreeColumn[0]);
    }

    public TreeItem getItem(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(6);
        }
        if (n2 >= this.itemList.size()) {
            this.error(6);
        }
        return (TreeItem)this.itemList.get(n2);
    }

    public TreeItem getItem(Point point) {
        TreePath treePath;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((treePath = ((CTree)((Object)this.handle)).getPathForLocation(point.x, point.y)) == null) {
            return null;
        }
        CTreeItem.TreeItemObject treeItemObject = (CTreeItem.TreeItemObject)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
        return treeItemObject.getTreeItem().getTreeItem();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemList == null ? 0 : this.itemList.size();
    }

    public int getItemHeight() {
        this.checkWidget();
        return ((CTree)((Object)this.handle)).getRowHeight();
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.itemList.toArray(new TreeItem[0]);
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((CTree)((Object)this.handle)).isGridVisible();
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        TreePath[] treePathArray = ((CTree)((Object)this.handle)).getSelectionModel().getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return new TreeItem[0];
        }
        TreeItem[] treeItemArray = new TreeItem[treePathArray.length];
        for (int i2 = 0; i2 < treeItemArray.length; ++i2) {
            treeItemArray[i2] = ((CTreeItem.TreeItemObject)((DefaultMutableTreeNode)treePathArray[i2].getLastPathComponent()).getUserObject()).getTreeItem().getTreeItem();
        }
        return treeItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return ((CTree)((Object)this.handle)).getSelectionModel().getSelectionCount();
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int n2 = ((CTree)((Object)this.handle)).getTopIndex();
        if (n2 < 0) {
            return null;
        }
        return ((CTreeItem)((CTree)((Object)this.handle)).getPathForRow(n2).getLastPathComponent()).getTreeItem();
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        return this.columnList.indexOf(treeColumn);
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        return this.itemList.indexOf(treeItem);
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n2;
        if (this.itemList != null) {
            for (n2 = 0; n2 < this.itemList.size(); ++n2) {
                item = (TreeItem)this.itemList.get(n2);
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.itemList = null;
        }
        if (this.columnList != null) {
            for (n2 = 0; n2 < this.columnList.size(); ++n2) {
                item = (TreeColumn)this.columnList.get(n2);
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columnList = null;
        }
        super.releaseChildren(bl);
    }

    void releaseItem(TreeItem treeItem, boolean bl) {
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 == null) {
            ((CTree)((Object)this.handle)).getRoot().remove((MutableTreeNode)((Object)treeItem.handle));
            int n2 = this.itemList.indexOf(treeItem);
            this.itemList.remove(n2);
            ((CTree)((Object)this.handle)).getModel().nodesWereRemoved(((CTree)((Object)this.handle)).getRoot(), new int[]{n2}, new Object[]{treeItem.handle});
        } else {
            ((DefaultMutableTreeTableNode)((Object)treeItem2.handle)).remove((MutableTreeNode)((Object)treeItem.handle));
            int n3 = treeItem2.itemList.indexOf(treeItem);
            treeItem2.itemList.remove(n3);
            ((CTree)((Object)this.handle)).getModel().nodesWereRemoved((DefaultMutableTreeTableNode)((Object)treeItem2.handle), new int[]{n3}, new Object[]{treeItem.handle});
        }
        this.handle.repaint();
        if (bl) {
            treeItem.release(false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        for (int i2 = this.itemList.size() - 1; i2 >= 0; --i2) {
            TreeItem treeItem = (TreeItem)this.itemList.get(i2);
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.dispose();
                continue;
            }
            this.itemList.remove(i2);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        Utils.notImplemented();
    }

    public void setItemCount(int n2) {
        this.checkWidget();
        n2 = Math.max(0, n2);
        this.setItemCount(null, this.itemList, n2);
    }

    void setItemCount(TreeItem treeItem, int n2) {
        if (treeItem.itemList == null) {
            treeItem.itemList = new ArrayList();
        }
        this.setItemCount(treeItem, treeItem.itemList, n2);
    }

    void setItemCount(TreeItem treeItem, ArrayList arrayList, int n2) {
        int n3;
        n2 = Math.max(0, n2);
        for (n3 = arrayList.size() - 1; n3 >= n2; --n3) {
            TreeItem treeItem2 = (TreeItem)arrayList.get(n3);
            if (treeItem2 != null && !treeItem2.isDisposed()) {
                treeItem2.release(false);
            }
            if (treeItem == null) {
                ((CTree)((Object)this.handle)).getRoot().remove(n3);
                continue;
            }
            ((DefaultMutableTreeTableNode)((Object)treeItem.handle)).remove(n3);
        }
        n3 = n2 - arrayList.size();
        if (n3 <= 0) {
            return;
        }
        arrayList.ensureCapacity(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (treeItem != null) {
                new TreeItem(treeItem, 0);
                continue;
            }
            new TreeItem(this, 0);
        }
    }

    void setItemHeight(int n2) {
        this.checkWidget();
        if (n2 < -1) {
            this.error(5);
        }
        ((CTree)((Object)this.handle)).setRowHeight(n2);
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        ((CTree)((Object)this.handle)).setGridVisible(bl);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        ((CTree)((Object)this.handle)).selectAll();
    }

    public void setColumnOrder(int[] nArray) {
        int n2;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length != (n2 = this.getColumnCount())) {
            this.error(5);
        }
        ((CTree)((Object)this.handle)).setColumnOrder(nArray);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        ((CTree)((Object)this.handle)).setHeaderVisible(bl);
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        int n2;
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        if ((n2 = treeItemArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            this.deselectAll();
            return;
        }
        TreePath[] treePathArray = new TreePath[treeItemArray.length];
        for (int i2 = 0; i2 < treeItemArray.length; ++i2) {
            treePathArray[i2] = new TreePath(treeItemArray[i2].handle.getPath());
        }
        ((CTree)((Object)this.handle)).getSelectionModel().setSelectionPaths(treePathArray);
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        this.sortColumn = treeColumn;
        this.handle.repaint();
    }

    public void setSortDirection(int n2) {
        this.checkWidget();
        if ((n2 & 0x480) == 0 && n2 != 0) {
            return;
        }
        this.sortDirection = n2;
        this.handle.repaint();
    }

    public void setTopItem(TreeItem treeItem) {
        int n2;
        this.checkWidget();
        if (treeItem == null) {
            SWT.error(4);
        }
        if (treeItem.isDisposed()) {
            SWT.error(5);
        }
        if ((n2 = ((CTree)((Object)this.handle)).getRowForPath(new TreePath(treeItem.handle.getPath()))) < 0) {
            return;
        }
        ((CTree)((Object)this.handle)).setTopIndex(n2);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        int n2 = this.indexOf(treeColumn);
        if (n2 == -1) {
            return;
        }
        ((CTree)((Object)this.handle)).ensureColumnVisible(n2);
    }

    public void showItem(TreeItem treeItem) {
        int n2;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if ((n2 = ((CTree)((Object)this.handle)).getRowForPath(new TreePath(treeItem.handle.getPath()))) < 0) {
            return;
        }
        ((CTree)((Object)this.handle)).ensureRowVisible(n2);
    }

    public void showSelection() {
        this.checkWidget();
        int n2 = ((CTree)((Object)this.handle)).getSelectionModel().getLeadSelectionRow();
        if (n2 == -1) {
            return;
        }
        ((CTree)((Object)this.handle)).ensureRowVisible(n2);
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Dimension dimension = this.handle.getPreferredSize();
        return new Point(dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 500: {
                if (this.hooks(14) && ((MouseEvent)aWTEvent).getClickCount() == 2) break;
                super.processEvent(aWTEvent);
                return;
            }
            case 701: {
                if (this.hooks(13)) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 500: {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    if (mouseEvent.getClickCount() != 2) break;
                    java.awt.Point point = mouseEvent.getPoint();
                    TreePath treePath = ((CTree)((Object)this.handle)).getPathForLocation(point.x, point.y);
                    if (treePath == null) break;
                    Event event = new Event();
                    event.item = ((CTreeItem)treePath.getLastPathComponent()).getTreeItem();
                    this.sendEvent(14, event);
                    break;
                }
                case 701: {
                    Event event = new Event();
                    event.detail = 32;
                    event.item = ((CTreeItem)((ItemEvent)aWTEvent).getItem()).getTreeItem();
                    this.sendEvent(13, event);
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject eventObject) {
        boolean bl;
        Serializable serializable;
        block46: {
            block48: {
                block47: {
                    block45: {
                        if (!(eventObject instanceof TreeExpansionEvent)) break block45;
                        serializable = ((TreeExpansionEvent)eventObject).getPath();
                        if (!(((TreePath)serializable).getLastPathComponent() instanceof CTreeItem)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        bl = ((CTree)((Object)this.handle)).isExpanded((TreePath)serializable);
                        if (bl) {
                            if (!this.hooks(17)) {
                                super.processEvent(eventObject);
                                return;
                            }
                        } else if (!this.hooks(18)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        break block46;
                    }
                    if (!(eventObject instanceof TreeSelectionEvent)) break block47;
                    serializable = ((TreeSelectionEvent)eventObject).getPath();
                    if (!(((TreePath)serializable).getLastPathComponent() instanceof CTreeItem)) {
                        super.processEvent(eventObject);
                        return;
                    }
                    if (!this.hooks(13)) {
                        super.processEvent(eventObject);
                        return;
                    }
                    break block46;
                }
                if (!(eventObject instanceof CTree.CellPaintEvent)) break block48;
                switch (((CTree.CellPaintEvent)eventObject).getType()) {
                    case 1: {
                        if (!this.hooks(40)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        break block46;
                    }
                    case 2: {
                        if (!this.hooks(42)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        break block46;
                    }
                    case 3: {
                        if (!this.hooks(41)) {
                            super.processEvent(eventObject);
                            return;
                        }
                        break block46;
                    }
                    default: {
                        super.processEvent(eventObject);
                        return;
                    }
                }
            }
            super.processEvent(eventObject);
            return;
        }
        if (this.isDisposed()) {
            super.processEvent(eventObject);
            return;
        }
        try {
            UIThreadUtils.startExclusiveSection(this.getDisplay());
            if (this.isDisposed()) {
                UIThreadUtils.stopExclusiveSection();
                super.processEvent(eventObject);
                return;
            }
            if (eventObject instanceof TreeExpansionEvent) {
                serializable = ((TreeExpansionEvent)eventObject).getPath();
                bl = ((CTree)((Object)this.handle)).isExpanded((TreePath)serializable);
                Event event = new Event();
                event.item = ((CTreeItem)((TreePath)serializable).getLastPathComponent()).getTreeItem();
                if (bl) {
                    this.sendEvent(17, event);
                    ((CTree)((Object)this.handle)).expandPath((TreePath)serializable);
                } else {
                    this.sendEvent(18, event);
                    ((CTree)((Object)this.handle)).collapsePath((TreePath)serializable);
                }
            } else if (eventObject instanceof TreeSelectionEvent) {
                serializable = ((TreeSelectionEvent)eventObject).getPath();
                Event event = new Event();
                event.item = ((CTreeItem)((TreePath)serializable).getLastPathComponent()).getTreeItem();
                this.sendEvent(13, event);
            } else if (eventObject instanceof CTree.CellPaintEvent) {
                serializable = (CTree.CellPaintEvent)eventObject;
                switch (((CTree.CellPaintEvent)serializable).getType()) {
                    case 1: {
                        TreeItem treeItem = ((CTree.CellPaintEvent)serializable).treeItem.getTreeItem();
                        Rectangle rectangle = treeItem.getBounds(((CTree.CellPaintEvent)serializable).column);
                        Event event = new Event();
                        event.x = rectangle.x;
                        event.y = rectangle.y;
                        event.width = rectangle.width;
                        event.height = rectangle.height;
                        event.item = treeItem;
                        event.index = ((CTree.CellPaintEvent)serializable).column;
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawForeground) {
                            event.detail |= 0x10;
                        }
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawBackground) {
                            event.detail |= 8;
                        }
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawSelection) {
                            event.detail |= 2;
                        }
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawFocused) {
                            event.detail |= 4;
                        }
                        event.gc = new GC(this);
                        event.gc.handle.setUserClip(((CTree)((Object)this.handle)).getCellRect(((CTree.CellPaintEvent)serializable).row, ((CTree.CellPaintEvent)serializable).column, false));
                        this.sendEvent(40, event);
                        if (event.doit) {
                            ((CTree.CellPaintEvent)serializable).ignoreDrawForeground = (event.detail & 0x10) == 0;
                            ((CTree.CellPaintEvent)serializable).ignoreDrawBackground = (event.detail & 8) == 0;
                            ((CTree.CellPaintEvent)serializable).ignoreDrawSelection = (event.detail & 2) == 0;
                            ((CTree.CellPaintEvent)serializable).ignoreDrawFocused = (event.detail & 4) == 0;
                            break;
                        }
                        ((CTree.CellPaintEvent)serializable).ignoreDrawForeground = true;
                        ((CTree.CellPaintEvent)serializable).ignoreDrawBackground = true;
                        ((CTree.CellPaintEvent)serializable).ignoreDrawSelection = true;
                        ((CTree.CellPaintEvent)serializable).ignoreDrawFocused = true;
                        break;
                    }
                    case 2: {
                        TreeItem treeItem = ((CTree.CellPaintEvent)serializable).treeItem.getTreeItem();
                        Rectangle rectangle = treeItem.getBounds(((CTree.CellPaintEvent)serializable).column);
                        Event event = new Event();
                        event.x = rectangle.x;
                        event.y = rectangle.y;
                        event.width = rectangle.width;
                        event.height = rectangle.height;
                        event.item = treeItem;
                        event.index = ((CTree.CellPaintEvent)serializable).column;
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawForeground) {
                            event.detail |= 0x10;
                        }
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawBackground) {
                            event.detail |= 8;
                        }
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawSelection) {
                            event.detail |= 2;
                        }
                        if (!((CTree.CellPaintEvent)serializable).ignoreDrawFocused) {
                            event.detail |= 4;
                        }
                        event.gc = new GC(this);
                        event.gc.handle.setUserClip(((CTree)((Object)this.handle)).getCellRect(((CTree.CellPaintEvent)serializable).row, ((CTree.CellPaintEvent)serializable).column, false));
                        this.sendEvent(42, event);
                        break;
                    }
                    case 3: {
                        TreeItem treeItem = ((CTree.CellPaintEvent)serializable).treeItem.getTreeItem();
                        Event event = new Event();
                        event.height = ((CTree.CellPaintEvent)serializable).rowHeight;
                        event.item = treeItem;
                        event.index = ((CTree.CellPaintEvent)serializable).column;
                        event.gc = new GC(this);
                        this.sendEvent(41, event);
                        ((CTree.CellPaintEvent)serializable).rowHeight = event.height;
                    }
                }
            }
            super.processEvent(eventObject);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

