/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Logger {
    private static OutputStream outLogStream;
    private static OutputStream inLogStream;
    private static final String LOG_PROPERTY = "cvsClientLog";
    private static boolean logging;

    static {
        Logger.setLogging(System.getProperty(LOG_PROPERTY));
    }

    public static void setLogging(String logPath) {
        logging = logPath != null;
        try {
            if (logging) {
                if (logPath.equals("system")) {
                    outLogStream = System.err;
                    inLogStream = System.err;
                } else {
                    outLogStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(logPath) + ".out"));
                    inLogStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(logPath) + ".in"));
                }
            }
        }
        catch (IOException e) {
            System.err.println("Unable to create log files: " + e);
            System.err.println("Logging DISABLED");
            logging = false;
            try {
                if (outLogStream != null) {
                    outLogStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inLogStream != null) {
                    inLogStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void logInput(byte[] received) {
        Logger.logInput(received, 0, received.length);
    }

    public static void logInput(byte[] received, int offset, int len) {
        if (!logging) {
            return;
        }
        try {
            inLogStream.write(received, offset, len);
            inLogStream.flush();
        }
        catch (IOException ex) {
            System.err.println("Could not write to log file: " + ex);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logInput(char received) {
        if (!logging) {
            return;
        }
        try {
            inLogStream.write(received);
            inLogStream.flush();
        }
        catch (IOException ex) {
            System.err.println("Could not write to log file: " + ex);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }

    public static void logOutput(byte[] sent) {
        if (!logging) {
            return;
        }
        try {
            outLogStream.write(sent);
            outLogStream.flush();
        }
        catch (IOException ex) {
            System.err.println("Could not write to log file: " + ex);
            System.err.println("Logging DISABLED.");
            logging = false;
        }
    }
}

