/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import java.io.StringReader;

class CodeAnonymiser {
    CodeAnonymiser() {
    }

    public static String anonymise(String sourceCode) {
        StringBuilder result = new StringBuilder();
        JavaLexer lexer = new JavaLexer(new StringReader(sourceCode));
        lexer.setGenerateWhitespaceTokens(true);
        int importOrPackageLine = -1;
        LocatableToken token = lexer.nextToken();
        while (token.getType() != 1) {
            switch (token.getType()) {
                case 61: 
                case 166: {
                    result.append(CodeAnonymiser.replaceWords(token.getText()));
                    break;
                }
                case 167: {
                    result.append(token.getText());
                    break;
                }
                case 62: 
                case 64: {
                    importOrPackageLine = token.getLine();
                    result.append(token.getText());
                    break;
                }
                default: {
                    if (token.getLine() == importOrPackageLine) {
                        result.append(token.getText());
                        break;
                    }
                    result.append(sourceCode.substring(token.getPosition()));
                    return result.toString();
                }
            }
            token = lexer.nextToken();
        }
        return result.toString();
    }

    private static String replaceWords(String substring) {
        int codePoint;
        StringBuilder s = new StringBuilder(substring.length());
        for (int i = 0; i < substring.length(); i += Character.charCount(codePoint)) {
            codePoint = substring.codePointAt(i);
            if (Character.isLetterOrDigit(codePoint)) {
                s.append("#");
                continue;
            }
            s.appendCodePoint(codePoint);
        }
        return s.toString();
    }
}

