/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import java.util.ArrayList;
import java.util.List;

public class History {
    protected List<String> history = null;
    protected int maxLength;
    private boolean blankAtStart;

    protected History(int maxLength, boolean blankDefault) {
        this.maxLength = maxLength;
        this.history = new ArrayList<String>(maxLength + 1);
        this.history.add("");
        this.blankAtStart = blankDefault;
    }

    protected void put(String value) {
        this.history.add(value);
    }

    public List<String> getHistory() {
        return this.history;
    }

    public void add(String newString) {
        if (newString != null && newString.length() != 0) {
            this.history.remove(newString);
            if (this.blankAtStart) {
                this.history.add(1, newString);
            } else {
                if (this.history.get(0).length() == 0) {
                    this.history.remove(0);
                }
                this.history.add(0, newString);
            }
            if (this.history.size() > this.maxLength) {
                this.history.remove(this.maxLength);
            }
        }
    }
}

