/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamViewFilter;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.StatusMessageCellRenderer;
import bluej.groupwork.ui.StatusTableModel;
import bluej.pkgmgr.Project;
import bluej.utility.EscapeDialog;
import bluej.utility.SwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class StatusFrame
extends EscapeDialog {
    private Project project;
    private JTable statusTable;
    private StatusTableModel statusModel;
    private JScrollPane statusScroller;
    private JButton refreshButton;
    private ActivityIndicator progressBar;
    private StatusMessageCellRenderer statusRenderer;
    private StatusWorker worker;
    private Repository repository;
    private static final int MAX_ENTRIES = 20;

    public StatusFrame(Project proj) {
        this.project = proj;
        this.makeWindow();
    }

    private void makeWindow() {
        this.setTitle(Config.getString("team.status.status"));
        this.statusModel = new StatusTableModel(this.project, this.estimateInitialEntries());
        this.statusTable = new JTable(this.statusModel);
        this.statusTable.getTableHeader().setReorderingAllowed(false);
        this.statusTable.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.statusTable.getColumnModel().getColumn(1).setPreferredWidth(30);
        this.statusTable.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.statusRenderer = new StatusMessageCellRenderer(this.project);
        this.statusTable.setDefaultRenderer(Object.class, this.statusRenderer);
        this.statusScroller = new JScrollPane(this.statusTable);
        this.statusScroller.setBorder(BlueJTheme.generalBorderWithStatusBar);
        Dimension prefSize = this.statusTable.getMaximumSize();
        Dimension scrollPrefSize = this.statusTable.getPreferredScrollableViewportSize();
        Dimension best = new Dimension(scrollPrefSize.width + 50, prefSize.height + 30);
        this.statusScroller.setPreferredSize(best);
        this.getContentPane().add((Component)this.statusScroller, "Center");
        this.getContentPane().add((Component)this.makeButtonPanel(), "South");
        this.pack();
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        buttonPanel.setBorder(BlueJTheme.generalBorder);
        this.progressBar = new ActivityIndicator();
        this.progressBar.setRunning(false);
        buttonPanel.add(this.progressBar);
        JButton closeButton = BlueJTheme.getCloseButton();
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (StatusFrame.this.worker != null) {
                    StatusFrame.this.worker.abort();
                }
                StatusFrame.this.setVisible(false);
            }
        });
        this.refreshButton = new JButton(Config.getString("team.status.refresh"));
        this.refreshButton.setEnabled(false);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StatusFrame.this.update();
            }
        });
        this.getRootPane().setDefaultButton(this.refreshButton);
        buttonPanel.add(this.refreshButton);
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    private int estimateInitialEntries() {
        int initialEntries = this.project.getFilesInProject(true, false).size() + 1;
        if (initialEntries > 20) {
            initialEntries = 20;
        }
        return initialEntries;
    }

    public void update() {
        this.repository = this.project.getRepository();
        if (this.repository != null) {
            this.progressBar.setRunning(true);
            this.refreshButton.setEnabled(false);
            this.worker = new StatusWorker();
            this.worker.start();
        } else {
            this.setVisible(false);
        }
    }

    class StatusWorker
    extends SwingWorker
    implements StatusListener {
        List<TeamStatusInfo> resources;
        TeamworkCommand command;
        TeamworkCommandResult result;
        boolean aborted;
        FileFilter filter;

        public StatusWorker() {
            this.filter = StatusFrame.this.project.getTeamSettingsController().getFileFilter(true);
            this.resources = new ArrayList<TeamStatusInfo>();
            this.command = StatusFrame.this.repository.getStatus(this, this.filter, true);
        }

        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public Object construct() {
            this.result = this.command.getResult();
            return this.resources;
        }

        @Override
        public void gotStatus(TeamStatusInfo info) {
            this.resources.add(info);
        }

        @Override
        public void statusComplete(StatusHandle commitHandle) {
        }

        @Override
        public void finished() {
            StatusFrame.this.progressBar.setRunning(false);
            if (!this.aborted) {
                if (this.result.isError()) {
                    TeamUtils.handleServerResponse(this.result, StatusFrame.this);
                    StatusFrame.this.setVisible(false);
                } else {
                    Collections.sort(this.resources, new Comparator<TeamStatusInfo>(){

                        @Override
                        public int compare(TeamStatusInfo arg0, TeamStatusInfo arg1) {
                            TeamStatusInfo tsi0 = arg0;
                            TeamStatusInfo tsi1 = arg1;
                            return tsi1.getStatus() - tsi0.getStatus();
                        }
                    });
                    TeamViewFilter filter = new TeamViewFilter();
                    Iterator<TeamStatusInfo> iterator = this.resources.iterator();
                    while (iterator.hasNext()) {
                        TeamStatusInfo info = iterator.next();
                        if (filter.accept(info)) continue;
                        iterator.remove();
                    }
                    StatusFrame.this.statusModel.setStatusData(this.resources);
                    HashMap<File, String> statusMap = new HashMap<File, String>();
                    for (TeamStatusInfo s : this.resources) {
                        statusMap.put(s.getFile(), TeamStatusInfo.getStatusString(s.getStatus()));
                    }
                    DataCollector.teamStatusProject(StatusFrame.this.project, StatusFrame.this.repository, statusMap);
                }
                StatusFrame.this.refreshButton.setEnabled(true);
            }
        }
    }
}

