/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.Token;
import bluej.parser.CodeSuggestions;
import bluej.parser.DocumentReader;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.ParsedNode;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class CommentNode
extends ParsedNode {
    byte type;
    private static byte SL_NORMAL = 0;
    private static byte SL_SPECIAL = 1;
    private static byte ML_NORMAL = (byte)2;
    private static byte ML_JAVADOC = (byte)3;
    private static byte ML_SPECIAL = (byte)4;
    private static byte[] colours = new byte[]{1, 3, 1, 2, 3};

    public CommentNode(ParsedNode parentNode, LocatableToken token) {
        super(parentNode);
        this.type = CommentNode.getCommentType(token);
    }

    private static byte getCommentType(LocatableToken token) {
        String text = token.getText();
        if (token.getType() == 61) {
            if (text.startsWith("/*#")) {
                return ML_SPECIAL;
            }
            if (text.startsWith("/**#")) {
                return ML_SPECIAL;
            }
            if (text.startsWith("/**")) {
                return ML_JAVADOC;
            }
            return ML_NORMAL;
        }
        if (text.startsWith("//#")) {
            return SL_SPECIAL;
        }
        return SL_NORMAL;
    }

    public boolean isJavadocComment() {
        return this.type == ML_JAVADOC;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    @Override
    public Token getMarkTokensFor(int pos, int length, int nodePos, Document document) {
        Token tok = new Token(length, colours[this.type]);
        tok.next = new Token(0, 100);
        return tok;
    }

    @Override
    protected boolean marksOwnEnd() {
        return true;
    }

    @Override
    public int textInserted(MoeSyntaxDocument document, int nodePos, int insPos, int length, NodeStructureListener listener) {
        int newSize = this.getSize() + length;
        this.resize(newSize);
        document.scheduleReparse(insPos, length);
        return 0;
    }

    @Override
    public int textRemoved(MoeSyntaxDocument document, int nodePos, int delPos, int length, NodeStructureListener listener) {
        int newSize = this.getSize() - length;
        this.resize(newSize);
        document.scheduleReparse(delPos, 0);
        return 0;
    }

    @Override
    protected int reparseNode(Document document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        int pline = document.getDefaultRootElement().getElementIndex(nodePos) + 1;
        int pcol = nodePos - document.getDefaultRootElement().getElement(pline - 1).getStartOffset() + 1;
        DocumentReader r = new DocumentReader(document, nodePos, nodePos + this.getSize());
        JavaLexer lexer = new JavaLexer(r, pline, pcol, nodePos);
        LocatableToken commentToken = lexer.nextToken();
        if (commentToken.getType() != 166 && commentToken.getType() != 61) {
            return 3;
        }
        byte newType = CommentNode.getCommentType(commentToken);
        if (this.type <= SL_SPECIAL && newType > SL_SPECIAL) {
            return 3;
        }
        if (this.type > SL_SPECIAL && newType <= SL_SPECIAL && this.getOffsetFromParent() == 0 && this.getParentNode().isCommentAttached()) {
            return 3;
        }
        this.type = newType;
        int newEnd = CommentNode.lineColToPos(document, commentToken.getEndLine(), commentToken.getEndColumn());
        int newSize = newEnd - nodePos;
        ((MoeSyntaxDocument)document).markSectionParsed(nodePos, newSize);
        if (this.getSize() != newSize) {
            this.setSize(newSize);
            return 2;
        }
        return 0;
    }

    private static int lineColToPos(Document document, int line, int col) {
        Element map = document.getDefaultRootElement();
        Element lineEl = map.getElement(line - 1);
        return lineEl.getStartOffset() + col - 1;
    }

    @Override
    public CodeSuggestions getExpressionType(int pos, Document document) {
        return null;
    }
}

