/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.JavaPrimitiveType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils15;
import bluej.utility.Utility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JavaUtils {
    private static JavaUtils jutils;
    private static final Pattern headerPattern;
    private static final Pattern paramNamePattern;
    private static final Pattern paramDescPattern;

    public static JavaUtils getJavaUtils() {
        if (jutils != null) {
            return jutils;
        }
        jutils = new JavaUtils15();
        return jutils;
    }

    public static String getSignature(Method method) {
        String name = JavaUtils.getFQTypeName(method.getReturnType()).replace('$', '.') + " " + method.getName();
        Class<?>[] params = method.getParameterTypes();
        return JavaUtils.makeSignature(name, params);
    }

    public static String getFQTypeName(Class<?> type) {
        Class<?> primtype = type;
        int dimensions = 0;
        while (primtype.isArray()) {
            ++dimensions;
            primtype = primtype.getComponentType();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(primtype.getName());
        for (int i = 0; i < dimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private static String makeSignature(String name, Class<?>[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        for (int j = 0; j < params.length; ++j) {
            String typeName = JavaUtils.getFQTypeName(params[j]).replace('$', '.');
            sb.append(typeName);
            if (j >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getSignature(Constructor<?> cons) {
        String name = JavaNames.getBase(cons.getName());
        Class<?>[] params = cons.getParameterTypes();
        return JavaUtils.makeSignature(name, params);
    }

    public static String escapeString(String s) {
        StringBuffer outBuf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\b') {
                outBuf.append("\\b");
                continue;
            }
            if (c == '\t') {
                outBuf.append("\\t");
                continue;
            }
            if (c == '\n') {
                outBuf.append("\\n");
                continue;
            }
            if (c == '\f') {
                outBuf.append("\\f");
                continue;
            }
            if (c == '\r') {
                outBuf.append("\\r");
                continue;
            }
            if (c == '\\') {
                outBuf.append("\\\\");
                continue;
            }
            if (c == '\"') {
                outBuf.append('\"');
                continue;
            }
            if (c < ' ') {
                String uescape = Integer.toHexString(c);
                uescape = "0000".substring(uescape.length()) + uescape;
                outBuf.append("\\u" + uescape);
                continue;
            }
            outBuf.append(c);
        }
        return outBuf.toString();
    }

    public abstract String getShortDesc(Method var1, String[] var2) throws ClassNotFoundException;

    public abstract String getShortDesc(Method var1, String[] var2, Map<String, GenTypeParameter> var3) throws ClassNotFoundException;

    public abstract String getLongDesc(Method var1, String[] var2) throws ClassNotFoundException;

    public abstract String getLongDesc(Method var1, String[] var2, Map<String, GenTypeParameter> var3) throws ClassNotFoundException;

    public abstract String getShortDesc(Constructor<?> var1, String[] var2) throws ClassNotFoundException;

    public abstract String getLongDesc(Constructor<?> var1, String[] var2) throws ClassNotFoundException;

    public abstract boolean isVarArgs(Constructor<?> var1);

    public abstract boolean isVarArgs(Method var1);

    public abstract boolean isSynthetic(Method var1);

    public abstract boolean isEnum(Class<?> var1);

    public abstract JavaType getReturnType(Method var1) throws ClassNotFoundException;

    public abstract JavaType getRawReturnType(Method var1);

    public abstract JavaType getFieldType(Field var1) throws ClassNotFoundException;

    public abstract JavaType getRawFieldType(Field var1);

    public abstract List<GenTypeDeclTpar> getTypeParams(Method var1);

    public abstract List<GenTypeDeclTpar> getTypeParams(Constructor<?> var1);

    public abstract List<GenTypeDeclTpar> getTypeParams(Class<?> var1);

    public abstract GenTypeClass getSuperclass(Class<?> var1) throws ClassNotFoundException;

    public abstract GenTypeClass[] getInterfaces(Class<?> var1) throws ClassNotFoundException;

    public abstract String[] getParameterTypes(Method var1) throws ClassNotFoundException;

    public abstract JavaType[] getParamGenTypes(Method var1, boolean var2) throws ClassNotFoundException;

    public abstract String[] getParameterTypes(Constructor<?> var1) throws ClassNotFoundException;

    public abstract JavaType[] getParamGenTypes(Constructor<?> var1) throws ClassNotFoundException;

    public static Map<String, GenTypeSolid> TParamsToMap(List<GenTypeDeclTpar> tparams) {
        HashMap<String, GenTypeSolid> rmap = new HashMap<String, GenTypeSolid>();
        for (GenTypeDeclTpar n : tparams) {
            rmap.put(n.getTparName(), n.getBound().mapTparsToTypes(rmap).getUpperBound().asSolid());
        }
        return rmap;
    }

    public static boolean checkMemberAccess(Reflective container, GenTypeSolid targetType, Reflective accessor, int modifiers, boolean isStatic) {
        String cpackage;
        if (isStatic && !Modifier.isStatic(modifiers)) {
            return false;
        }
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (accessor == null) {
            return false;
        }
        String accessorName = accessor.getName();
        if (!Modifier.isPrivate(modifiers) && accessorName.startsWith(cpackage = JavaNames.getPrefix(container.getName())) && accessorName.indexOf(46, cpackage.length() + 1) == -1) {
            return true;
        }
        if (accessorName.equals(container.getName())) {
            return true;
        }
        Reflective outer = accessor.getOuterClass();
        if (outer != null && JavaUtils.checkMemberAccess(container, targetType, outer, modifiers, isStatic |= accessor.isStatic())) {
            return true;
        }
        HashSet<Reflective> targetSupers = new HashSet<Reflective>();
        targetType.erasedSuperTypes(targetSupers);
        boolean allowProtected = false;
        for (Reflective ref : targetSupers) {
            if (!accessor.isAssignableFrom(ref)) continue;
            allowProtected = true;
            break;
        }
        List<Reflective> supers = accessor.getSuperTypesR();
        HashSet<String> done = new HashSet<String>();
        while (!supers.isEmpty()) {
            Reflective r = supers.remove(0);
            if (!done.add(r.getName())) continue;
            if (r.getName().equals(container.getName())) {
                if (!Modifier.isProtected(modifiers)) continue;
                return allowProtected;
            }
            for (Reflective rParent : r.getSuperTypesR()) {
                supers.add(rParent);
            }
        }
        return false;
    }

    protected static String makeDescription(String name, String[] paramTypes, String[] paramNames, boolean includeTypeNames, boolean isVarArgs) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        for (int j = 0; j < paramTypes.length; ++j) {
            boolean typePrinted = false;
            if (isVarArgs && j == paramTypes.length - 1) {
                if (includeTypeNames || paramNames == null || paramNames[j] == null) {
                    sb.append(paramTypes[j].substring(0, paramTypes[j].length() - 2));
                    sb.append(" ");
                }
                sb.append("...");
                typePrinted = true;
            } else if (includeTypeNames || paramNames == null || paramNames[j] == null) {
                sb.append(paramTypes[j]);
                typePrinted = true;
            }
            if (paramNames != null && paramNames[j] != null) {
                if (typePrinted) {
                    sb.append(" ");
                }
                sb.append(paramNames[j]);
            }
            if (j >= paramTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String javadocToString(String javadoc) {
        String eol = System.getProperty("line.separator");
        if (javadoc == null || javadoc.length() < 5) {
            return null;
        }
        StringBuffer outbuf = new StringBuffer();
        String str = javadoc;
        if (javadoc.charAt(0) == '/' && javadoc.charAt(1) == '*') {
            str = javadoc.charAt(2) == '*' ? javadoc.substring(3, javadoc.length() - 2) : javadoc.substring(2, javadoc.length() - 2);
        }
        int nl = str.indexOf(10);
        int cr = str.indexOf(13);
        int pos = 0;
        while (nl != -1 || cr != -1) {
            int lineEnd = Math.min(nl, cr);
            lineEnd = nl == -1 ? cr : lineEnd;
            lineEnd = cr == -1 ? nl : lineEnd;
            String line = str.substring(pos, lineEnd);
            line = JavaUtils.stripLeadingStars(line);
            outbuf.append(line);
            outbuf.append(eol);
            pos = lineEnd + 1;
            if (pos == nl) {
                ++pos;
            }
            nl = str.indexOf(10, pos);
            cr = str.indexOf(13, pos);
        }
        String line = JavaUtils.stripLeadingStars(str.substring(pos)).trim();
        if (line.length() > 0) {
            outbuf.append(line);
        }
        return outbuf.toString();
    }

    private static String stripLeadingStars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '*') {
                while (++i < s.length() && s.charAt(i) == '*') {
                }
                s = s.substring(i);
                break;
            }
            if (!Character.isWhitespace(s.charAt(i))) break;
        }
        return s;
    }

    public static JavaType genTypeFromClass(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE) {
                return JavaPrimitiveType.getBoolean();
            }
            if (c == Character.TYPE) {
                return JavaPrimitiveType.getChar();
            }
            if (c == Byte.TYPE) {
                return JavaPrimitiveType.getByte();
            }
            if (c == Short.TYPE) {
                return JavaPrimitiveType.getShort();
            }
            if (c == Integer.TYPE) {
                return JavaPrimitiveType.getInt();
            }
            if (c == Long.TYPE) {
                return JavaPrimitiveType.getLong();
            }
            if (c == Float.TYPE) {
                return JavaPrimitiveType.getFloat();
            }
            if (c == Double.TYPE) {
                return JavaPrimitiveType.getDouble();
            }
            if (c == Void.TYPE) {
                return JavaPrimitiveType.getVoid();
            }
            Debug.message("getReturnType: Unknown primitive type");
        }
        if (c.isArray()) {
            JavaType componentT = JavaUtils.genTypeFromClass(c.getComponentType());
            return componentT.getArray();
        }
        return new GenTypeClass(new JavaReflective(c));
    }

    public static String javadocToHtml(String javadocString) {
        Matcher matcher = headerPattern.matcher(javadocString);
        int i = -1;
        if (matcher.find()) {
            i = matcher.start();
        }
        if (i == -1) {
            return JavaUtils.makeCommentColour(javadocString);
        }
        String header = javadocString.substring(0, i);
        String blocksText = javadocString.substring(i);
        String[] lines = Utility.splitLines(blocksText);
        List<String> blocks = JavaUtils.getBlockTags(lines);
        StringBuilder rest = new StringBuilder();
        StringBuilder params = new StringBuilder();
        params.append("<h3>Parameters</h3>").append("<table border=0>");
        boolean hasParamDoc = false;
        for (String block : blocks) {
            matcher = paramNamePattern.matcher(block);
            String paramName = "";
            String paramDesc = "";
            if (matcher.find()) {
                int p = matcher.end() - 1;
                if ((matcher = paramDescPattern.matcher(block.substring(p))).find()) {
                    int k = p + matcher.end() - 1;
                    paramName = block.substring(p, k);
                    paramDesc = block.substring(k);
                }
                params.append("<tr><td valign=\"top\">&nbsp;&nbsp;&nbsp;");
                params.append(JavaUtils.makeCommentColour(paramName));
                params.append("</td><td>");
                params.append(JavaUtils.makeCommentColour(" - " + paramDesc));
                params.append("</td></tr>");
                hasParamDoc = true;
                continue;
            }
            rest.append(JavaUtils.convertBlockTag(block)).append("<br>");
        }
        params.append("</table><p>");
        StringBuilder result = new StringBuilder(JavaUtils.makeCommentColour(header));
        result.append(hasParamDoc ? params.toString() : "<p>").append(rest.toString());
        return result.toString();
    }

    private static String makeCommentColour(String text) {
        return "<font color='#994400'>" + text + "</font>";
    }

    private static List<String> getBlockTags(String[] lines) {
        LinkedList<String> blocks = new LinkedList<String>();
        StringBuilder cur = new StringBuilder();
        for (String line : lines) {
            if ((line = line.trim()).startsWith("@")) {
                if (cur.length() > 0) {
                    blocks.addLast(cur.toString());
                }
                cur = new StringBuilder(line.substring(1));
                continue;
            }
            cur.append(" ").append(line);
        }
        blocks.addLast(cur.toString());
        return blocks;
    }

    private static String convertBlockTag(String block) {
        int k = block.indexOf(32);
        String r = "<b>" + block.substring(0, k) + "</b> - " + JavaUtils.makeCommentColour(block.substring(k));
        return r;
    }

    public static String escapeAngleBrackets(String sig) {
        return sig.replace("<", "&lt;").replace(">", "&gt;");
    }

    static {
        headerPattern = Pattern.compile("{1,}\\s@\\w");
        paramNamePattern = Pattern.compile("param\\s+\\w");
        paramDescPattern = Pattern.compile("\\s+\\w");
    }
}

