/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJLabel;
import bluej.GreenfootLabel;
import bluej.SplashLabel;
import bluej.SplashWindow;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;

public class Boot {
    public static final int BLUEJ_VERSION_MAJOR = 3;
    public static final int BLUEJ_VERSION_MINOR = 1;
    public static final int BLUEJ_VERSION_RELEASE = 7;
    public static final String BLUEJ_VERSION_SUFFIX = "";
    public static final String BLUEJ_VERSION = "3.1.7";
    public static final String BLUEJ_VERSION_TITLE = "BlueJ 3.1.7";
    public static String GREENFOOT_VERSION = "2.4.1";
    public static String GREENFOOT_API_VERSION = "2.7.0";
    private static Boot instance;
    private static String[] bluejJars;
    private static final int bluejBuildJars = 3;
    private static final String[] bluejUserJars;
    private static final int bluejUserBuildJars = 1;
    private static final String JLAYER_MP3_JAR = "jl1.0.1.jar";
    private static final String[] greenfootUserJars;
    public static final String[] GREENFOOT_EXPORT_JARS;
    private static final int greenfootUserBuildJars = 4;
    private static String[] runtimeJars;
    private static String[] userJars;
    private static int numBuildJars;
    private static int numUserBuildJars;
    private static boolean isGreenfoot;
    private static File bluejLibDir;
    private SplashWindow splashWindow;
    private Properties commandLineProps;
    private String[] args;
    private File javaHomeDir;
    private ClassLoader bootLoader;
    private URL[] runtimeUserClassPath;
    private URL[] runtimeClassPath;

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1 && "-version".equals(stringArray[0])) {
            System.out.println("BlueJ version 3.1.7 (Java version " + System.getProperty("java.version") + ")");
            System.out.println("--");
            System.out.println("virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            System.out.println("running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
            System.exit(-1);
        }
        Properties properties = Boot.processCommandLineProperties(stringArray);
        isGreenfoot = properties.getProperty("greenfoot", "false").equals("true");
        SplashLabel splashLabel = null;
        if (isGreenfoot) {
            splashLabel = new GreenfootLabel();
            runtimeJars = greenfootUserJars;
            userJars = greenfootUserJars;
            numBuildJars = 4;
            numUserBuildJars = 4;
        } else {
            splashLabel = new BlueJLabel();
        }
        try {
            instance = new Boot(stringArray, properties, splashLabel);
            instance.bootBluej();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
        Boot boot = instance;
        synchronized (boot) {
            while (true) {
                try {
                    while (true) {
                        instance.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static Boot getInstance() {
        return instance;
    }

    private Boot(String[] stringArray, Properties properties, final SplashLabel splashLabel) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Boot.this.splashWindow = new SplashWindow(splashLabel);
                    Boot.this.splashWindow.repaint();
                }
            });
            this.splashWindow.waitUntilPainted();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.args = stringArray;
        this.commandLineProps = properties;
    }

    public void disposeSplashWindow() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
            this.splashWindow = null;
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean isGreenfoot() {
        return isGreenfoot;
    }

    public File getJavaHome() {
        return this.javaHomeDir;
    }

    public static File getBluejLibDir() {
        if (bluejLibDir == null) {
            bluejLibDir = Boot.calculateBluejLibDir();
        }
        return bluejLibDir;
    }

    public URL[] getRuntimeClassPath() {
        return this.runtimeClassPath;
    }

    public URL[] getRuntimeUserClassPath() {
        return this.runtimeUserClassPath;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootLoader;
    }

    private void bootBluej() {
        this.initializeBoot();
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(this.runtimeClassPath, this.bootLoader);
            Class<?> clazz = Class.forName("bluej.Main", true, uRLClassLoader);
            clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void initializeBoot() {
        this.bootLoader = this.getClass().getClassLoader();
        this.javaHomeDir = new File(System.getProperty("java.home"));
        try {
            this.runtimeClassPath = this.getKnownJars(Boot.getBluejLibDir(), runtimeJars, true, numBuildJars);
            this.runtimeUserClassPath = this.getKnownJars(Boot.getBluejLibDir(), userJars, false, numUserBuildJars);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static File calculateBluejLibDir() {
        File file = null;
        String string = Boot.class.getResource("Boot.class").toString();
        try {
            if (!string.startsWith("jar:")) {
                File file2;
                for (file2 = new File(new URI(string)).getParentFile(); file2 != null && !new File(file2.getParentFile(), "lib").isDirectory(); file2 = file2.getParentFile()) {
                }
                file = file2 == null ? null : new File(file2.getParentFile(), "lib");
            } else {
                int n = string.indexOf("!");
                String string2 = string.substring(4, n);
                File file3 = new File(new URI(string2));
                file = file3.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return file;
    }

    private URL[] getKnownJars(File file, String[] stringArray, boolean bl, int n) throws MalformedURLException {
        URL uRL;
        Object object;
        File file2;
        boolean bl2 = this.commandLineProps.getProperty("useclassesdir", "false").equals("true");
        int n2 = 0;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (n != 0 && bl2 && (file2 = new File(file.getParentFile(), "classes")).isDirectory()) {
            arrayList.add(file2.toURI().toURL());
            if (isGreenfoot && (object = this.commandLineProps.getProperty("greenfootclassesdir")) != null) {
                file2 = new File((String)object);
                arrayList.add(file2.toURI().toURL());
            }
            n2 = n;
        }
        for (int i = n2; i < stringArray.length; ++i) {
            object = new File(file, stringArray[i]);
            if (!((File)object).canRead()) continue;
            arrayList.add(((File)object).toURI().toURL());
        }
        if (bl && (uRL = this.getToolsURL()) != null) {
            arrayList.add(uRL);
        }
        return arrayList.toArray(new URL[0]);
    }

    private URL getToolsURL() throws MalformedURLException {
        String string = System.getProperty("os.name", BLUEJ_VERSION_SUFFIX);
        if (string.startsWith("Mac")) {
            return null;
        }
        File file = new File(this.javaHomeDir, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        File file2 = this.javaHomeDir.getParentFile();
        file = new File(file2, "lib/tools.jar");
        if (file.canRead()) {
            return file.toURI().toURL();
        }
        System.err.println("class Boot: tools.jar not found. Potential problem for execution.  (Java Home: " + this.javaHomeDir.getAbsolutePath() + ")");
        return null;
    }

    private static Properties processCommandLineProperties(String[] stringArray) {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            if (!stringArray[i].startsWith("-") || (n = (string = stringArray[i].substring(1)).indexOf(61)) < 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equals(BLUEJ_VERSION_SUFFIX) || string3.equals(BLUEJ_VERSION_SUFFIX)) continue;
            properties.put(string2, string3);
        }
        return properties;
    }

    public Properties getCommandLineProperties() {
        return this.commandLineProps;
    }

    static {
        bluejJars = new String[]{"bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "AppleJavaExtensions.jar", "org-netbeans-lib-cvsclient.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar", "commons-logging-api-1.1.2.jar", "diffutils-1.2.1.jar", "svnkit-javahl.jar", "svnkit.jar", "trilead.jar", "antlr-runtime-3.4.jar", "sequence-library-1.0.3.jar", "sqljet-1.1.10.jar"};
        bluejUserJars = new String[]{"bluejcore.jar", "junit-4.8.2.jar"};
        greenfootUserJars = new String[]{"extensions" + File.separatorChar + "greenfoot.jar", "bluejcore.jar", "bluejeditor.jar", "bluejext.jar", "AppleJavaExtensions.jar", "junit-4.8.2.jar", "bluej.jar", "diffutils-1.2.1.jar", "commons-httpclient-3.1.jar", "commons-logging-api-1.1.2.jar", "commons-codec-1.3.jar", JLAYER_MP3_JAR, "opencsv-2.3.jar", "httpclient-4.1.1.jar", "httpcore-4.1.jar", "httpmime-4.1.1.jar"};
        GREENFOOT_EXPORT_JARS = new String[]{JLAYER_MP3_JAR};
        runtimeJars = bluejJars;
        userJars = bluejUserJars;
        numBuildJars = 3;
        numUserBuildJars = 1;
        isGreenfoot = false;
    }
}

