/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.Actor;
import greenfoot.ActorSet;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TreeActorSet
extends AbstractSet<Actor> {
    private List<ActorSet> subSets = new LinkedList<ActorSet>();
    private ActorSet generalSet = new ActorSet();
    private HashMap<Class<?>, ActorSet> classSets;

    public TreeActorSet() {
        this.subSets.add(this.generalSet);
        this.classSets = new HashMap();
    }

    public void setClassOrder(boolean reverse, Class<?> ... classes) {
        HashMap<Class<?>, ActorSet> oldClassSets = this.classSets;
        this.classSets = new HashMap();
        LinkedList sweepClasses = new LinkedList();
        int i = 0;
        while (i < classes.length) {
            ActorSet oldSet = oldClassSets.remove(classes[i]);
            if (oldSet == null) {
                sweepClasses.add(classes[i]);
                oldSet = new ActorSet();
            }
            this.classSets.put(classes[i], oldSet);
            ++i;
        }
        HashSet sweptClasses = new HashSet();
        while (!sweepClasses.isEmpty()) {
            Class sweepClass = ((Class)sweepClasses.removeFirst()).getSuperclass();
            ActorSet sweepSet = this.classSets.get(sweepClass);
            while (sweepSet == null) {
                sweepSet = (sweepClass = sweepClass.getSuperclass()) == null ? this.generalSet : this.classSets.get(sweepClass);
            }
            if (sweptClasses.contains(sweepClass)) continue;
            sweptClasses.add(sweepClass);
            Iterator<Actor> i2 = sweepSet.iterator();
            while (i2.hasNext()) {
                Actor actor = i2.next();
                ActorSet set = this.setForActor(actor);
                if (set == sweepSet) continue;
                set.add(actor);
                i2.remove();
            }
        }
        for (Map.Entry<Class<?>, ActorSet> entry : oldClassSets.entrySet()) {
            ActorSet destinationSet = this.setForClass(entry.getKey());
            destinationSet.addAll(entry.getValue());
        }
        this.subSets.clear();
        if (reverse) {
            this.subSets.add(this.generalSet);
            int i3 = classes.length;
            while (i3 > 0) {
                this.subSets.add(this.classSets.get(classes[--i3]));
            }
        } else {
            int i4 = 0;
            while (i4 < classes.length) {
                this.subSets.add(this.classSets.get(classes[i4]));
                ++i4;
            }
            this.subSets.add(this.generalSet);
        }
    }

    @Override
    public Iterator<Actor> iterator() {
        return new TasIterator();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<ActorSet> i = this.subSets.iterator();
        while (i.hasNext()) {
            size += i.next().size();
        }
        return size;
    }

    @Override
    public boolean add(Actor o) {
        if (o == null) {
            throw new UnsupportedOperationException("Cannot add null actor.");
        }
        return this.setForActor(o).add(o);
    }

    public boolean remove(Actor o) {
        return this.setForActor(o).remove(o);
    }

    public boolean contains(Actor o) {
        return this.setForActor(o).contains(o);
    }

    private ActorSet setForActor(Actor o) {
        Class<?> oClass = o.getClass();
        return this.setForClass(oClass);
    }

    private ActorSet setForClass(Class<?> oClass) {
        ActorSet set = this.classSets.get(oClass);
        while (set == null && oClass != Object.class) {
            oClass = oClass.getSuperclass();
            set = this.classSets.get(oClass);
        }
        if (set == null) {
            set = this.generalSet;
        }
        return set;
    }

    class TasIterator
    implements Iterator<Actor> {
        private Iterator<ActorSet> setIterator;
        private ActorSet currentSet;
        private Iterator<Actor> actorIterator;

        public TasIterator() {
            this.setIterator = TreeActorSet.this.subSets.iterator();
            this.currentSet = this.setIterator.next();
            while (this.currentSet.isEmpty() && this.setIterator.hasNext()) {
                this.currentSet = this.setIterator.next();
            }
            this.actorIterator = this.currentSet.iterator();
        }

        @Override
        public void remove() {
            this.actorIterator.remove();
        }

        @Override
        public Actor next() {
            this.hasNext();
            return this.actorIterator.next();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.actorIterator.hasNext()) {
                return true;
            }
            if (this.setIterator.hasNext()) ** GOTO lbl7
            return false;
lbl-1000:
            // 1 sources

            {
                this.currentSet = this.setIterator.next();
                if (!this.currentSet.isEmpty()) break;
lbl7:
                // 2 sources

                ** while (this.setIterator.hasNext())
            }
lbl8:
            // 2 sources

            this.actorIterator = this.currentSet.iterator();
            return this.actorIterator.hasNext();
        }
    }
}

