/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.collision;

import greenfoot.TestObject;
import greenfoot.TestUtilDelegate;
import greenfoot.World;
import greenfoot.WorldCreator;
import greenfoot.core.WorldHandler;
import greenfoot.util.GreenfootUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;

public class NeighbourTest
extends TestCase {
    private World world;

    protected void setUp() throws Exception {
        GreenfootUtil.initialise(new TestUtilDelegate());
    }

    public void testNoWrapDiagonal() {
        int d = 2;
        this.world = WorldCreator.createWorld(10, 10, 10);
        WorldHandler.initialise();
        WorldHandler.getInstance().setWorld(this.world);
        int xStart = 9;
        int yStart = 9;
        TestObject me = new TestObject();
        this.world.addObject(me, xStart, yStart);
        Collection neighbours = this.createNeigboursWithDiagonal(xStart, yStart, d);
        List c = me.getNeighboursP(d, true, TestObject.class);
        NeighbourTest.assertEquals((int)8, (int)c.size());
        NeighbourTest.assertTrue((boolean)c.containsAll(neighbours));
        this.world = WorldCreator.createWorld(10, 10, 10);
        xStart = 0;
        yStart = 0;
        this.world.addObject(me, xStart, yStart);
        neighbours = this.createNeigboursWithDiagonal(xStart, yStart, d);
        c = me.getNeighboursP(d, true, TestObject.class);
        NeighbourTest.assertEquals((int)8, (int)c.size());
        NeighbourTest.assertTrue((boolean)c.containsAll(neighbours));
    }

    private Collection createNeigboursWithDiagonal(int xStart, int yStart, int d) {
        int x = 0;
        while (x < this.world.getWidth()) {
            int y = 0;
            while (y < this.world.getHeight()) {
                TestObject actor = new TestObject();
                this.world.addObject(actor, x, y);
                ++y;
            }
            ++x;
        }
        ArrayList<TestObject> neighbours = new ArrayList<TestObject>();
        int x2 = xStart - d;
        while (x2 <= xStart + d) {
            int y = yStart - d;
            while (y <= yStart + d) {
                if (x2 >= 0 && y >= 0 && x2 < this.world.getWidth() && y < this.world.getHeight()) {
                    List remove = this.world.getObjectsAt(x2, y, TestObject.class);
                    for (TestObject element : remove) {
                        if (x2 == xStart && y == yStart) continue;
                        neighbours.add(element);
                    }
                }
                ++y;
            }
            ++x2;
        }
        return neighbours;
    }
}

