/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.extensions.ProjectNotOpenException;
import bluej.utility.Debug;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GreenfootMain;
import greenfoot.core.InternalGreenfootError;
import greenfoot.core.ProjectProperties;
import greenfoot.event.CompileListener;
import java.io.File;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.RProject;
import rmiextension.wrappers.event.RCompileEvent;
import rmiextension.wrappers.event.RProjectListenerImpl;

public class GProject
extends RProjectListenerImpl
implements CompileListener {
    private Map<RPackage, GPackage> packagePool = new HashMap<RPackage, GPackage>();
    private RProject rProject;
    private ProjectProperties projectProperties;
    private List<CompileListener> compileListeners = new LinkedList<CompileListener>();

    public static GProject newGProject(RProject rmiProject) {
        try {
            return new GProject(rmiProject);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Error constructing Greenfoot Project", (Throwable)re);
            throw new InternalGreenfootError(re);
        }
    }

    private GProject(RProject rmiProject) throws RemoteException {
        this.rProject = rmiProject;
        try {
            rmiProject.addListener(this);
            this.projectProperties = new ProjectProperties(this.getDir());
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Could not instantiate Greenfoot project", (Throwable)re);
            throw new InternalGreenfootError(re);
        }
    }

    public void close() throws RemoteException {
        this.rProject.close();
    }

    public void save() throws ProjectNotOpenException, RemoteException {
        this.rProject.save();
    }

    public GPackage getDefaultPackage() {
        return this.getPackage("");
    }

    public GPackage getPackage(String packageName) {
        RPackage rPkg;
        block4: {
            rPkg = this.rProject.getPackage(packageName);
            if (rPkg != null) break block4;
            return null;
        }
        try {
            return this.getPackage(rPkg);
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Error retrieving remote package", (Throwable)pnoe);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Error retrieving remote package", (Throwable)re);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GPackage getPackage(RPackage pkg) {
        Map<RPackage, GPackage> map = this.packagePool;
        synchronized (map) {
            GPackage ret = this.packagePool.get(pkg);
            if (ret == null) {
                ret = new GPackage(pkg, this);
                this.packagePool.put(pkg, ret);
            }
            return ret;
        }
    }

    public File getDir() {
        try {
            return this.rProject.getDir();
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Couldn't get project directory", (Throwable)pnoe);
            throw new InternalGreenfootError(pnoe);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Couldn't get project directory", (Throwable)re);
            throw new InternalGreenfootError(re);
        }
    }

    public String getName() {
        try {
            return this.rProject.getName();
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Getting project name", (Throwable)pnoe);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Getting project name", (Throwable)re);
        }
        return null;
    }

    public ProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    public void openReadme() {
        try {
            this.rProject.openReadmeEditor();
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Opening Readme", (Throwable)re);
            throw new InternalGreenfootError(re);
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Opening Readme", (Throwable)pnoe);
            throw new InternalGreenfootError(pnoe);
        }
    }

    public RProject getRProject() {
        return this.rProject;
    }

    @Override
    public void projectClosing() {
        GreenfootMain.getInstance().projectClosing();
    }

    public String getCharsetName() {
        String charsetName = this.projectProperties.getString("project.charset");
        if (charsetName == null) {
            charsetName = Charset.defaultCharset().name();
        }
        return charsetName;
    }

    public String getLastWorldClassName() {
        return this.projectProperties.getString("world.lastInstantiated");
    }

    public void setLastWorldClassName(String name) {
        this.projectProperties.setString("world.lastInstantiated", name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCompiled() {
        try {
            GClass[] classes = this.getDefaultPackage().getClasses(false);
            int i = 0;
            while (true) {
                if (i >= classes.length) {
                    return true;
                }
                GClass cls = classes[i];
                if (!cls.isCompiled()) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Debug.reportError((String)"Checking class compiled state", (Throwable)e);
            throw new InternalGreenfootError(e);
        }
    }

    public void closeEditors() {
        try {
            GClass[] classes = this.getDefaultPackage().getClasses(false);
            int i = 0;
            while (i < classes.length) {
                GClass cls = classes[i];
                cls.closeEditor();
                ++i;
            }
        }
        catch (Exception e) {
            Debug.reportError((String)"Closing all editors", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompileListener(CompileListener listener) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            this.compileListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompileListener(CompileListener listener) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            this.compileListeners.remove(listener);
        }
    }

    @Override
    public void compileError(RCompileEvent event) {
        this.delegateCompileEvent(event);
    }

    @Override
    public void compileFailed(RCompileEvent event) {
        this.reloadClasses();
        this.delegateCompileEvent(event);
    }

    @Override
    public void compileStarted(RCompileEvent event) {
        this.delegateCompileEvent(event);
    }

    @Override
    public void compileSucceeded(RCompileEvent event) {
        this.reloadClasses();
        this.delegateCompileEvent(event);
    }

    @Override
    public void compileWarning(RCompileEvent event) {
        this.delegateCompileEvent(event);
    }

    private void reloadClasses() {
        GClass[] classes;
        GPackage pkg = this.getDefaultPackage();
        GClass[] gClassArray = classes = pkg.getClasses(true);
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            GClass cls = gClassArray[n2];
            cls.reload();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegateCompileEvent(RCompileEvent event) {
        List<CompileListener> list = this.compileListeners;
        synchronized (list) {
            ArrayList<CompileListener> listeners = new ArrayList<CompileListener>(this.compileListeners);
            for (CompileListener listener : listeners) {
                try {
                    switch (event.getEvent()) {
                        case 1: {
                            listener.compileStarted(event);
                            break;
                        }
                        case 4: {
                            listener.compileSucceeded(event);
                            break;
                        }
                        case 5: {
                            listener.compileFailed(event);
                            break;
                        }
                        case 3: {
                            listener.compileError(event);
                            break;
                        }
                        case 2: {
                            listener.compileWarning(event);
                        }
                    }
                }
                catch (RemoteException re) {
                    Debug.reportError((String)"Determining compilation event type", (Throwable)re);
                }
            }
        }
    }

    public File getImageDir() {
        File projDir = this.getDir().getAbsoluteFile();
        File projImagesDir = new File(projDir, "images");
        projImagesDir.mkdir();
        return projImagesDir;
    }

    public File getSoundDir() {
        File projDir = this.getDir().getAbsoluteFile();
        File projSoundsDir = new File(projDir, "sounds");
        projSoundsDir.mkdir();
        return projSoundsDir;
    }

    public void toggleExecControls() {
        try {
            this.rProject.toggleExecControls();
        }
        catch (RemoteException ex) {
            Debug.reportError((String)"RemoteException showing debugger", (Throwable)ex);
        }
    }

    public boolean isExecControlVisible() {
        try {
            return this.rProject.isExecControlVisible();
        }
        catch (RemoteException ex) {
            Debug.reportError((String)"RemoteException checking ExecControl state", (Throwable)ex);
        }
        catch (ProjectNotOpenException ex) {
            Debug.reportError((String)"ProjectNotOpenException checking ExecControl state", (Throwable)ex);
        }
        return false;
    }
}

