/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.InvokerCompiler;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import greenfoot.Actor;
import greenfoot.ObjectTracker;
import greenfoot.World;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.ImageCache;
import greenfoot.core.WorldHandler;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.localdebugger.LocalDebugger;
import greenfoot.localdebugger.LocalObject;
import greenfoot.record.InteractionListener;
import java.awt.event.MouseEvent;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import rmiextension.wrappers.RObject;

public class WorldInvokeListener
implements InvokeListener {
    private Object obj;
    private RObject rObj;
    private Class<?> cl;
    private InspectorManager inspectorManager;
    private ObjectBenchInterface objectBench;
    private GProject project;
    private JFrame frame;
    private InteractionListener interactionListener;

    public WorldInvokeListener(JFrame frame, Object obj, ObjectBenchInterface bench, InspectorManager inspectorManager, InteractionListener interactionListener, GProject project) {
        this.objectBench = bench;
        this.obj = obj;
        this.inspectorManager = inspectorManager;
        this.interactionListener = interactionListener;
        this.project = project;
        this.frame = frame;
    }

    public WorldInvokeListener(JFrame frame, Class<?> cl, ObjectBenchInterface bench, InspectorManager inspectorManager, InteractionListener interactionListener, GProject project) {
        this.objectBench = bench;
        this.cl = cl;
        this.project = project;
        this.inspectorManager = inspectorManager;
        this.interactionListener = interactionListener;
        this.frame = frame;
    }

    private Invoker getInvokerInstance(final CallableView callable) {
        if (this.obj != null) {
            try {
                this.rObj = ObjectTracker.getRObject(this.obj);
            }
            catch (RemoteException e) {
                Debug.reportError((String)"Error getting remote object", (Throwable)e);
                return null;
            }
        }
        ValueCollection objectBenchVars = ObjectTracker.getObjects();
        LocalDebugger debugger = new LocalDebugger();
        CallHistory ch = GreenfootMain.getInstance().getCallHistory();
        final MouseEvent event = LocationTracker.instance().getMouseButtonEvent();
        try {
            Charset cs;
            final String instanceName = this.rObj != null ? this.rObj.getInstanceName() : this.cl.getName();
            ResultWatcher watcher = new ResultWatcher(){

                public void beginCompile() {
                }

                public void beginExecution(InvokerRecord ir) {
                    WorldInvokeListener.this.interactionListener.beginCallExecution(callable);
                    WorldHandler.getInstance().clearWorldSet();
                }

                public void putError(String message, InvokerRecord ir) {
                }

                public void putException(ExceptionDescription exception, InvokerRecord ir) {
                }

                public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                    JavaType[] paramTypes = callable.getParamTypes(false);
                    if (result instanceof LocalObject) {
                        Object o = ((LocalObject)result).getObject();
                        if (callable instanceof MethodView) {
                            MethodView mv = (MethodView)callable;
                            if (!mv.isVoid()) {
                                ExpressionInformation ei = new ExpressionInformation((MethodView)callable, instanceName);
                                ei.setArgumentValues(ir.getArgumentValues());
                                ResultInspector ri = WorldInvokeListener.this.inspectorManager.getResultInspectorInstance(result, instanceName, null, null, ei, (JFrame)GreenfootMain.getInstance().getFrame());
                                ri.setVisible(true);
                            }
                        } else {
                            WorldHandler worldHandler = WorldHandler.getInstance();
                            if (o instanceof Actor) {
                                WorldInvokeListener.this.interactionListener.createdActor(o, ir.getArgumentValues(), paramTypes);
                                worldHandler.addObjectAtEvent((Actor)o, event);
                                worldHandler.repaint();
                            } else if (o instanceof World) {
                                WorldInvokeListener.this.interactionListener.worldConstructed(o);
                                if (!worldHandler.checkWorldSet()) {
                                    ImageCache.getInstance().clearImageCache();
                                    worldHandler.setWorld((World)o);
                                }
                            } else {
                                WorldInvokeListener.this.inspectorManager.getInspectorInstance(result, "result", null, null, (JFrame)GreenfootMain.getInstance().getFrame());
                            }
                        }
                    }
                    WorldInvokeListener.this.update();
                    if (callable instanceof MethodView) {
                        MethodView m = (MethodView)callable;
                        WorldInvokeListener.this.interactionListener.methodCall(WorldInvokeListener.this.obj, instanceName, m.getMethod(), ir.getArgumentValues(), paramTypes);
                    }
                }

                public void putVMTerminated(InvokerRecord ir) {
                }
            };
            InvokerCompiler compiler = this.project.getDefaultPackage().getCompiler();
            String csName = this.project.getProjectProperties().getString("project.charset");
            if (csName == null) {
                csName = "UTF-8";
            }
            try {
                cs = Charset.forName(csName);
            }
            catch (IllegalCharsetNameException icsne) {
                cs = Charset.forName("UTF-8");
            }
            return new Invoker(this.frame, callable, watcher, this.project.getDir(), "", this.project.getDir().getPath(), ch, objectBenchVars, this.objectBench, (Debugger)debugger, compiler, instanceName, cs);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Error getting invoker instance", (Throwable)re);
            return null;
        }
    }

    public void executeMethod(MethodView mv) {
        Invoker invoker = this.getInvokerInstance((CallableView)mv);
        invoker.invokeInteractive();
    }

    public void callConstructor(ConstructorView cv) {
        Invoker invoker = this.getInvokerInstance((CallableView)cv);
        invoker.invokeInteractive();
    }

    private void update() {
        WorldHandler worldHandler = WorldHandler.getInstance();
        if (worldHandler != null) {
            worldHandler.repaint();
        }
    }
}

