/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import bluej.Config;
import greenfoot.event.PublishEvent;
import greenfoot.event.PublishListener;
import greenfoot.export.mygame.ProgressTrackingPart;
import greenfoot.export.mygame.ScenarioInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MyGameClient {
    private PublishListener listener;

    public MyGameClient(PublishListener listener) {
        this.listener = listener;
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
    }

    public final MyGameClient submit(String hostAddress, String uid, String password, String jarFileName, File sourceFile, File screenshotFile, int width, int height, ScenarioInfo info) throws UnknownHostException, IOException {
        String[] authDetails;
        String gameName = info.getTitle();
        String shortDescription = info.getShortDescription();
        String longDescription = info.getLongDescription();
        String updateDescription = info.getUpdateDescription();
        String gameUrl = info.getUrl();
        HttpClient httpClient = this.getHttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(20000);
        PostMethod postMethod = new PostMethod(String.valueOf(hostAddress) + "account/authenticate");
        postMethod.addParameter("user[username]", uid);
        postMethod.addParameter("user[password]", password);
        int response = httpClient.executeMethod((HttpMethod)postMethod);
        if (response == 407 && this.listener != null && (authDetails = this.listener.needProxyAuth()) != null) {
            String proxyHost = httpClient.getHostConfiguration().getProxyHost();
            int proxyPort = httpClient.getHostConfiguration().getProxyPort();
            AuthScope authScope = new AuthScope(proxyHost, proxyPort);
            UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(authDetails[0], authDetails[1]);
            httpClient.getState().setProxyCredentials(authScope, (Credentials)proxyCreds);
            response = httpClient.executeMethod((HttpMethod)postMethod);
        }
        if (response > 400) {
            this.error(String.valueOf(Config.getString((String)"export.publish.errorResponse")) + " - " + response);
            return this;
        }
        if (!this.handleResponse(postMethod)) {
            return this;
        }
        List<String> tagsList = info.getTags();
        boolean hasSource = sourceFile != null;
        HashMap<String, String> partsMap = new HashMap<String, String>();
        if (info.isUpdate()) {
            partsMap.put("scenario[update_description]", updateDescription);
        } else {
            partsMap.put("scenario[long_description]", longDescription);
            partsMap.put("scenario[short_description]", shortDescription);
        }
        int size = partsMap.size();
        if (screenshotFile != null) {
            ++size;
        }
        int counter = 6;
        Part[] parts = new Part[counter + size + tagsList.size() + (hasSource ? 1 : 0)];
        parts[0] = new StringPart("scenario[title]", gameName, "UTF-8");
        parts[1] = new StringPart("scenario[main_class]", "greenfoot.export.GreenfootScenarioViewer", "UTF-8");
        parts[2] = new StringPart("scenario[width]", "" + width, "UTF-8");
        parts[3] = new StringPart("scenario[height]", "" + height, "UTF-8");
        parts[4] = new StringPart("scenario[url]", gameUrl, "UTF-8");
        parts[5] = new ProgressTrackingPart("scenario[uploaded_data]", new File(jarFileName), this);
        Iterator mapIterator = partsMap.keySet().iterator();
        String key = "";
        String obj = "";
        while (mapIterator.hasNext()) {
            key = ((String)mapIterator.next()).toString();
            obj = ((String)partsMap.get(key)).toString();
            parts[counter] = new StringPart(key, obj, "UTF-8");
            ++counter;
        }
        if (hasSource) {
            parts[counter] = new ProgressTrackingPart("scenario[source_data]", sourceFile, this);
            ++counter;
        }
        if (screenshotFile != null) {
            parts[counter] = new ProgressTrackingPart("scenario[screenshot_data]", screenshotFile, this);
            ++counter;
        }
        int tagNum = 0;
        Iterator<String> i = tagsList.iterator();
        while (i.hasNext()) {
            parts[counter] = new StringPart("scenario[tag" + tagNum++ + "]", i.next());
            ++counter;
        }
        postMethod = new PostMethod(String.valueOf(hostAddress) + "upload-scenario");
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
        response = httpClient.executeMethod((HttpMethod)postMethod);
        if (response > 400) {
            this.error(String.valueOf(Config.getString((String)"export.publish.errorResponse")) + " - " + response);
            return this;
        }
        if (!this.handleResponse(postMethod)) {
            return this;
        }
        this.listener.uploadComplete(new PublishEvent(1));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleResponse(PostMethod postMethod) {
        Header statusHeader = postMethod.getResponseHeader("X-mygame-status");
        if (statusHeader == null) {
            this.error(Config.getString((String)"export.publish.errorResponse"));
            return false;
        }
        String responseString = statusHeader.getValue();
        int spaceIndex = responseString.indexOf(" ");
        if (spaceIndex == -1) {
            this.error(Config.getString((String)"export.publish.errorResponse"));
            return false;
        }
        try {
            int statusCode = Integer.parseInt(responseString.substring(0, spaceIndex));
            switch (statusCode) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.error(Config.getString((String)"export.publish.errorPassword"));
                    return false;
                }
                case 2: {
                    this.error(Config.getString((String)"export.publish.errorTooLarge"));
                    return false;
                }
            }
            this.error(responseString.substring(spaceIndex + 1));
            return false;
        }
        catch (NumberFormatException nfe) {
            this.error(Config.getString((String)"export.publish.errorResponse"));
            return false;
        }
    }

    protected HttpClient getHttpClient() {
        HttpClient httpClient = new HttpClient();
        String proxyHost = Config.getPropString((String)"proxy.host", null);
        String proxyPortStr = Config.getPropString((String)"proxy.port", null);
        if (proxyHost != null && proxyHost.length() != 0 && proxyPortStr != null) {
            HostConfiguration hostConfig = httpClient.getHostConfiguration();
            int proxyPort = 80;
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            hostConfig.setProxy(proxyHost, proxyPort);
            String proxyUser = Config.getPropString((String)"proxy.user", null);
            String proxyPass = Config.getPropString((String)"proxy.password", null);
            if (proxyUser != null) {
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUser, proxyPass);
                httpClient.getState().setProxyCredentials(authScope, (Credentials)proxyCreds);
            }
        }
        return httpClient;
    }

    public boolean checkExistingScenario(String hostAddress, String uid, String gameName, ScenarioInfo info) throws UnknownHostException, IOException {
        HttpClient client = this.getHttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(20000);
        String encodedName = URLEncoder.encode(gameName, "UTF-8");
        encodedName = encodedName.replace("+", "%20");
        GetMethod getMethod = new GetMethod(String.valueOf(hostAddress) + "user/" + uid + "/check_scenario/" + encodedName);
        int response = client.executeMethod((HttpMethod)getMethod);
        if (response > 400) {
            throw new IOException("HTTP error response " + response + " from server.");
        }
        Header statusHeader = getMethod.getResponseHeader("X-mygame-scenario");
        if (statusHeader == null) {
            throw new IOException("X-mygame-scenario header missing from server response");
        }
        if (!statusHeader.getValue().equals("0 FOUND")) {
            return false;
        }
        if (info != null) {
            InputStream responseStream = getMethod.getResponseBodyAsStream();
            this.parseScenarioXml(info, responseStream);
            info.setTitle(gameName);
        }
        return true;
    }

    private void parseScenarioXml(ScenarioInfo info, InputStream xmlStream) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            Document doc = dbuilder.parse(xmlStream);
            Element root = doc.getDocumentElement();
            if (root == null || !root.getTagName().equals("scenario")) {
                return;
            }
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() == 1) {
                    Element element = (Element)childNode;
                    if (element.getTagName().equals("shortdescription")) {
                        info.setShortDescription(element.getTextContent());
                    } else if (element.getTagName().equals("longdescription")) {
                        info.setLongDescription(element.getTextContent());
                    } else if (element.getTagName().equals("taglist")) {
                        info.setTags(this.parseTagListXmlElement(element));
                    } else if (element.getTagName().equals("webpage")) {
                        info.setUrl(element.getTextContent());
                    } else if (element.getTagName().equals("hassource")) {
                        info.setHasSource(element.getTextContent().equals("true"));
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private List<String> parseTagListXmlElement(Element element) {
        ArrayList<String> tags = new ArrayList<String>();
        Node child = element.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("tag")) {
                tags.add(element.getTextContent());
            }
            child = child.getNextSibling();
        }
        return tags;
    }

    public List<String> getCommonTags(String hostAddress, int maxNumberOfTags) throws UnknownHostException, IOException {
        HttpClient client = this.getHttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(20000);
        GetMethod getMethod = new GetMethod(String.valueOf(hostAddress) + "common-tags/" + maxNumberOfTags);
        int response = client.executeMethod((HttpMethod)getMethod);
        if (response > 400) {
            throw new IOException("HTTP error response " + response + " from server.");
        }
        InputStream responseStream = getMethod.getResponseBodyAsStream();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            Document doc = dbuilder.parse(responseStream);
            Element root = doc.getDocumentElement();
            if (root == null || !root.getTagName().equals("taglist")) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = this.parseTagListXmlElement(root);
            return list;
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        finally {
            responseStream.close();
        }
        return Collections.emptyList();
    }

    private void error(String s) {
        this.listener.errorRecieved(new PublishEvent(s, 0));
    }

    public void progress(int bytes) {
        this.listener.progressMade(new PublishEvent(bytes, 2));
    }

    public String[] promptProxyAuth() {
        return this.listener.needProxyAuth();
    }
}

