/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import bluej.utility.Debug;
import greenfoot.core.WorldHandler;
import greenfoot.gui.AskPanel;
import greenfoot.gui.WorldCanvas;
import greenfoot.util.GreenfootUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;

public class AskHandler {
    private final AskPanel askPanel;
    private final WorldCanvas worldCanvas;
    private final ArrayBlockingQueue<String> answer = new ArrayBlockingQueue(1);

    public AskHandler(AskPanel askPanel, WorldCanvas worldCanvas) {
        this.askPanel = askPanel;
        this.worldCanvas = worldCanvas;
    }

    public Callable<String> ask(String prompt, int worldWidth) {
        Image snapshot = this.getWorldGreyedSnapShot();
        if (snapshot != null) {
            this.worldCanvas.setOverrideImage(snapshot);
        }
        this.askPanel.showPanel(Math.max(400, worldWidth), prompt, new AskPanel.AnswerListener(){

            @Override
            public void answered(String answer) {
                AskHandler.this.worldCanvas.setOverrideImage(null);
                try {
                    AskHandler.this.answer.put(answer);
                }
                catch (InterruptedException e) {
                    Debug.reportError((Throwable)e);
                }
            }
        });
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                return (String)AskHandler.this.answer.take();
            }
        };
    }

    private Image getWorldGreyedSnapShot() {
        BufferedImage screenShot = WorldHandler.getInstance().getSnapShot();
        if (screenShot != null) {
            GreenfootUtil.convertToGreyImage(screenShot);
        }
        return screenShot;
    }

    public void stopWaitingForAnswer() {
        if (this.askPanel.isPanelShowing()) {
            this.askPanel.hidePanel();
            try {
                this.answer.put("");
            }
            catch (InterruptedException e) {
                Debug.reportError((Throwable)e);
            }
        }
    }
}

