/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.classmgr.BPClassLoader;
import bluej.compiler.CompileObserver;
import bluej.compiler.Compiler;
import bluej.compiler.CompilerAPICompiler;
import bluej.compiler.CompilerThread;
import bluej.compiler.Job;
import bluej.utility.Utility;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class JobQueue {
    private static JobQueue queue = null;
    private CompilerThread thread = null;
    private Compiler compiler = new CompilerAPICompiler();

    public static synchronized JobQueue getJobQueue() {
        if (queue == null) {
            queue = new JobQueue();
        }
        return queue;
    }

    private JobQueue() {
        this.thread = new CompilerThread();
        int priority = Thread.currentThread().getPriority() - 1;
        priority = Math.max(priority, 1);
        this.thread.setPriority(priority);
        this.thread.start();
    }

    public void addJob(File[] sources, CompileObserver observer, BPClassLoader bpClassLoader, File destDir, boolean suppressUnchecked, Charset fileCharset) {
        String optionString;
        ArrayList<String> options = new ArrayList<String>();
        if (bpClassLoader.loadsForJavaMEproject()) {
            optionString = Config.getPropString("bluej.javame.compiler.options", "");
            options.addAll(Utility.dequoteCommandLine(optionString));
        }
        optionString = Config.getPropString("bluej.compiler.options", "");
        options.addAll(Utility.dequoteCommandLine(optionString));
        this.thread.addJob(new Job(sources, this.compiler, observer, bpClassLoader, destDir, suppressUnchecked, options, fileCharset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEmptyQueue() {
        CompilerThread compilerThread = this.thread;
        synchronized (compilerThread) {
            while (this.thread.isBusy()) {
                try {
                    this.thread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

