/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import bluej.groupwork.CodeFileFilter;
import bluej.groupwork.CvsProvider;
import bluej.groupwork.Repository;
import bluej.groupwork.SubversionProvider;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class TeamSettingsController {
    private static ArrayList<TeamworkProvider> teamProviders = new ArrayList(2);
    private Project project;
    private File projectDir;
    private Properties teamProperties;
    private TeamSettingsDialog teamSettingsDialog;
    private TeamSettings settings;
    private String password;
    private File teamdefs;
    private Repository repository;

    public TeamSettingsController(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDir();
        this.teamProperties = new Properties();
        this.readSetupFile();
    }

    public TeamSettingsController(File projectDir) {
        this.projectDir = projectDir;
        this.teamProperties = new Properties();
    }

    public void setProject(Project proj) {
        this.project = proj;
        this.projectDir = proj.getProjectDir();
        this.repository = null;
        this.checkTeamSettingsDialog();
    }

    public List<TeamworkProvider> getTeamworkProviders() {
        return teamProviders;
    }

    public Repository getRepository(boolean authRequired) {
        if (authRequired && this.password == null) {
            this.getTeamSettingsDialog().doTeamSettings();
            if (this.password == null) {
                return null;
            }
            TeamSettings settings = this.teamSettingsDialog.getSettings();
            if (this.repository == null) {
                this.repository = settings.getProvider().getRepository(this.projectDir, settings);
            } else {
                this.repository.setPassword(settings);
            }
        } else {
            if (!authRequired && this.password == null) {
                return this.settings.getProvider().getRepository(this.projectDir, this.settings);
            }
            if (this.repository == null) {
                this.repository = this.settings.getProvider().getRepository(this.projectDir, this.settings);
            }
        }
        return this.repository;
    }

    public boolean initRepository() {
        if (this.repository == null) {
            TeamworkProvider provider = this.settings.getProvider();
            if (this.password == null && this.getTeamSettingsDialog().doTeamSettings() == 1) {
                return false;
            }
            this.repository = provider.getRepository(this.projectDir, this.settings);
        }
        return true;
    }

    public Set<File> getProjectFiles(boolean includeLayout) {
        this.initRepository();
        boolean versionsDirs = false;
        if (this.repository != null) {
            versionsDirs = this.repository.versionsDirectories();
        }
        Set<File> files = this.project.getFilesInProject(includeLayout, versionsDirs);
        if (this.repository != null) {
            this.repository.getAllLocallyDeletedFiles(files);
        }
        return files;
    }

    public FileFilter getFileFilter(boolean includeLayout) {
        this.initRepository();
        FileFilter repositoryFilter = null;
        if (this.repository != null) {
            repositoryFilter = this.repository.getMetadataFilter();
        }
        return new CodeFileFilter(this.getIgnoreFiles(), includeLayout, repositoryFilter);
    }

    private void readSetupFile() {
        this.teamdefs = new File(this.projectDir, "team.defs");
        try {
            this.teamProperties.load(new FileInputStream(this.teamdefs));
            if (this.teamProperties.getProperty("bluej.teamsettings.vcs") == null) {
                this.teamProperties.setProperty("bluej.teamsettings.vcs", "cvs");
            }
            this.initSettings();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initSettings() {
        String group;
        String user = this.getPropString("bluej.teamsettings.user");
        if (user == null) {
            user = "";
        }
        if ((group = this.getPropString("bluej.teamsettings.groupname")) == null) {
            group = "";
        }
        TeamworkProvider provider = null;
        String providerName = this.getPropString("bluej.teamsettings.vcs");
        if (providerName != null) {
            for (int index = 0; index < teamProviders.size(); ++index) {
                TeamworkProvider prov = teamProviders.get(index);
                if (!prov.getProviderName().equalsIgnoreCase(providerName)) continue;
                provider = prov;
            }
        }
        if (provider != null) {
            this.settings = this.initProviderSettings(user, group, this.password, provider);
        }
    }

    public TeamSettings initProviderSettings(String user, String group, String password, TeamworkProvider provider) {
        String keyBase = "bluej.teamsettings." + provider.getProviderName().toLowerCase() + ".";
        String prefix = this.getPropString(keyBase + "repositoryPrefix");
        String server = this.getPropString(keyBase + "server");
        String protocol = this.getPropString(keyBase + "protocol");
        return new TeamSettings(provider, protocol, server, prefix, group, user, password);
    }

    public boolean prepareDeleteDir(File dir) {
        return this.getRepository(false).prepareDeleteDir(dir);
    }

    public void prepareCreateDir(File dir) {
        this.getRepository(false).prepareCreateDir(dir);
    }

    public TeamSettingsDialog getTeamSettingsDialog() {
        if (this.teamSettingsDialog == null) {
            this.teamSettingsDialog = new TeamSettingsDialog(this);
            this.teamSettingsDialog.setLocationRelativeTo(PkgMgrFrame.getMostRecent());
            this.checkTeamSettingsDialog();
        }
        return this.teamSettingsDialog;
    }

    private void checkTeamSettingsDialog() {
        if (this.teamSettingsDialog != null && this.project != null) {
            this.teamSettingsDialog.disableRepositorySettings();
        }
    }

    public void writeToProject() {
        if (this.projectDir == null) {
            return;
        }
        File cfgFile = new File(this.projectDir + "/team.defs");
        if (!cfgFile.exists()) {
            this.addIgnoreFilePatterns(this.teamProperties);
        }
        try {
            this.teamProperties.store(new FileOutputStream(cfgFile), null);
            this.repository = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addIgnoreFilePatterns(Properties teamProperties) {
        teamProperties.put("bluej.teamsettings.ignore1", ".*\\.class");
        teamProperties.put("bluej.teamsettings.ignore2", "bluej\\.pkh");
        teamProperties.put("bluej.teamsettings.ignore3", "team\\.defs");
        teamProperties.put("bluej.teamsettings.ignore4", ".*\\.ctxt");
        teamProperties.put("bluej.teamsettings.ignore5", ".*\\~");
        teamProperties.put("bluej.teamsettings.ignore6", ".*\\#");
        teamProperties.put("bluej.teamsettings.ignore7", ".*\\#backup");
        teamProperties.put("bluej.teamsettings.ignore8", "\\.DS_Store");
    }

    public String getPropString(String strname) {
        String result = this.teamProperties.getProperty(strname);
        if (result != null) {
            return result;
        }
        result = Config.getPropString(strname, null);
        return result;
    }

    public void setPropString(String key, String value) {
        this.teamProperties.setProperty(key, value);
    }

    public void updateSettings(TeamSettings newSettings, boolean useAsDefault) {
        this.settings = newSettings;
        String userKey = "bluej.teamsettings.user";
        String userValue = this.settings.getUserName();
        this.setPropString(userKey, userValue);
        String providerKey = "bluej.teamsettings.vcs";
        String providerName = newSettings.getProvider().getProviderName().toLowerCase();
        this.setPropString(providerKey, providerName);
        String keyBase = "bluej.teamsettings." + providerName + ".";
        String serverKey = keyBase + "server";
        String serverValue = this.settings.getServer();
        this.setPropString(serverKey, serverValue);
        String prefixKey = keyBase + "repositoryPrefix";
        String prefixValue = this.settings.getPrefix();
        this.setPropString(prefixKey, prefixValue);
        String protocolKey = keyBase + "protocol";
        String protocolValue = this.settings.getProtocol();
        this.setPropString(protocolKey, protocolValue);
        String groupKey = "bluej.teamsettings.groupname";
        String groupValue = this.settings.getGroup();
        this.setPropString(groupKey, groupValue);
        String useAsDefaultKey = "bluej.teamsettings.useAsDefault";
        Config.putPropString(useAsDefaultKey, Boolean.toString(useAsDefault));
        String passValue = this.settings.getPassword();
        this.setPasswordString(passValue);
        if (this.repository != null) {
            TeamSettings settings = this.getTeamSettingsDialog().getSettings();
            this.repository.setPassword(settings);
        }
        if (useAsDefault) {
            Config.putPropString(providerKey, providerName);
            Config.putPropString(userKey, userValue);
            Config.putPropString(serverKey, serverValue);
            Config.putPropString(prefixKey, prefixValue);
            Config.putPropString(groupKey, groupValue);
            Config.putPropString(protocolKey, protocolValue);
        }
    }

    public String getPasswordString() {
        return this.password;
    }

    private void setPasswordString(String password) {
        this.password = password;
    }

    public boolean hasPasswordString() {
        return this.password != null;
    }

    public List<String> getIgnoreFiles() {
        Iterator<Object> keys = this.teamProperties.keySet().iterator();
        LinkedList<String> patterns = new LinkedList<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.startsWith("bluej.teamsettings.cvs.ignore")) {
                patterns.add(this.teamProperties.getProperty(key));
            }
            if (!key.startsWith("bluej.teamsettings.ignore")) continue;
            patterns.add(this.teamProperties.getProperty(key));
        }
        return patterns;
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public Project getProject() {
        return this.project;
    }

    static {
        try {
            teamProviders.add(new CvsProvider());
        }
        catch (Throwable e) {
            Debug.message("Failed to initialize Cvs: " + e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        try {
            teamProviders.add(new SubversionProvider());
        }
        catch (Throwable e) {
            Debug.message("Failed to initialize Subversion: " + e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
    }
}

