/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.UnableToParseInputException;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.cvsnb.BasicServerResponse;
import bluej.groupwork.cvsnb.BlueJCvsClient;
import bluej.groupwork.cvsnb.CvsUpdateResult;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;

public class UpdateServerResponse
extends BasicServerResponse
implements UpdateResults {
    private final StringBuffer taggedLine = new StringBuffer();
    private List<CvsUpdateResult> updateResults = new LinkedList<CvsUpdateResult>();
    private List<String> newDirectoryNames = new LinkedList<String>();
    private UpdateListener listener;
    private Map<File, File> conflictsMap;
    private BlueJCvsClient client;

    public UpdateServerResponse(UpdateListener listener, BlueJCvsClient client) {
        this.listener = listener;
        this.client = client;
    }

    @Override
    public void messageSent(MessageEvent e) {
        String line;
        block9: {
            block7: {
                int n;
                int offset;
                block8: {
                    line = e.getMessage();
                    if (e.isTagged() && (line = MessageEvent.parseTaggedMessage((StringBuffer)this.taggedLine, (String)line)) == null) {
                        return;
                    }
                    if (!e.isError()) break block7;
                    offset = 27;
                    if (line.startsWith("cvs update: New directory") || line.startsWith("cvs server: New directory")) break block8;
                    offset = 29;
                    if (29 == 0 || !line.startsWith("cvs checkout: New directory")) break block9;
                }
                if ((n = line.lastIndexOf("-- ignored")) != -1) {
                    String dirName = line.substring(offset, n - 2);
                    this.newDirectoryNames.add(dirName);
                }
                break block9;
            }
            if (line.startsWith("Merging differences between ") && this.client != null) {
                this.client.nextConflictNonBinary();
            }
        }
        try {
            CvsUpdateResult updateResult = CvsUpdateResult.parse(line);
            this.updateResults.add(updateResult);
        }
        catch (UnableToParseInputException unableToParseInputException) {
            // empty catch block
        }
    }

    @Override
    public void fileUpdated(FileUpdatedEvent arg0) {
        if (this.listener != null) {
            String filePath = arg0.getFilePath();
            this.listener.fileUpdated(new File(filePath));
        }
    }

    @Override
    public void fileAdded(FileAddedEvent arg0) {
        if (this.listener != null) {
            String filePath = arg0.getFilePath();
            this.listener.fileAdded(new File(filePath));
        }
    }

    @Override
    public void fileRemoved(FileRemovedEvent arg0) {
        if (this.listener != null) {
            String filePath = arg0.getFilePath();
            this.listener.fileRemoved(new File(filePath));
        }
    }

    private List<CvsUpdateResult> getUpdateResultsOfType(char type) {
        LinkedList<CvsUpdateResult> results = new LinkedList<CvsUpdateResult>();
        for (CvsUpdateResult updateResult : this.updateResults) {
            if (updateResult.getStatusCode() != type) continue;
            results.add(updateResult);
        }
        return results;
    }

    @Override
    public List<File> getConflicts() {
        this.waitForExecutionToFinish();
        List<CvsUpdateResult> curList = this.getUpdateResultsOfType('C');
        ArrayList<File> fileList = new ArrayList<File>(curList.size());
        for (CvsUpdateResult result : curList) {
            fileList.add(new File(this.client.getLocalPath(), result.getFilename()));
        }
        return fileList;
    }

    public List<CvsUpdateResult> getUpdated() {
        this.waitForExecutionToFinish();
        return this.getUpdateResultsOfType('U');
    }

    public List<String> getNewDirectoryNames() {
        return this.newDirectoryNames;
    }

    public void setConflictMap(Map<File, File> m) {
        this.conflictsMap = m;
    }

    @Override
    public Set<File> getBinaryConflicts() {
        return this.conflictsMap.keySet();
    }

    @Override
    public void overrideFiles(Set<File> files) {
        for (File file : files) {
            File backupFile = this.conflictsMap.remove(file);
            if (backupFile == null) continue;
            backupFile.delete();
        }
        for (Map.Entry entry : this.conflictsMap.entrySet()) {
            File f = (File)entry.getKey();
            File backupFile = (File)entry.getValue();
            f.delete();
            backupFile.renameTo(f);
        }
    }
}

