/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import bluej.utility.Debug;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.StatusCallback;

public class SvnCommitAllCommand
extends SvnCommand {
    protected Set<File> newFiles;
    protected Set<File> binaryNewFiles;
    protected Set<File> deletedFiles;
    protected Set<File> files;
    protected String commitComment;

    public SvnCommitAllCommand(SvnRepository repository, Set<File> newFiles, Set<File> binaryNewFiles, Set<File> deletedFiles, Set<File> files, String commitComment) {
        super(repository);
        this.newFiles = newFiles;
        this.binaryNewFiles = binaryNewFiles;
        this.deletedFiles = deletedFiles;
        this.files = files;
        this.commitComment = commitComment;
    }

    @Override
    protected TeamworkCommandResult doCommand() {
        block7: {
            SVNClientInterface client = this.getClient();
            try {
                Status status;
                class StatusRef {
                    Status status;

                    StatusRef() {
                    }
                }
                StatusRef statusRef;
                for (File newFile : this.newFiles) {
                    statusRef = new StatusRef();
                    client.status(newFile.getAbsolutePath(), 0, false, true, true, false, null, new StatusCallback(){
                        {
                        }

                        public void doStatus(Status status) {
                            statusRef.status = status;
                        }
                    });
                    status = statusRef.status;
                    if (status.isManaged()) continue;
                    client.add(newFile.getAbsolutePath(), 0, false, false, true);
                    if (newFile.isDirectory()) continue;
                    client.propertySet(newFile.getAbsolutePath(), "svn:eol-style", "native", 0, null, false, null);
                }
                for (File newFile : this.binaryNewFiles) {
                    statusRef = new StatusRef();
                    client.status(newFile.getAbsolutePath(), 0, false, true, true, false, null, new StatusCallback(){
                        {
                        }

                        public void doStatus(Status status) {
                            statusRef.status = status;
                        }
                    });
                    status = statusRef.status;
                    if (status.isManaged()) continue;
                    client.add(newFile.getAbsolutePath(), 0, false, false, true);
                    if (newFile.isDirectory()) continue;
                    client.propertySet(newFile.getAbsolutePath(), "svn:mime-type", "application/octet-stream", 0, null, false, null);
                }
                for (File newFile : this.deletedFiles) {
                    client.remove(new String[]{newFile.getAbsolutePath()}, "", true, false, Collections.emptyMap());
                }
                String[] commitFiles = new String[this.files.size()];
                Iterator<File> i = this.files.iterator();
                for (int j = 0; j < commitFiles.length; ++j) {
                    File file = i.next();
                    commitFiles[j] = file.getAbsolutePath();
                }
                client.commit(commitFiles, this.commitComment, 0, false, false, null, Collections.emptyMap());
                if (!this.isCancelled()) {
                    return new TeamworkCommandResult();
                }
            }
            catch (ClientException ce) {
                if (this.isCancelled()) break block7;
                Debug.reportError("Subversion commit all exception", ce);
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
        }
        return new TeamworkCommandAborted();
    }
}

